/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SteeringProperties.PathFollowingProperties;
import SteeringProperties.SteeringProperties;
import SteeringStuff.ISteering;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringTools;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.utils.future.FutureStatus;
import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class PathFollowingSteer
implements ISteering {
    private UT2004Bot botself;
    private int repulsiveForce;
    int distanceFromThePath;
    IPathFuture<ILocated> pathFuture;
    List<ILocated> path;
    double regulatingForce;
    private int projection;
    private static int NEARLY_THERE_DISTANCE = 150;
    Location previousLocation;
    Location nextLocation;
    int actualIndex;
    double lastDistanceFromNextLocation;
    boolean newPath;
    private static boolean ZERO_DISTANCE = false;

    public PathFollowingSteer(UT2004Bot bot) {
        this.botself = bot;
        this.actualIndex = 0;
    }

    @Override
    public Vector3d run(Vector3d scaledActualVelocity, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, Location focus) {
        Vector3d actualVelocity = this.botself.getVelocity().getVector3d();
        Vector3d nextVelocity = new Vector3d(0.0, 0.0, 0.0);
        if (this.pathFuture == null) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        if (!this.newPath && this.pathFuture.getStatus() != FutureStatus.FUTURE_IS_READY) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        if (this.newPath && this.pathFuture.getStatus() == FutureStatus.FUTURE_IS_READY) {
            this.setComputedPath();
        }
        if (this.path == null) {
            this.setComputedPath();
        }
        boolean shifted = this.shiftNextLocation();
        double distanceFromNextLocation = this.botself.getLocation().getDistance(this.nextLocation);
        if (ZERO_DISTANCE) {
            if (shifted && this.actualIndex + 1 >= this.path.size()) {
                if (distanceFromNextLocation <= (double)NEARLY_THERE_DISTANCE) {
                    wantsToStop.setValue(true);
                }
                return nextVelocity;
            }
            Location botsLoc = this.botself.getLocation();
            Vector3d toNextLoc = new Vector3d(this.nextLocation.x - botsLoc.x, this.nextLocation.y - botsLoc.y, this.nextLocation.z - botsLoc.z);
            toNextLoc.normalize();
            toNextLoc.scale((double)this.repulsiveForce);
            nextVelocity.add((Tuple3d)toNextLoc);
            return nextVelocity;
        }
        if (!shifted) {
            if (this.lastDistanceFromNextLocation < distanceFromNextLocation) {
                this.lastDistanceFromNextLocation = distanceFromNextLocation;
                Vector3d rightDirectionForce = new Vector3d(this.nextLocation.x - this.previousLocation.x, this.nextLocation.y - this.previousLocation.y, 0.0);
                rightDirectionForce.normalize();
                double scale = rightDirectionForce.angle(this.botself.getVelocity().getVector3d()) / Math.PI;
                rightDirectionForce.scale((double)this.repulsiveForce * scale);
                nextVelocity.add((Tuple3d)rightDirectionForce);
                wantsToGoFaster.setValue(false);
                return nextVelocity;
            }
            this.lastDistanceFromNextLocation = distanceFromNextLocation;
        } else {
            this.lastDistanceFromNextLocation = distanceFromNextLocation;
            if (this.actualIndex + 1 >= this.path.size()) {
                if (distanceFromNextLocation <= (double)NEARLY_THERE_DISTANCE) {
                    wantsToStop.setValue(true);
                } else {
                    Vector3d botToNextLocation = new Vector3d(this.nextLocation.x - this.botself.getLocation().x, this.nextLocation.y - this.botself.getLocation().y, this.nextLocation.z - this.botself.getLocation().z);
                    botToNextLocation.scale(actualVelocity.length() / botToNextLocation.length());
                    nextVelocity.add((Tuple3d)botToNextLocation);
                }
                return nextVelocity;
            }
        }
        ConfigChange cc = (ConfigChange)this.botself.getWorldView().getSingle(ConfigChange.class);
        double oneTick = cc.getVisionTime();
        double projectionTime = (double)this.projection * oneTick;
        Vector3d shift = new Vector3d(projectionTime * actualVelocity.x, projectionTime * actualVelocity.y, projectionTime * actualVelocity.z);
        Location pointHeading = new Location(this.botself.getLocation().x + shift.x, this.botself.getLocation().y + shift.y, this.botself.getLocation().z + shift.z);
        Vector2d start = new Vector2d(this.previousLocation.x, this.previousLocation.y);
        Vector2d end = new Vector2d(this.nextLocation.x, this.nextLocation.y);
        Vector2d pointP = new Vector2d(pointHeading.x, pointHeading.y);
        Vector2d foot = SteeringTools.getNearestPoint(start, end, pointP, false);
        Vector3d pointHeadingToFoot = new Vector3d(foot.x - pointHeading.getX(), foot.y - pointHeading.getY(), 0.0);
        if (pointHeadingToFoot.length() > (double)this.distanceFromThePath) {
            double distOut = pointHeadingToFoot.length() - (double)this.distanceFromThePath;
            double koefA = distOut / (double)this.distanceFromThePath;
            if (koefA > 2.0) {
                koefA = 2.0;
            }
            nextVelocity.add((Tuple3d)pointHeadingToFoot);
            nextVelocity.normalize();
            nextVelocity.scale(koefA * (double)this.repulsiveForce + 30.0);
            wantsToGoFaster.setValue(false);
        } else {
            wantsToGoFaster.setValue(true);
        }
        Vector3d regulatingVector = new Vector3d(this.nextLocation.x - this.previousLocation.x, this.nextLocation.y - this.previousLocation.y, 0.0);
        regulatingVector.normalize();
        regulatingVector.scale(this.regulatingForce);
        nextVelocity.add((Tuple3d)regulatingVector);
        return nextVelocity;
    }

    private boolean shiftNextLocation() {
        if (this.path == null) {
            return false;
        }
        if (this.botself.getLocation().getDistance(this.nextLocation) <= (double)this.distanceFromThePath || this.getBehindBorder()) {
            ILocated help;
            if (this.actualIndex + 1 < this.path.size() && (help = this.path.get(this.actualIndex + 1)) != null) {
                ++this.actualIndex;
                this.previousLocation = this.nextLocation;
                this.nextLocation = help.getLocation();
            }
            return true;
        }
        return false;
    }

    private boolean getBehindBorder() {
        Vector2d startA = new Vector2d(this.previousLocation.x, this.previousLocation.y);
        Vector2d endA = new Vector2d(this.botself.getLocation().x, this.botself.getLocation().y);
        Vector2d directionA = new Vector2d(endA.x - startA.x, endA.y - startA.y);
        Vector2d startB = new Vector2d(this.nextLocation.x, this.nextLocation.y);
        Vector2d normalDirectionB = new Vector2d(this.nextLocation.x - this.previousLocation.x, this.nextLocation.y - this.previousLocation.y);
        Vector2d directionB = new Vector2d(-normalDirectionB.y, normalDirectionB.x);
        Vector2d intersection = SteeringTools.getIntersection(startA, directionA, startB, directionB, SteeringTools.LineType.ABSCISSA, SteeringTools.LineType.STRAIGHT_LINE);
        return intersection != null;
    }

    private boolean setComputedPath() {
        List myNewPath = this.pathFuture.get();
        if (myNewPath == null) {
            return false;
        }
        if (myNewPath.size() < 1) {
            return false;
        }
        if (this.differentNewPath(myNewPath)) {
            this.path = myNewPath;
            this.actualIndex = this.getIndexOfNearestILocated();
            this.nextLocation = this.path.get(this.actualIndex).getLocation();
            this.previousLocation = this.botself.getLocation();
            this.lastDistanceFromNextLocation = this.botself.getLocation().getDistance(this.nextLocation);
        }
        this.newPath = false;
        return true;
    }

    private boolean differentNewPath(List<ILocated> myNewPath) {
        if (this.path == null) {
            return true;
        }
        if (myNewPath == null) {
            return false;
        }
        if (this.path.size() != myNewPath.size()) {
            return true;
        }
        for (int i = 0; i < this.path.size(); ++i) {
            ILocated b;
            ILocated a = this.path.get(i);
            if (a.equals(b = myNewPath.get(i))) continue;
            return true;
        }
        return false;
    }

    private int getIndexOfNearestILocated() {
        int result = 0;
        Location botsLocation = this.botself.getLocation();
        double dist = botsLocation.getDistance(this.path.get(0).getLocation());
        for (int index = 0; index < this.path.size(); ++index) {
            ILocated il = this.path.get(index);
            if (!(botsLocation.getDistance(il.getLocation()) < dist)) continue;
            result = index;
            dist = botsLocation.getDistance(il.getLocation());
        }
        return result;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.repulsiveForce = ((PathFollowingProperties)newProperties).getRepulsiveForce();
        this.distanceFromThePath = ((PathFollowingProperties)newProperties).getDistanceFromThePath();
        this.pathFuture = ((PathFollowingProperties)newProperties).getPath();
        this.regulatingForce = ((PathFollowingProperties)newProperties).getRegulatingForce();
        this.projection = ((PathFollowingProperties)newProperties).getProjection();
        this.newPath = this.path != null;
    }

    public PathFollowingProperties getProperties() {
        PathFollowingProperties properties = new PathFollowingProperties();
        properties.setRepulsiveForce(this.repulsiveForce);
        properties.setDistanceFromThePath(this.distanceFromThePath);
        properties.setPath(this.pathFuture);
        properties.setRegulatingForce(this.regulatingForce);
        properties.setProjection(this.projection);
        return properties;
    }
}

