/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SteeringProperties.SteeringProperties;
import SteeringProperties.WalkAlongProperties;
import SteeringStuff.ISteering;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringTools;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Collection;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class WalkAlongSteer
implements ISteering {
    private UT2004Bot botself;
    private Location targetLocation;
    private int partnerForce;
    private int distanceFromThePartner;
    private String partnerName;
    private boolean giveWayToPartner;
    private boolean waitForPartner;
    private boolean turn = true;
    private boolean newToPartner = false;
    private boolean newToPartner2 = false;
    private boolean newWait = false;
    private boolean truncateToPartner = false;
    private boolean truncateNextVelocity = false;
    private static int MAX_TO_PARTNER = 500;
    private static int MAX_NEXT_VELOCITY = 500;
    private static int WAIT_DISTANCE = 100;
    private static int NEARLY_THERE_DISTANCE = 200;
    private boolean waiting;
    private Player partner;
    private Vector3d forceToTarget;
    private Vector3d forceToPartner;
    private Vector3d forceFromPartner;

    public WalkAlongSteer(UT2004Bot bot) {
        this.botself = bot;
        this.waiting = false;
    }

    @Override
    public Vector3d run(Vector3d scaledActualVelocity, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, Location focus) {
        double scale;
        Location targetHis;
        Location targetMy;
        Vector3d actualVelocity = this.botself.getVelocity().getVector3d();
        Vector3d nextVelocity = new Vector3d(0.0, 0.0, 0.0);
        if (this.partner == null || this.partner.getLocation() == null) {
            this.partner = this.getPartner();
            if (this.turn) {
                Vector3d turningVector = new Vector3d(actualVelocity.y, -actualVelocity.x, 0.0);
                turningVector.scale(1.0 / Math.sqrt(2.0));
                Vector3d negativeVector = new Vector3d(-actualVelocity.x, -actualVelocity.y, 0.0);
                negativeVector.scale(1.0 - 1.0 / Math.sqrt(2.0));
                turningVector.add((Tuple3d)negativeVector);
                return turningVector;
            }
            wantsToStop.setValue(true);
            return nextVelocity;
        }
        Location middlePoint = new Location((this.botself.getLocation().x + this.partner.getLocation().x) / 2.0, (this.botself.getLocation().y + this.partner.getLocation().y) / 2.0, this.botself.getLocation().z);
        Vector2d middlePointToTarget = new Vector2d(this.targetLocation.x - middlePoint.x, this.targetLocation.y - middlePoint.y);
        Vector2d middlePointToTargetNormal = new Vector2d(-middlePointToTarget.y, middlePointToTarget.x);
        middlePointToTargetNormal.normalize();
        middlePointToTargetNormal.scale((double)(this.distanceFromThePartner / 2));
        Location targetA = new Location(this.targetLocation.x + middlePointToTargetNormal.x, this.targetLocation.y + middlePointToTargetNormal.y, this.targetLocation.z);
        Location targetB = new Location(this.targetLocation.x - middlePointToTargetNormal.x, this.targetLocation.y - middlePointToTargetNormal.y, this.targetLocation.z);
        if (this.botself.getLocation().getDistance(targetA) < this.botself.getLocation().getDistance(targetB)) {
            targetMy = targetA;
            targetHis = targetB;
        } else {
            targetMy = targetB;
            targetHis = targetA;
        }
        if (this.botself.getLocation().getDistance(targetMy) < (double)NEARLY_THERE_DISTANCE) {
            wantsToStop.setValue(true);
            focus.setTo(this.partner.getLocation());
            return nextVelocity;
        }
        Vector3d myVectorToTarget = new Vector3d(targetMy.x - this.botself.getLocation().x, targetMy.y - this.botself.getLocation().y, targetMy.z - this.botself.getLocation().z);
        Vector3d partnersVectorToTarget = new Vector3d(targetHis.x - this.partner.getLocation().x, targetHis.y - this.partner.getLocation().y, targetHis.z - this.partner.getLocation().z);
        if (partnersVectorToTarget.length() > myVectorToTarget.length()) {
            // empty if block
        }
        this.forceToTarget = new Vector3d(targetMy.x - this.botself.getLocation().x, targetMy.y - this.botself.getLocation().y, 0.0);
        this.forceToTarget.normalize();
        Vector2d startC = new Vector2d(middlePoint.x, middlePoint.y);
        Vector2d endC = new Vector2d(this.targetLocation.x, this.targetLocation.y);
        Vector2d myLoc = new Vector2d(this.botself.getLocation().x, this.botself.getLocation().y);
        Vector2d foot = SteeringTools.getNearestPoint(startC, endC, myLoc, false);
        Vector3d footToBot = new Vector3d(myLoc.x - foot.x, myLoc.y - foot.y, 0.0);
        double fromFoot = footToBot.length();
        Vector3d botToFoot = new Vector3d(-footToBot.x, -footToBot.y, -footToBot.z);
        footToBot.normalize();
        botToFoot.normalize();
        Vector3d footToBotCopy = new Vector3d(footToBot.x, footToBot.y, footToBot.z);
        Vector3d partnerToBot = new Vector3d(this.botself.getLocation().x - this.partner.getLocation().x, this.botself.getLocation().y - this.partner.getLocation().y, this.botself.getLocation().z - this.partner.getLocation().z);
        double fromPartner = partnerToBot.length();
        partnerToBot.normalize();
        Vector3d botToPartner = new Vector3d(this.partner.getLocation().x - this.botself.getLocation().x, this.partner.getLocation().y - this.botself.getLocation().y, this.partner.getLocation().z - this.botself.getLocation().z);
        double toPartner = botToPartner.length();
        botToPartner.normalize();
        double diff = (myVectorToTarget.length() - partnersVectorToTarget.length()) / 500.0;
        int add = 0;
        if (diff > 0.0) {
            diff = Math.min(diff, 1.5);
            add = 30;
        }
        this.forceToTarget.scale((double)this.partnerForce * Math.pow(2.0, diff) + (double)add);
        if (this.giveWayToPartner) {
            if (fromFoot < (double)(this.distanceFromThePartner / 2)) {
                scale = ((double)this.distanceFromThePartner - 2.0 * fromFoot) / (double)this.distanceFromThePartner;
                footToBot.scale((double)this.partnerForce * scale);
            } else {
                footToBot.set(0.0, 0.0, 0.0);
            }
            this.forceFromPartner = footToBot;
        } else {
            if (fromPartner < (double)this.distanceFromThePartner) {
                scale = ((double)this.distanceFromThePartner - fromPartner) / (double)this.distanceFromThePartner;
                partnerToBot.scale((double)this.partnerForce * scale);
            } else {
                partnerToBot.set(0.0, 0.0, 0.0);
            }
            this.forceFromPartner = partnerToBot;
        }
        if (toPartner > (double)this.distanceFromThePartner) {
            Vector3d myForceToPartner = new Vector3d(0.0, 0.0, 0.0);
            double diff2 = partnersVectorToTarget.length() - myVectorToTarget.length();
            if (this.waitForPartner && diff2 > (double)(3 * this.distanceFromThePartner)) {
                if (fromFoot <= (double)(this.distanceFromThePartner / 2)) {
                    this.waiting = true;
                    wantsToStop.setValue(true);
                    focus.setTo(this.partner.getLocation());
                    return nextVelocity;
                }
                double scale2 = 2.0 * fromFoot / (double)this.distanceFromThePartner;
                botToFoot.scale((double)this.partnerForce * scale2);
                botToPartner.scale((double)this.partnerForce * scale2);
                myForceToPartner.add((Tuple3d)botToFoot);
                myForceToPartner.add((Tuple3d)botToPartner);
            } else {
                if (this.newWait && this.waiting) {
                    double distancesDifference = partnersVectorToTarget.length() - myVectorToTarget.length();
                    System.out.println("Diff copy: " + distancesDifference);
                    if (distancesDifference > (double)WAIT_DISTANCE) {
                        this.waiting = true;
                        wantsToStop.setValue(true);
                        focus.setTo(this.partner.getLocation());
                        return nextVelocity;
                    }
                }
                double angleToTarget = this.forceToTarget.angle(this.botself.getVelocity().asVector3d());
                if (this.newToPartner && angleToTarget > 1.5707963267948966) {
                    footToBotCopy.normalize();
                    footToBotCopy.scale((double)(this.distanceFromThePartner / 2));
                    Location nextToPartner = new Location(this.partner.getLocation().x + footToBotCopy.x, this.partner.getLocation().y + footToBotCopy.y, this.partner.getLocation().z);
                    myForceToPartner = new Vector3d(nextToPartner.x - this.botself.getLocation().x, nextToPartner.y - this.botself.getLocation().y, nextToPartner.z - this.botself.getLocation().z);
                } else {
                    myForceToPartner.add((Tuple3d)botToPartner);
                }
                double scale3 = (toPartner - (double)this.distanceFromThePartner) / (double)this.distanceFromThePartner;
                myForceToPartner.normalize();
                myForceToPartner.scale((double)this.partnerForce * scale3);
                if (this.newToPartner2 && angleToTarget > 1.5707963267948966 && myForceToPartner.length() < (double)this.partnerForce) {
                    Location betweenPaT = new Location((this.partner.getLocation().x + this.targetLocation.x) / 2.0, (this.partner.getLocation().y + this.targetLocation.y) / 2.0, (this.partner.getLocation().z + this.targetLocation.z) / 2.0);
                    Vector3d toPointBetween = new Vector3d(betweenPaT.x - this.botself.getLocation().x, betweenPaT.y - this.botself.getLocation().y, betweenPaT.z - this.botself.getLocation().z);
                    toPointBetween.normalize();
                    double scaleBetween = (double)this.partnerForce - myForceToPartner.length();
                    toPointBetween.scale(scaleBetween);
                    myForceToPartner.add((Tuple3d)toPointBetween);
                    this.forceFromPartner.scale(0.0);
                }
            }
            this.forceToPartner = myForceToPartner;
        } else {
            this.forceToPartner = new Vector3d(0.0, 0.0, 0.0);
        }
        if (this.truncateToPartner && this.forceToPartner.length() > (double)MAX_TO_PARTNER) {
            this.forceToPartner.normalize();
            this.forceToPartner.scale((double)MAX_TO_PARTNER);
        }
        this.waiting = false;
        nextVelocity.add((Tuple3d)this.forceToTarget);
        nextVelocity.add((Tuple3d)this.forceFromPartner);
        nextVelocity.add((Tuple3d)this.forceToPartner);
        if (this.truncateNextVelocity && nextVelocity.length() > (double)MAX_NEXT_VELOCITY) {
            nextVelocity.normalize();
            nextVelocity.scale((double)MAX_NEXT_VELOCITY);
        }
        wantsToGoFaster.setValue(false);
        return nextVelocity;
    }

    private Player getPartner() {
        UnrealId myId = ((Self)this.botself.getWorldView().getSingle(Self.class)).getId();
        Collection col = this.botself.getWorldView().getAll(Player.class).values();
        for (Player p : col) {
            if (!p.getName().equals(this.partnerName) || p.getId() == myId) continue;
            return p;
        }
        return null;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.partnerForce = ((WalkAlongProperties)newProperties).getPartnerForce();
        this.partnerName = ((WalkAlongProperties)newProperties).getPartnerName();
        this.targetLocation = ((WalkAlongProperties)newProperties).getTargetLocation();
        this.distanceFromThePartner = ((WalkAlongProperties)newProperties).getDistanceFromThePartner();
        this.giveWayToPartner = ((WalkAlongProperties)newProperties).isGiveWayToPartner();
        this.waitForPartner = ((WalkAlongProperties)newProperties).isWaitForPartner();
    }

    public WalkAlongProperties getProperties() {
        WalkAlongProperties properties = new WalkAlongProperties();
        properties.setPartnerForce(this.partnerForce);
        properties.setPartnerName(this.partnerName);
        properties.setTargetLocation(this.targetLocation);
        properties.setDistanceFromThePartner(this.distanceFromThePartner);
        properties.setGiveWayToPartner(this.giveWayToPartner);
        properties.setWaitForPartner(this.waitForPartner);
        return properties;
    }

    public Vector3d getForceToPartner() {
        return this.forceFromPartner;
    }

    public Vector3d getForceToTarget() {
        return this.forceToPartner;
    }
}

