/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SteeringProperties.PeopleAvoidanceProperties;
import SteeringProperties.SteeringProperties;
import SteeringStuff.ISteering;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringTools;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Collection;
import java.util.Random;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class PeopleAvoidanceSteer
implements ISteering {
    private UT2004Bot botself;
    private int repulsiveForce;
    private int distanceFromOtherPeople;
    private boolean circumvention;
    private double projection;
    private boolean deceleration = true;
    private boolean acceleration = false;
    private static int TICK_PARTS = 5;
    Random random = new Random();

    public PeopleAvoidanceSteer(UT2004Bot bot) {
        this.botself = bot;
    }

    @Override
    public Vector3d run(Vector3d scaledActualVelocity, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, Location focus) {
        Vector3d actualVelocity = this.botself.getVelocity().getVector3d();
        Vector3d nextVelocity = new Vector3d(0.0, 0.0, 0.0);
        UnrealId myId = ((Self)this.botself.getWorldView().getSingle(Self.class)).getId();
        wantsToGoFaster.setValue(true);
        Collection col = this.botself.getWorldView().getAllVisible(Player.class).values();
        for (Player p : col) {
            Vector3d botToPlayer;
            if (p.getId() == myId) continue;
            if (this.deceleration || this.acceleration) {
                Vector3d notPushVector = this.notPushPartner(scaledActualVelocity, p, wantsToGoFaster);
                nextVelocity.add((Tuple3d)notPushVector);
            } else if (this.circumvention) {
                Vector3d goRoundVector = this.goRoundPartner(p);
                nextVelocity.add((Tuple3d)goRoundVector);
            }
            if (!(p.getLocation().getDistance(this.botself.getLocation()) < (double)this.distanceFromOtherPeople) || !(actualVelocity.angle(botToPlayer = new Vector3d(p.getLocation().x - this.botself.getLocation().x, p.getLocation().y - this.botself.getLocation().y, 0.0)) < 1.5707963267948966)) continue;
            Vector3d otherBotToFollower = new Vector3d(this.botself.getLocation().x - p.getLocation().x, this.botself.getLocation().y - p.getLocation().y, this.botself.getLocation().z - p.getLocation().z);
            otherBotToFollower.normalize();
            otherBotToFollower.scale((double)this.repulsiveForce * ((double)this.distanceFromOtherPeople - this.botself.getLocation().getDistance(p.getLocation())) / (double)this.distanceFromOtherPeople);
            wantsToGoFaster.setValue(false);
            nextVelocity.add((Tuple3d)otherBotToFollower);
        }
        return nextVelocity;
    }

    private Vector3d goRoundPartner(Player player) {
        Vector3d result = new Vector3d(0.0, 0.0, 0.0);
        Location myActualLocation = this.botself.getLocation();
        Vector3d myVelocity = this.botself.getVelocity().getVector3d();
        Location hisActualLocation = player.getLocation();
        Vector3d hisVelocity = player.getVelocity().getVector3d();
        Location myNextLocation = new Location();
        Location hisNextLocation = new Location();
        double collisionTime = -1.0;
        int t = 0;
        while ((double)t <= this.projection * (double)TICK_PARTS) {
            double time = (double)t / (double)TICK_PARTS;
            myNextLocation = this.getLocationAfterTime(myActualLocation, myVelocity, time);
            if (myNextLocation.getDistance(hisNextLocation = this.getLocationAfterTime(hisActualLocation, hisVelocity, time)) <= (double)this.distanceFromOtherPeople) {
                collisionTime = time;
                break;
            }
            ++t;
        }
        if (collisionTime != -1.0) {
            double koefB;
            double koefA;
            boolean turnLeft;
            double ourNextDistance = myNextLocation.getDistance(hisNextLocation);
            Vector3d myNextLocationToHis = new Vector3d(hisNextLocation.x - myNextLocation.x, hisNextLocation.y - myNextLocation.y, hisNextLocation.z - myNextLocation.z);
            double ourNextAngle = myNextLocationToHis.angle(myVelocity);
            if (ourNextAngle == 0.0) {
                turnLeft = this.random.nextBoolean();
                koefA = 1.0;
                koefB = this.getKoefB(collisionTime);
            } else {
                koefA = this.getKoefA(ourNextAngle, ourNextDistance);
                koefB = this.getKoefB(collisionTime);
                turnLeft = !SteeringTools.pointIsLeftFromTheVector(myVelocity, myNextLocationToHis);
            }
            Vector3d turningVector = SteeringTools.getTurningVector2(this.botself.getVelocity().getVector3d(), turnLeft);
            turningVector.normalize();
            turningVector.scale((double)(2 * this.repulsiveForce) * koefA * koefB);
            result.add((Tuple3d)turningVector);
        }
        return result;
    }

    private double getKoefA(double angle, double distance) {
        return Math.max(this.getKoefA1(angle), this.getKoefA2(distance));
    }

    private double getKoefA1(double angle) {
        return Math.max(0.0, (1.5707963267948966 - angle) / Math.PI / 2.0);
    }

    private double getKoefA2(double distance) {
        return Math.max(0.0, ((double)this.distanceFromOtherPeople - distance) / (double)this.distanceFromOtherPeople);
    }

    private double getKoefB(double ticks) {
        double koef = this.projection > 0.0 ? (this.projection - ticks) / (this.projection - 1.0) : 1.0;
        return koef;
    }

    private Location getLocationAfterTime(Location start, Vector3d velocity, double time) {
        return new Location(start.x + time * velocity.x, start.y + time * velocity.y, start.z);
    }

    private Vector3d notPushPartner(Vector3d botsVelocity, Player player, RefBoolean wantsToGoFaster) {
        Vector3d myVelo = this.botself.getVelocity().getVector3d();
        Vector3d hisVelo = player.getVelocity().getVector3d();
        Location myLoc = this.botself.getLocation();
        Location hisLoc = player.getLocation();
        Vector2d vInterSec = SteeringTools.getIntersectionOld(new Vector2d(myLoc.x, myLoc.y), new Vector2d(myVelo.x, myVelo.y), new Vector2d(hisLoc.x, hisLoc.y), new Vector2d(hisVelo.x, hisVelo.y));
        Vector3d result = new Vector3d();
        boolean noForce = true;
        if (vInterSec != null) {
            Location locInterSec = new Location(vInterSec.x, vInterSec.y, myLoc.z);
            double myDist = locInterSec.getDistance(myLoc);
            double hisDist = locInterSec.getDistance(hisLoc);
            double myTime = myDist / myVelo.length();
            double hisTime = hisDist / hisVelo.length();
            double minTime = Math.min(myTime, hisTime);
            Location myNewLoc = new Location(myLoc.x + myVelo.x * minTime, myLoc.y + myVelo.y * minTime, myLoc.z);
            Location hisNewLoc = new Location(hisLoc.x + hisVelo.x * minTime, hisLoc.y + hisVelo.y * minTime, hisLoc.z);
            double newLocsDiff = myNewLoc.getDistance(hisNewLoc);
            double far_distance = this.projection * myVelo.length();
            double far_distance2 = Math.max(far_distance, (double)(this.distanceFromOtherPeople + 1));
            if (myDist <= far_distance2 && newLocsDiff < (double)(2 * this.distanceFromOtherPeople)) {
                double koefA = (far_distance2 - myDist) / (far_distance2 - (double)this.distanceFromOtherPeople);
                koefA = Math.min(koefA, 1.0);
                double koefB = ((double)(2 * this.distanceFromOtherPeople) - newLocsDiff) / (double)(2 * this.distanceFromOtherPeople);
                if (myTime < hisTime && this.acceleration) {
                    noForce = false;
                    result = this.getBiggerVelocity(botsVelocity, 3.0 * koefA * koefB, false, wantsToGoFaster);
                } else if (myTime > hisTime && this.deceleration) {
                    noForce = false;
                    result = this.getBiggerVelocity(botsVelocity, koefA * koefB, true, wantsToGoFaster);
                } else if (myTime == hisTime) {
                    boolean slowDown = this.random.nextBoolean();
                    noForce = false;
                    result = this.getBiggerVelocity(botsVelocity, 5.0, slowDown, wantsToGoFaster);
                }
            }
        }
        if (noForce && this.circumvention) {
            result = this.goRoundPartner(player);
        }
        return result;
    }

    private Vector3d getBiggerVelocity(Vector3d velocity, double scale, boolean negate, RefBoolean wantsToGoFaster) {
        Vector3d result = new Vector3d(velocity.x, velocity.y, velocity.z);
        if (negate) {
            result.negate();
            wantsToGoFaster.setValue(false);
        }
        result.scale(scale);
        return result;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.repulsiveForce = ((PeopleAvoidanceProperties)newProperties).getRepulsiveForce();
        this.distanceFromOtherPeople = ((PeopleAvoidanceProperties)newProperties).getDistanceFromOtherPeople();
        this.circumvention = ((PeopleAvoidanceProperties)newProperties).isCircumvention();
        this.deceleration = ((PeopleAvoidanceProperties)newProperties).isDeceleration();
        this.acceleration = ((PeopleAvoidanceProperties)newProperties).isAcceleration();
        this.projection = ((PeopleAvoidanceProperties)newProperties).getProjection();
    }

    public PeopleAvoidanceProperties getProperties() {
        PeopleAvoidanceProperties properties = new PeopleAvoidanceProperties();
        properties.setRepulsiveForce(this.repulsiveForce);
        properties.setDistanceFromOtherPeople(this.distanceFromOtherPeople);
        properties.setCircumvention(this.circumvention);
        properties.setDeceleration(this.deceleration);
        properties.setAcceleration(this.acceleration);
        properties.setProjection(this.projection);
        return properties;
    }
}

