/*
 * Decompiled with CFR 0.152.
 */
package SteeringStuff;

import SocialSteeringsBeta.TriangleSteer;
import SteeringProperties.LeaderFollowingProperties;
import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.PathFollowingProperties;
import SteeringProperties.PeopleAvoidanceProperties;
import SteeringProperties.SteeringProperties;
import SteeringProperties.TargetApproachingProperties;
import SteeringProperties.WalkAlongProperties;
import SteeringProperties.WallFollowingProperties;
import SteeringStuff.ISteering;
import SteeringStuff.RaycastingManager;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringType;
import Steerings.LeaderFollowingSteer;
import Steerings.ObstacleAvoidanceSteer;
import Steerings.PathFollowingSteer;
import Steerings.PeopleAvoidanceSteer;
import Steerings.TargetApproachingSteer;
import Steerings.WalkAlongSteer;
import Steerings.WallFollowingSteer;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PlayAnimation;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import java.util.HashMap;
import java.util.Random;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class SteeringManager {
    public static final boolean DEBUG = false;
    protected UT2004Bot botself;
    protected AdvancedLocomotion locomotion;
    protected RaycastingManager rayManager;
    private HashMap<SteeringType, ISteering> mySteerings;
    public HashMap<SteeringType, Double> steeringWeights;
    private HashMap<SteeringType, Vector3d> steeringForces;
    private Vector3d myActualVelocity;
    protected Vector3d myNextVelocity;
    protected double multiplier;
    private double lastVeloWeight = 2.0;
    private boolean useLastVeloWeight = false;
    public static final double MAX_FORCE = 2000.0;
    protected static final double WALK_VELOCITY_LENGTH = 220.0;
    private static final double MIN_VALUE_TO_SUM = 66.0;
    public static final Location BASIC_LOCATION = new Location(800.0, -1500.0, -3446.65);
    protected boolean drawRaycasting;
    private boolean canEnlargeVelocity;
    private boolean WAPath = true;
    public static boolean Thomas = false;
    private boolean turning = true;
    private boolean WA_debugg = true;
    private IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            SteeringManager.this.run();
        }
    };

    public SteeringManager(UT2004Bot bot, Raycasting raycasting, AdvancedLocomotion locomotion) {
        this.botself = bot;
        this.locomotion = locomotion;
        this.multiplier = 1.0;
        this.rayManager = new RaycastingManager(this.botself, raycasting);
        this.mySteerings = new HashMap();
        this.steeringWeights = new HashMap();
        this.steeringForces = new HashMap();
        this.steeringManagerInitialized();
        this.myActualVelocity = new Vector3d();
        this.myNextVelocity = new Vector3d();
        this.drawRaycasting = false;
        this.canEnlargeVelocity = true;
    }

    public SteeringManager(UT2004Bot bot, Raycasting raycasting, AdvancedLocomotion locomotion, double multiplier) {
        this.botself = bot;
        this.locomotion = locomotion;
        this.multiplier = multiplier;
        this.rayManager = new RaycastingManager(this.botself, raycasting);
        this.mySteerings = new HashMap();
        this.steeringWeights = new HashMap();
        this.steeringForces = new HashMap();
        this.steeringManagerInitialized();
        this.myActualVelocity = new Vector3d();
        this.myNextVelocity = new Vector3d();
        this.drawRaycasting = false;
        this.canEnlargeVelocity = true;
    }

    private void steeringManagerInitialized() {
        this.locomotion.setWalk();
        if (Thomas) {
            this.botself.getAct().act((CommandMessage)new PlayAnimation().setName("walk_loop").setLoop(Boolean.valueOf(true)));
        }
        this.botself.getAct().act((CommandMessage)new Configuration().setDrawTraceLines(Boolean.valueOf(this.drawRaycasting)).setAutoTrace(Boolean.valueOf(true)).setSpeedMultiplier(Double.valueOf(1.0)));
    }

    public void addSteering(SteeringType type) {
        this.addSteering(type, 1.0);
    }

    public void addSteering(SteeringType type, double weight) {
        switch (type) {
            case OBSTACLE_AVOIDANCE: {
                this.mySteerings.put(type, new ObstacleAvoidanceSteer(this.botself, this.rayManager));
                break;
            }
            case TARGET_APPROACHING: {
                this.mySteerings.put(type, new TargetApproachingSteer(this.botself));
                break;
            }
            case LEADER_FOLLOWING: {
                this.mySteerings.put(type, new LeaderFollowingSteer(this.botself));
                break;
            }
            case PATH_FOLLOWING: {
                if (this.WAPath && this.mySteerings.containsKey(SteeringType.WALK_ALONG)) break;
                this.mySteerings.put(type, new PathFollowingSteer(this.botself));
                break;
            }
            case PEOPLE_AVOIDANCE: {
                this.mySteerings.put(type, new PeopleAvoidanceSteer(this.botself));
                break;
            }
            case WALK_ALONG: {
                this.mySteerings.put(type, new WalkAlongSteer(this.botself));
                break;
            }
            case WALL_FOLLOWING: {
                this.mySteerings.put(type, new WallFollowingSteer(this.botself, this.rayManager));
                break;
            }
            case TRIANGLE: {
                this.mySteerings.put(type, new TriangleSteer(this.botself));
            }
        }
        this.steeringWeights.put(type, new Double(weight));
    }

    public boolean hasSteering(SteeringType type) {
        return this.mySteerings.containsKey(type);
    }

    public void removeSteering(SteeringType type) {
        if (type == SteeringType.OBSTACLE_AVOIDANCE || type == SteeringType.WALL_FOLLOWING) {
            this.rayManager.removeRays(type);
        }
        this.mySteerings.remove(type);
        this.steeringWeights.remove(type);
    }

    public void setSteeringProperties(SteeringType type, SteeringProperties newProperties) {
        ISteering steer = this.mySteerings.get(type);
        if (steer != null) {
            steer.setProperties(newProperties);
        }
    }

    public void run() {
        double actualWeight;
        this.steeringForces.clear();
        Vector3d velocity = this.botself.getVelocity().getVector3d();
        Vector3d nextVelocity = new Vector3d(velocity.x, velocity.y, velocity.z);
        if (this.useLastVeloWeight) {
            actualWeight = this.lastVeloWeight;
        } else {
            actualWeight = 3.0 - velocity.length() / 220.0;
            if (actualWeight < 1.0) {
                actualWeight = 1.0;
            } else if (actualWeight > 2.0) {
                actualWeight = 2.0;
            }
            if (velocity.length() == 0.0) {
                actualWeight = 0.0;
            }
        }
        nextVelocity.scale(actualWeight);
        this.myActualVelocity = new Vector3d(nextVelocity.x, nextVelocity.y, nextVelocity.z);
        Vector3d myStopVelocity = new Vector3d(nextVelocity.x, nextVelocity.y, nextVelocity.z);
        double totalWeight = actualWeight;
        boolean everyoneWantsToGoFaster = this.canEnlargeVelocity;
        RefBoolean wantsToGoFaster = new RefBoolean(false);
        RefBoolean wantsToStop = new RefBoolean(false);
        Location focusLoc = new Location(0.0, 0.0, 0.0);
        for (SteeringType stType : this.mySteerings.keySet()) {
            ISteering steering = this.mySteerings.get(stType);
            Location newFocus = new Location(0.0, 0.0, 0.0);
            Vector3d newVelocity = this.setVelocitySpecific(steering, wantsToGoFaster, wantsToStop, newFocus);
            focusLoc = this.setFocusSpecific(stType, wantsToStop.getValue(), newFocus, focusLoc);
            if (wantsToStop.getValue()) {
                newVelocity.x = -myStopVelocity.x;
                newVelocity.y = -myStopVelocity.y;
                newVelocity.z = -myStopVelocity.z;
                myStopVelocity.sub((Tuple3d)newVelocity);
                everyoneWantsToGoFaster = false;
                wantsToStop.setValue(false);
            } else {
                if (newVelocity.length() > 2000.0) {
                    newVelocity.scale(2000.0 / newVelocity.length());
                }
                newVelocity.scale(this.steeringWeights.get(stType).doubleValue());
                boolean bl = everyoneWantsToGoFaster = everyoneWantsToGoFaster && wantsToGoFaster.getValue();
            }
            if (newVelocity.length() > 0.0) {
                newVelocity.add((Tuple3d)nextVelocity);
                nextVelocity = newVelocity;
                if (newVelocity.length() > 66.0) {
                    totalWeight += this.steeringWeights.get(stType).doubleValue();
                }
            }
            this.steeringForces.put(stType, newVelocity);
        }
        if (totalWeight > 0.0) {
            nextVelocity.scale(1.0 / totalWeight);
        }
        this.moveTheBot(nextVelocity, everyoneWantsToGoFaster, focusLoc);
    }

    public void moveTheBot(Vector3d nextVelocity, boolean everyoneWantsToGoFaster, Location focusLocation) {
        double nextVelMult;
        double nextVelocityLength = nextVelocity.length() * this.multiplier;
        if (nextVelocityLength == 0.0) {
            if (!focusLocation.equals(new Location(0.0, 0.0, 0.0)) && this.turning) {
                this.locomotion.turnTo((ILocated)focusLocation);
            }
            this.locomotion.stopMovement();
            if (Thomas) {
                this.botself.getAct().act((CommandMessage)new PlayAnimation().setName("idleanim").setLoop(Boolean.valueOf(true)));
            }
            this.myNextVelocity = new Vector3d(0.0, 0.0, 0.0);
            return;
        }
        if (nextVelocityLength < 176.0 && everyoneWantsToGoFaster) {
            nextVelocityLength = 176.0;
        }
        if ((nextVelMult = nextVelocityLength / 220.0) > 2.5) {
            this.locomotion.setRun();
            if (Thomas) {
                this.botself.getAct().act((CommandMessage)new PlayAnimation().setName("run_normal01").setLoop(Boolean.valueOf(true)));
            }
            if (nextVelMult > 20.5) {
                nextVelMult = 20.5;
            }
            nextVelMult -= 2.5;
            nextVelMult /= 18.0;
            nextVelMult = 0.8 + nextVelMult;
        } else {
            this.locomotion.setWalk();
            if (Thomas) {
                this.botself.getAct().act((CommandMessage)new PlayAnimation().setName("walk_loop").setLoop(Boolean.valueOf(true)));
            }
            nextVelMult = nextVelMult > 0.8 ? 0.85 + 0.1 * Math.sqrt(10.0 * (nextVelMult - 0.8)) : nextVelMult * 0.75 + 0.25;
        }
        nextVelocityLength = nextVelMult * 220.0;
        nextVelocity.normalize();
        nextVelocity.scale(nextVelocityLength);
        this.myNextVelocity = new Vector3d(nextVelocity.x, nextVelocity.y, nextVelocity.z);
        this.botself.getAct().act((CommandMessage)new Configuration().setSpeedMultiplier(Double.valueOf(nextVelocityLength / 220.0)).setAutoTrace(Boolean.valueOf(true)).setDrawTraceLines(Boolean.valueOf(this.drawRaycasting)));
        this.locomotion.moveTo((ILocated)new Location(this.botself.getLocation().x + nextVelocity.x, this.botself.getLocation().y + nextVelocity.y, this.botself.getLocation().z));
        if (this.WA_debugg && this.mySteerings.containsKey(SteeringType.WALK_ALONG)) {
            WalkAlongSteer WAsteering = (WalkAlongSteer)this.mySteerings.get(SteeringType.WALK_ALONG);
            this.myActualVelocity = WAsteering.getForceToPartner();
            if (this.myActualVelocity == null) {
                this.myActualVelocity = new Vector3d(0.0, 0.0, 0.0);
            }
            this.myNextVelocity = WAsteering.getForceToTarget();
            if (this.myNextVelocity == null) {
                this.myNextVelocity = new Vector3d(0.0, 0.0, 0.0);
            }
        }
    }

    private Location addLocations(Location focusLoc, Location newFocus) {
        if (focusLoc.equals(new Location(0.0, 0.0, 0.0))) {
            return newFocus;
        }
        if (newFocus.equals(new Location(0.0, 0.0, 0.0))) {
            return focusLoc;
        }
        Location result = new Location((focusLoc.x + newFocus.x) / 2.0, (focusLoc.y + newFocus.y) / 2.0, (focusLoc.z + newFocus.z) / 2.0);
        return result;
    }

    public static Location getRandomStartLocation() {
        Random random = new Random();
        int znam = 1;
        if (random.nextBoolean()) {
            znam = -1;
        }
        return new Location(SteeringManager.BASIC_LOCATION.x - (double)(random.nextInt(500) * znam), SteeringManager.BASIC_LOCATION.y - (double)(random.nextInt(500) * znam), SteeringManager.BASIC_LOCATION.z);
    }

    public static Rotation getRandomStartRotation() {
        Random random = new Random();
        return new Rotation(0.0, (double)SteeringManager.angleToUTUnits(random.nextInt(360) - 180), 0.0);
    }

    private static int angleToUTUnits(double angle) {
        return (int)Math.round(angle * 65535.0 / 360.0);
    }

    public HashMap<SteeringType, Vector3d> getSteeringForces() {
        return this.steeringForces;
    }

    public Vector3d getMyActualVelocity() {
        return this.myActualVelocity;
    }

    public Vector3d getMyNextVelocity() {
        return this.myNextVelocity;
    }

    public boolean isDrawRaycasting() {
        return this.drawRaycasting;
    }

    public void setDrawRaycasting(boolean drawRaycasting) {
        this.drawRaycasting = drawRaycasting;
    }

    public void setCanEnlargeVelocity(boolean canEnlargeVelocity) {
        this.canEnlargeVelocity = canEnlargeVelocity;
    }

    public boolean isCanEnlargeVelocity() {
        return this.canEnlargeVelocity;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public void setLastVeloWeight(double lastVeloWeight) {
        this.lastVeloWeight = lastVeloWeight;
    }

    public void setUseLastVeloWeight(boolean useLastVeloWeight) {
        this.useLastVeloWeight = useLastVeloWeight;
    }

    public void start() {
        if (!this.botself.getWorldView().isListening(EndMessage.class, this.endMessageListener)) {
            this.botself.getWorldView().addEventListener(EndMessage.class, this.endMessageListener);
        }
    }

    public void stop() {
        if (this.botself.getWorldView().isListening(EndMessage.class, this.endMessageListener)) {
            this.botself.getWorldView().removeEventListener(EndMessage.class, this.endMessageListener);
        }
    }

    public boolean isNavigating() {
        return this.botself.getWorldView().isListening(EndMessage.class, this.endMessageListener);
    }

    public void clearSteerings() {
        for (SteeringType type : this.mySteerings.keySet()) {
            this.removeSteering(type);
        }
    }

    public LeaderFollowingProperties getLeaderFollowingProperties() {
        ISteering steering = this.mySteerings.get(SteeringType.LEADER_FOLLOWING);
        if (steering != null) {
            return ((LeaderFollowingSteer)steering).getProperties();
        }
        return null;
    }

    public ObstacleAvoidanceProperties getObstacleAvoidanceProperties() {
        ISteering steering = this.mySteerings.get(SteeringType.OBSTACLE_AVOIDANCE);
        if (steering != null) {
            return ((ObstacleAvoidanceSteer)steering).getProperties();
        }
        return null;
    }

    public PathFollowingProperties getPathFollowingProperties() {
        ISteering steering = this.mySteerings.get(SteeringType.PATH_FOLLOWING);
        if (steering != null) {
            return ((PathFollowingSteer)steering).getProperties();
        }
        return null;
    }

    public PeopleAvoidanceProperties getPeopleAvoidanceProperties() {
        ISteering steering = this.mySteerings.get(SteeringType.PEOPLE_AVOIDANCE);
        if (steering != null) {
            return ((PeopleAvoidanceSteer)steering).getProperties();
        }
        return null;
    }

    public TargetApproachingProperties getTargetApproachingProperties() {
        ISteering steering = this.mySteerings.get(SteeringType.TARGET_APPROACHING);
        if (steering != null) {
            return ((TargetApproachingSteer)steering).getProperties();
        }
        return null;
    }

    public WalkAlongProperties getWalkAlongProperties() {
        ISteering steering = this.mySteerings.get(SteeringType.WALK_ALONG);
        if (steering != null) {
            return ((WalkAlongSteer)steering).getProperties();
        }
        return null;
    }

    public WallFollowingProperties getWallFollowingProperties() {
        ISteering steering = this.mySteerings.get(SteeringType.WALL_FOLLOWING);
        if (steering != null) {
            return ((WallFollowingSteer)steering).getProperties();
        }
        return null;
    }

    public void addLeaderFollowingSteering(LeaderFollowingProperties properties) {
        this.addSteering(SteeringType.LEADER_FOLLOWING);
        this.setSteeringProperties(SteeringType.LEADER_FOLLOWING, properties);
    }

    public void removeLeaderFollowingSteering() {
        this.removeSteering(SteeringType.LEADER_FOLLOWING);
    }

    public void setLeaderFollowingSteering(LeaderFollowingProperties properties) {
        this.setSteeringProperties(SteeringType.LEADER_FOLLOWING, properties);
    }

    public boolean isLeaderFollowingActive() {
        return this.hasSteering(SteeringType.LEADER_FOLLOWING);
    }

    public void addObstacleAvoidanceSteering(ObstacleAvoidanceProperties properties) {
        this.addSteering(SteeringType.OBSTACLE_AVOIDANCE);
        this.setSteeringProperties(SteeringType.OBSTACLE_AVOIDANCE, properties);
    }

    public void removeObstacleAvoidanceSteering() {
        this.removeSteering(SteeringType.OBSTACLE_AVOIDANCE);
    }

    public void setObstacleAvoidanceSteering(ObstacleAvoidanceProperties properties) {
        this.setSteeringProperties(SteeringType.OBSTACLE_AVOIDANCE, properties);
    }

    public boolean isObstacleAvoidanceActive() {
        return this.hasSteering(SteeringType.OBSTACLE_AVOIDANCE);
    }

    public void addPathFollowingSteering(PathFollowingProperties properties) {
        this.addSteering(SteeringType.PATH_FOLLOWING);
        this.setSteeringProperties(SteeringType.PATH_FOLLOWING, properties);
    }

    public void removePathFollowingSteering() {
        this.removeSteering(SteeringType.PATH_FOLLOWING);
    }

    public void setPathFollowingSteering(PathFollowingProperties properties) {
        this.setSteeringProperties(SteeringType.PATH_FOLLOWING, properties);
    }

    public boolean isPathFollowingActive() {
        return this.hasSteering(SteeringType.PATH_FOLLOWING);
    }

    public void addPeopleAvoidanceSteering(PeopleAvoidanceProperties properties) {
        this.addSteering(SteeringType.PEOPLE_AVOIDANCE);
        this.setSteeringProperties(SteeringType.OBSTACLE_AVOIDANCE, properties);
    }

    public void removePeopleAvoidanceSteering() {
        this.removeSteering(SteeringType.PEOPLE_AVOIDANCE);
    }

    public void setPeopleAvoidanceSteering(PeopleAvoidanceProperties properties) {
        this.setSteeringProperties(SteeringType.PEOPLE_AVOIDANCE, properties);
    }

    public boolean isPeopleAvoidanceActive() {
        return this.hasSteering(SteeringType.PEOPLE_AVOIDANCE);
    }

    public void addTargetApproachingSteering(TargetApproachingProperties properties) {
        this.addSteering(SteeringType.TARGET_APPROACHING);
        this.setSteeringProperties(SteeringType.TARGET_APPROACHING, properties);
    }

    public void removeTargetApproachingSteering() {
        this.removeSteering(SteeringType.TARGET_APPROACHING);
    }

    public void setTargetApproachingSteering(TargetApproachingProperties properties) {
        this.setSteeringProperties(SteeringType.TARGET_APPROACHING, properties);
    }

    public boolean isTargetApproachingActive() {
        return this.hasSteering(SteeringType.TARGET_APPROACHING);
    }

    public void addWalkAlongSteering(WalkAlongProperties properties) {
        this.addSteering(SteeringType.WALK_ALONG);
        this.setSteeringProperties(SteeringType.WALK_ALONG, properties);
    }

    public void removeWalkAlongSteering() {
        this.removeSteering(SteeringType.WALK_ALONG);
    }

    public void setWalkAlongSteering(WalkAlongProperties properties) {
        this.setSteeringProperties(SteeringType.WALK_ALONG, properties);
    }

    public boolean isWalkAlongActive() {
        return this.hasSteering(SteeringType.WALK_ALONG);
    }

    public void addWallFollowingSteering(WallFollowingProperties properties) {
        this.addSteering(SteeringType.WALL_FOLLOWING);
        this.setSteeringProperties(SteeringType.WALL_FOLLOWING, properties);
    }

    public void removeWallFollowingSteering() {
        this.removeSteering(SteeringType.WALL_FOLLOWING);
    }

    public void setWallFollowingSteering(WallFollowingProperties properties) {
        this.setSteeringProperties(SteeringType.WALL_FOLLOWING, properties);
    }

    public boolean isWallFollowingActive() {
        return this.hasSteering(SteeringType.WALL_FOLLOWING);
    }

    protected Location setFocusSpecific(SteeringType steeringType, boolean wantsToStop, Location newFocus, Location focusLoc) {
        if (wantsToStop) {
            return this.addLocations(focusLoc, newFocus);
        }
        return focusLoc;
    }

    protected Vector3d setVelocitySpecific(ISteering steering, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, Location newFocus) {
        Vector3d newVelocity = steering.run(this.myActualVelocity, wantsToGoFaster, wantsToStop, newFocus);
        return newVelocity;
    }
}

