/*
 * Decompiled with CFR 0.152.
 */
package SteeringProperties;

import SteeringProperties.SteeringProperties;
import SteeringStuff.SteeringType;
import XMLSteeringProperties.XMLWalkAlongProperties;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

public class WalkAlongProperties
extends SteeringProperties {
    private int partnerForce;
    private String partnerName;
    private Location targetLocation;
    private int distance;
    private boolean giveWayToPartner;
    private boolean waitForPartner;

    public WalkAlongProperties() {
        super(SteeringType.WALK_ALONG);
        this.partnerForce = 200;
        this.partnerName = "Partner";
        this.targetLocation = new Location(9440.0, -10500.0, -3446.65);
        this.distance = 500;
        this.giveWayToPartner = false;
        this.waitForPartner = false;
    }

    public WalkAlongProperties(SteeringProperties.BehaviorType behaviorType) {
        super(SteeringType.WALK_ALONG, behaviorType);
        this.partnerForce = 200;
        this.partnerName = "Partner";
        this.targetLocation = new Location(9440.0, -10500.0, -3446.65);
        this.distance = 500;
        this.giveWayToPartner = false;
        this.waitForPartner = false;
        this.setNewBehaviorType(behaviorType);
    }

    public WalkAlongProperties(XMLWalkAlongProperties xml) {
        super(SteeringType.WALK_ALONG, xml.active, xml.weight, xml.behavior);
        this.partnerForce = xml.attractiveForce;
        this.partnerName = xml.partnerName;
        this.targetLocation = new Location((double)xml.xTargetLocation, (double)xml.yTargetLocation, (double)xml.zTargetLocation);
        this.distance = xml.distance;
        this.giveWayToPartner = xml.giveWayToPartner;
        this.waitForPartner = xml.waitForPartner;
    }

    public WalkAlongProperties(int partnerForce, String partnerName, Location targetLocation, int distanceFromThePartner, boolean giveWayToPartner, boolean waitForPartner) {
        super(SteeringType.WALK_ALONG);
        this.partnerForce = partnerForce;
        this.partnerName = partnerName;
        this.targetLocation = targetLocation;
        this.distance = distanceFromThePartner;
        this.giveWayToPartner = giveWayToPartner;
        this.waitForPartner = waitForPartner;
    }

    @Override
    protected void setNewBehaviorType(SteeringProperties.BehaviorType behaviorType) {
        if (behaviorType.equals((Object)SteeringProperties.BehaviorType.BASIC)) {
            this.giveWayToPartner = false;
            this.waitForPartner = false;
        } else if (behaviorType.equals((Object)SteeringProperties.BehaviorType.ADVANCED)) {
            this.giveWayToPartner = true;
            this.waitForPartner = true;
        }
    }

    public int getPartnerForce() {
        return this.partnerForce;
    }

    public void setPartnerForce(int attractiveForce) {
        this.partnerForce = attractiveForce;
    }

    public int getDistanceFromThePartner() {
        return this.distance;
    }

    public void setDistanceFromThePartner(int distanceFromThePartner) {
        this.distance = distanceFromThePartner;
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public void setTargetLocation(Location targetLocation) {
        this.targetLocation = targetLocation;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public void setPartnerName(String partnerName) {
        this.partnerName = partnerName;
    }

    public boolean isGiveWayToPartner() {
        return this.giveWayToPartner;
    }

    public void setGiveWayToPartner(boolean giveWayToPartner) {
        this.giveWayToPartner = giveWayToPartner;
    }

    public boolean isWaitForPartner() {
        return this.waitForPartner;
    }

    public void setWaitForPartner(boolean waitForPartner) {
        this.waitForPartner = waitForPartner;
    }

    @Override
    public String getSpecialText() {
        String text = "";
        text = text + "  * Partner Force: " + this.partnerForce + "\n";
        text = text + "  * Partner: " + this.partnerName + "\n";
        text = text + "  * Target Location: " + this.targetLocation.toString() + "\n";
        text = text + "  * Distance: " + this.distance + "\n";
        text = text + "  * Give Way: " + this.giveWayToPartner + "\n";
        text = text + "  * Wait for Partner: " + this.waitForPartner + "\n";
        return text;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.partnerForce = ((WalkAlongProperties)newProperties).getPartnerForce();
        this.partnerName = ((WalkAlongProperties)newProperties).getPartnerName();
        this.targetLocation = ((WalkAlongProperties)newProperties).getTargetLocation();
        this.distance = ((WalkAlongProperties)newProperties).getDistanceFromThePartner();
        this.giveWayToPartner = ((WalkAlongProperties)newProperties).isGiveWayToPartner();
        this.waitForPartner = ((WalkAlongProperties)newProperties).isWaitForPartner();
    }

    public XMLWalkAlongProperties getXMLProperties() {
        XMLWalkAlongProperties xmlProp = new XMLWalkAlongProperties();
        xmlProp.attractiveForce = this.partnerForce;
        xmlProp.partnerName = this.partnerName;
        xmlProp.distance = this.distance;
        xmlProp.xTargetLocation = (int)this.targetLocation.x;
        xmlProp.yTargetLocation = (int)this.targetLocation.y;
        xmlProp.zTargetLocation = (int)this.targetLocation.z;
        xmlProp.giveWayToPartner = this.giveWayToPartner;
        xmlProp.waitForPartner = this.waitForPartner;
        xmlProp.active = this.active;
        xmlProp.weight = this.weight;
        xmlProp.behavior = this.behaviorType;
        return xmlProp;
    }
}

