/*
 * Decompiled with CFR 0.152.
 */
package Steerings;

import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.SteeringProperties;
import SteeringStuff.IRaysFlagChanged;
import SteeringStuff.ISteering;
import SteeringStuff.RaycastingManager;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringRay;
import SteeringStuff.SteeringTools;
import SteeringStuff.SteeringType;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class ObstacleAvoidanceSteer
implements ISteering,
IRaysFlagChanged {
    private UT2004Bot botself;
    private RaycastingManager rayManager;
    private int repulsiveForce;
    private int forceOrder;
    private boolean frontCollisions;
    private boolean treeCollisions;
    private static double FRONT_RAY_WEIGHT = 1.0;
    private static double SIDE_FRONT_RAY_WEIGHT = 0.8;
    private static double SIDE_RAY_WEIGHT = 0.5;
    private boolean raysReady;
    private HashMap<String, Future<AutoTraceRay>> myFutureRays;
    protected static final String LEFTFRONT = "oleftfront";
    protected static final String LEFT = "oleft";
    protected static final String RIGHTFRONT = "orightfront";
    protected static final String RIGHT = "oright";
    protected static final String FRONT = "ofront";
    boolean sensorLeft = false;
    boolean sensorRight = false;
    boolean sensorLeftFront = false;
    boolean sensorRightFront = false;
    boolean sensorFront = false;
    AutoTraceRay left;
    AutoTraceRay right;
    AutoTraceRay leftfront;
    AutoTraceRay rightfront;
    AutoTraceRay front;
    final int shortRayLength = 200;
    final int longRayLength = 625;
    Random random = new Random();

    public ObstacleAvoidanceSteer(UT2004Bot bot, RaycastingManager rayManager) {
        this.botself = bot;
        this.rayManager = rayManager;
        this.prepareRays();
    }

    private void prepareRays() {
        LinkedList<SteeringRay> rayList = new LinkedList<SteeringRay>();
        rayList.add(new SteeringRay(LEFT, new Vector3d(0.0, -1.0, 0.0), 200));
        rayList.add(new SteeringRay(LEFTFRONT, new Vector3d(Math.sqrt(3.0) * 2.0, -1.0, 0.0), 625));
        rayList.add(new SteeringRay(RIGHTFRONT, new Vector3d(Math.sqrt(3.0) * 2.0, 1.0, 0.0), 625));
        rayList.add(new SteeringRay(RIGHT, new Vector3d(0.0, 1.0, 0.0), 200));
        rayList.add(new SteeringRay(FRONT, new Vector3d(1.0, 0.0, 0.0), 625));
        this.rayManager.addRays(SteeringType.OBSTACLE_AVOIDANCE, rayList, this);
        this.raysReady = false;
    }

    @Override
    public void flagRaysChanged() {
        this.myFutureRays = this.rayManager.getMyFutureRays(SteeringType.OBSTACLE_AVOIDANCE);
        this.raysReady = false;
        this.listenToRays();
    }

    private void listenToRays() {
        for (String rayId : this.myFutureRays.keySet()) {
            Future<AutoTraceRay> fr = this.myFutureRays.get(rayId);
            if (!fr.isDone()) continue;
            try {
                if (rayId.equals(LEFTFRONT)) {
                    this.leftfront = fr.get();
                } else if (rayId.equals(RIGHTFRONT)) {
                    this.rightfront = fr.get();
                } else if (rayId.equals(LEFT)) {
                    this.left = fr.get();
                } else if (rayId.equals(RIGHT)) {
                    this.right = fr.get();
                } else if (rayId.equals(FRONT)) {
                    this.front = fr.get();
                }
                this.raysReady = true;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ObstacleAvoidanceSteer.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(ObstacleAvoidanceSteer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public Vector3d run(Vector3d scaledActualVelocity, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, Location focus) {
        double multiplier;
        Vector3d normal;
        Vector3d botToHitLocation;
        boolean sensor;
        wantsToGoFaster.setValue(false);
        Vector3d nextVelocity = new Vector3d(0.0, 0.0, 0.0);
        if (!this.raysReady) {
            this.listenToRays();
            return nextVelocity;
        }
        Vector3d actualVelocity = this.botself.getVelocity().getVector3d();
        Vector3d originalVelocity = this.botself.getVelocity().getVector3d();
        originalVelocity.normalize();
        originalVelocity.scale(0.0);
        if (this.leftfront != null) {
            this.sensorLeftFront = this.leftfront.isResult();
        }
        if (this.rightfront != null) {
            this.sensorRightFront = this.rightfront.isResult();
        }
        if (this.left != null) {
            this.sensorLeft = this.left.isResult();
        }
        if (this.right != null) {
            this.sensorRight = this.right.isResult();
        }
        if (this.front != null) {
            this.sensorFront = this.front.isResult();
        }
        boolean bl = sensor = this.sensorFront || this.sensorLeft || this.sensorLeftFront || this.sensorRight || this.sensorRightFront;
        if (this.sensorLeft) {
            botToHitLocation = new Vector3d(this.left.getHitLocation().x - this.botself.getLocation().x, this.left.getHitLocation().y - this.botself.getLocation().y, 0.0);
            normal = this.left.getHitNormal();
            multiplier = Math.pow((200.0 - botToHitLocation.length()) * 2.0 / 200.0, this.forceOrder);
            normal.scale(SIDE_RAY_WEIGHT * (double)this.repulsiveForce * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (this.sensorRight) {
            botToHitLocation = new Vector3d(this.right.getHitLocation().x - this.botself.getLocation().x, this.right.getHitLocation().y - this.botself.getLocation().y, 0.0);
            normal = this.right.getHitNormal();
            multiplier = Math.pow((200.0 - botToHitLocation.length()) * 2.0 / 200.0, this.forceOrder);
            normal.scale(SIDE_RAY_WEIGHT * (double)this.repulsiveForce * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (this.sensorLeftFront) {
            botToHitLocation = new Vector3d(this.leftfront.getHitLocation().x - this.botself.getLocation().x, this.leftfront.getHitLocation().y - this.botself.getLocation().y, 0.0);
            multiplier = Math.pow((625.0 - botToHitLocation.length()) * 2.0 / 625.0, this.forceOrder);
            normal = this.leftfront.getHitNormal();
            if (this.treeCollisions && !this.sensorRightFront && SteeringTools.pointIsLeftFromTheVector(actualVelocity, normal)) {
                normal = this.computeTreeCollisionVector(normal);
            }
            if (this.frontCollisions && !this.sensorFront) {
                normal = this.computeFrontCollisionVector(normal);
            }
            normal.scale(SIDE_FRONT_RAY_WEIGHT * (double)this.repulsiveForce * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (this.sensorRightFront) {
            botToHitLocation = new Vector3d(this.rightfront.getHitLocation().x - this.botself.getLocation().x, this.rightfront.getHitLocation().y - this.botself.getLocation().y, 0.0);
            multiplier = Math.pow((625.0 - botToHitLocation.length()) * 2.0 / 625.0, this.forceOrder);
            normal = this.rightfront.getHitNormal();
            if (this.treeCollisions && !this.sensorLeftFront && !SteeringTools.pointIsLeftFromTheVector(actualVelocity, normal)) {
                normal = this.computeTreeCollisionVector(normal);
            }
            if (this.frontCollisions && !this.sensorFront) {
                normal = this.computeFrontCollisionVector(normal);
            }
            normal.scale(SIDE_FRONT_RAY_WEIGHT * (double)this.repulsiveForce * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (this.sensorFront) {
            botToHitLocation = new Vector3d(this.front.getHitLocation().x - this.botself.getLocation().x, this.front.getHitLocation().y - this.botself.getLocation().y, 0.0);
            multiplier = Math.pow((625.0 - botToHitLocation.length()) * 2.0 / 625.0, this.forceOrder);
            normal = this.front.getHitNormal();
            if (this.frontCollisions) {
                normal = this.computeFrontCollisionVector(normal);
            }
            normal.scale(FRONT_RAY_WEIGHT * (double)this.repulsiveForce * multiplier);
            nextVelocity.add((Tuple3d)normal);
        }
        if (!sensor) {
            wantsToGoFaster.setValue(true);
        } else {
            wantsToGoFaster.setValue(false);
        }
        return nextVelocity;
    }

    private Vector3d computeTreeCollisionVector(Vector3d normal) {
        Vector3d av = this.botself.getVelocity().getVector3d();
        Vector2d start = new Vector2d(this.botself.getLocation().x, this.botself.getLocation().y);
        Vector2d end = new Vector2d(start.x - av.x, start.y - av.y);
        Vector2d point = new Vector2d(start.x + normal.x, start.y + normal.y);
        Vector2d pata = SteeringTools.getNearestPoint(start, end, point, false);
        Vector2d pointToPata = new Vector2d(pata.x - point.x, pata.y - point.y);
        pointToPata.scale(2.0);
        Vector2d mirrorPoint = new Vector2d(point.x + pointToPata.x, point.y + pointToPata.y);
        Vector3d result = new Vector3d(mirrorPoint.x - start.x, mirrorPoint.y - start.y, 0.0);
        return result;
    }

    private Vector3d computeFrontCollisionVector(Vector3d normal) {
        Vector3d av = this.botself.getVelocity().getVector3d();
        Vector3d result = new Vector3d(normal.x, normal.y, 0.0);
        Vector3d negativeActual = new Vector3d(-av.x, -av.y, 0.0);
        if (result.angle(negativeActual) <= 1.5707963267948966) {
            boolean turnLeft = result.angle(negativeActual) == 0.0 ? this.random.nextBoolean() : SteeringTools.pointIsLeftFromTheVector(av, result);
            Vector3d turn = SteeringTools.getTurningVector2(av, turnLeft);
            turn.normalize();
            turn.scale(0.5);
            result.add((Tuple3d)turn);
            result.normalize();
        }
        return result;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.repulsiveForce = ((ObstacleAvoidanceProperties)newProperties).getRepulsiveForce();
        this.forceOrder = ((ObstacleAvoidanceProperties)newProperties).getForceOrder();
        this.frontCollisions = ((ObstacleAvoidanceProperties)newProperties).isFrontCollisions();
        this.treeCollisions = ((ObstacleAvoidanceProperties)newProperties).isTreeCollisions();
    }

    public ObstacleAvoidanceProperties getProperties() {
        ObstacleAvoidanceProperties properties = new ObstacleAvoidanceProperties();
        properties.setRepulsiveForce(this.repulsiveForce);
        properties.setForceOrder(this.forceOrder);
        properties.setFrontCollisions(this.frontCollisions);
        properties.setTreeCollisions(this.treeCollisions);
        return properties;
    }
}

