/*
 * Decompiled with CFR 0.152.
 */
package SocialSteeringsBeta;

import SocialSteeringsBeta.ISocialSteering;
import SocialSteeringsBeta.Interval;
import SocialSteeringsBeta.SOC_STEER_LOG;
import SocialSteeringsBeta.SteeringResult;
import SocialSteeringsBeta.TriangleSteeringProperties;
import SteeringProperties.SteeringProperties;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringTools;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import java.util.ArrayList;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class TriangleSteer
implements ISocialSteering {
    protected UT2004Bot botself;
    protected TriangleSteeringProperties properties;
    private static final int KDefaultAttraction = 600;
    private static final double K90deg = 90.0;
    private static final double K360deg = 360.0;
    private static final double K180deg = 180.0;
    private static final double KMinimalDistance = 50.0;
    private static final String KTowards = "towards";

    public TriangleSteer(UT2004Bot botself) {
        this.botself = botself;
    }

    @Override
    public Vector3d run(Vector3d scaledActualVelocity, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, Location focus) {
        Location newFocus;
        if (this.properties == null && SOC_STEER_LOG.DEBUG) {
            SOC_STEER_LOG.AddLogLineWithDate("no properties", "triangleError");
        }
        if ((newFocus = this.getFocus()) != null) {
            focus.setTo(newFocus);
        }
        Location targetLocation = this.WhereToGo(this.botself, this.properties);
        SteeringResult nextVelocity = new SteeringResult(new Vector3d(0.0, 0.0, 0.0), 1.0);
        if (targetLocation != null) {
            targetLocation.z = this.botself.getLocation().z;
            Vector3d vectorToTarget = targetLocation.sub(this.botself.getLocation()).asVector3d();
            double distFromTarget = vectorToTarget.length();
            nextVelocity.setMult(distFromTarget / 100.0);
            if (distFromTarget < 50.0) {
                wantsToStop.setValue(true);
                return new SteeringResult(new Vector3d(0.0, 0.0, 0.0), 1.0);
            }
            double attractiveForce = 600.0;
            vectorToTarget.normalize();
            vectorToTarget.scale(attractiveForce);
            nextVelocity.add((Tuple3d)vectorToTarget);
        }
        boolean botAttractiveForce = false;
        Vector3d attractionFromFst = this.attraction(this.botself, this.properties.getFstBot(), 1.1);
        Vector3d attractionFromSnd = this.attraction(this.botself, this.properties.getSndBot(), 1.1);
        attractionFromFst.scale((double)botAttractiveForce);
        nextVelocity.add((Tuple3d)attractionFromFst);
        attractionFromSnd.scale((double)botAttractiveForce);
        nextVelocity.add((Tuple3d)attractionFromSnd);
        wantsToGoFaster.setValue(false);
        return nextVelocity;
    }

    @Override
    public void setProperties(SteeringProperties newProperties) {
        this.properties = (TriangleSteeringProperties)newProperties;
    }

    private Location WhereToGo(UT2004Bot me, TriangleSteeringProperties propers) {
        UT2004Bot first = propers.getFstBot();
        UT2004Bot second = propers.getSndBot();
        if (SOC_STEER_LOG.DEBUG) {
            SOC_STEER_LOG.AddLogLineWithDate(me.getName() + " " + me.getLocation().toString() + " --------------------------------------------", "triangle");
            if (propers == null) {
                SOC_STEER_LOG.AddLogLineWithDate(me.getName() + "I have no properties!!!", "triangleError");
            }
        }
        ArrayList<Location> edgePoints = new ArrayList<Location>();
        Location S1 = first.getLocation();
        Location S2 = second.getLocation();
        int r1min = propers.getFstDistance().getMin();
        int r1max = propers.getFstDistance().getMax();
        int r2min = propers.getSndDistance().getMin();
        int r2max = propers.getSndDistance().getMax();
        if (TriangleSteer.isSuitable(me.getLocation(), S1, S2, propers, 0.0)) {
            SOC_STEER_LOG.AddLogLineWithDate(me.getName() + "is in suitable place.", "triangle");
            return me.getLocation();
        }
        double othersDistance = S1.getDistance2D(S2);
        if ((double)(r1max + r2max) < othersDistance) {
            SOC_STEER_LOG.AddLogLineWithDate(me.getName() + "see: " + first.getName() + "to far from: " + second.getName(), "triangle");
            float factor = (float)r1max / (float)(r1max + r2max);
            return S1.add(S2.sub(S1).scale((double)factor));
        }
        double r3min = 0.0;
        double r3max = 0.0;
        for (int i = 0; i < 2; ++i) {
            if (SOC_STEER_LOG.DEBUG) {
                if (propers == null) {
                    SOC_STEER_LOG.AddLogLine("nemam TP pro TS", "error");
                }
                if (propers.getAngle() == null) {
                    SOC_STEER_LOG.AddLogLine("nemam uhel v TP", "error");
                }
            }
            double angle = i == 0 ? (double)propers.getAngle().getMin() : (double)propers.getAngle().getMax();
            double gamma = angle < 90.0 ? 2.0 * angle : 360.0 - 2.0 * angle;
            double alpha = (180.0 - gamma) / 2.0;
            double s = S1.getDistance2D(S2);
            double alphaRad = SteeringTools.degreesToRadians(alpha);
            double cosAlpha = Math.cos(alphaRad);
            double b = s / (2.0 * cosAlpha);
            if (i == 0) {
                r3min = b;
                continue;
            }
            r3max = b;
        }
        Location S3max1 = null;
        Location S3min1 = null;
        Location S3max2 = null;
        Location S3min2 = null;
        Location[] tmp = SteeringTools.commonPoints(S2, r3max, S1, r3max);
        if (tmp[0] != null) {
            S3max1 = tmp[0];
        }
        if (tmp[1] != null) {
            S3max2 = tmp[1];
        }
        if ((tmp = SteeringTools.commonPoints(S2, r3min, S1, r3min))[0] != null) {
            S3min1 = tmp[0];
        }
        if (tmp[1] != null) {
            S3min2 = tmp[1];
        }
        int edgeSize = edgePoints.size();
        tmp = SteeringTools.commonPoints(S1, r1min, S2, r2min);
        if (tmp[0] != null) {
            edgePoints.add(tmp[0]);
        }
        if (tmp[1] != null) {
            edgePoints.add(tmp[1]);
        }
        if ((tmp = SteeringTools.commonPoints(S1, r1max, S2, r2min))[0] != null) {
            edgePoints.add(tmp[0]);
        }
        if (tmp[1] != null) {
            edgePoints.add(tmp[1]);
        }
        if ((tmp = SteeringTools.commonPoints(S1, r1max, S2, r2max))[0] != null) {
            edgePoints.add(tmp[0]);
        }
        if (tmp[1] != null) {
            edgePoints.add(tmp[1]);
        }
        if ((tmp = SteeringTools.commonPoints(S1, r1min, S2, r2max))[0] != null) {
            edgePoints.add(tmp[0]);
        }
        if (tmp[1] != null) {
            edgePoints.add(tmp[1]);
        }
        if (SOC_STEER_LOG.DEBUG && edgeSize == edgePoints.size()) {
            SOC_STEER_LOG.AddLogLine(me.getName() + " no distance-circles cross", "triangle");
            SOC_STEER_LOG.AddLogLine("-  S1: " + S1 + " S2: " + S2 + " r1: " + r1min + "-" + r1max + " r2: " + r2min + "-" + r2max, "triangle");
        }
        edgeSize = edgePoints.size();
        if (S3min1 != null) {
            tmp = SteeringTools.commonPoints(S3min1, r3min, S2, r2max);
            if (tmp[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3min1, r3min, S2, r2min))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3min1, r3min, S1, r1min))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3min1, r3min, S1, r1max))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if (SOC_STEER_LOG.DEBUG && edgeSize == edgePoints.size()) {
                SOC_STEER_LOG.AddLogLine(me.getName() + " no S3min1 cross", "triangle");
                SOC_STEER_LOG.AddLogLine("-  S3min1: " + S3min1 + " r3min: " + r3min + " r1: " + r1min + "-" + r1max + " r2: " + r2min + "-" + r2max, "triangle");
            }
            edgeSize = edgePoints.size();
        } else if (SOC_STEER_LOG.DEBUG) {
            SOC_STEER_LOG.AddLogLine(me.getName() + " no S3min1", "triangle");
        }
        if (S3max1 != null) {
            tmp = SteeringTools.commonPoints(S3max1, r3max, S2, r2max);
            if (tmp[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3max1, r3max, S2, r2min))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3max1, r3max, S1, r1min))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3max1, r3max, S1, r1max))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if (SOC_STEER_LOG.DEBUG && edgeSize == edgePoints.size()) {
                SOC_STEER_LOG.AddLogLine(me.getName() + " no S3max1 cross", "triangle");
                SOC_STEER_LOG.AddLogLine("-  S3max1: " + S3max1 + " r3max: " + r3max + " r1: " + r1min + "-" + r1max + " r2: " + r2min + "-" + r2max, "triangle");
            }
            edgeSize = edgePoints.size();
        } else if (SOC_STEER_LOG.DEBUG) {
            SOC_STEER_LOG.AddLogLine(me.getName() + " no S3max1", "triangle");
        }
        if (S3min2 != null) {
            tmp = SteeringTools.commonPoints(S3min2, r3min, S2, r2max);
            if (tmp[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3min2, r3min, S2, r2min))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3min2, r3min, S1, r1min))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3min2, r3min, S1, r1max))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if (SOC_STEER_LOG.DEBUG && edgeSize == edgePoints.size()) {
                SOC_STEER_LOG.AddLogLine(me.getName() + " no S3min2 cross", "triangle");
                SOC_STEER_LOG.AddLogLine("-  S3min2: " + S3min2 + " r3min: " + r3min + " r1: " + r1min + "-" + r1max + " r2: " + r2min + "-" + r2max, "triangle");
            }
            edgeSize = edgePoints.size();
        } else if (SOC_STEER_LOG.DEBUG) {
            SOC_STEER_LOG.AddLogLine(me.getName() + " no S3min2", "triangle");
        }
        if (S3max2 != null) {
            tmp = SteeringTools.commonPoints(S3max2, r3max, S2, r2max);
            if (tmp[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3max2, r3max, S2, r2min))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3max2, r3max, S1, r1min))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if ((tmp = SteeringTools.commonPoints(S3max2, r3max, S1, r1max))[0] != null) {
                edgePoints.add(tmp[0]);
            }
            if (tmp[1] != null) {
                edgePoints.add(tmp[1]);
            }
            if (SOC_STEER_LOG.DEBUG && edgeSize == edgePoints.size()) {
                SOC_STEER_LOG.AddLogLine(me.getName() + " no S3max2 cross", "triangle");
                SOC_STEER_LOG.AddLogLine("-  S3max2: " + S3max2 + " r3max: " + r3max + " r1: " + r1min + "-" + r1max + " r2: " + r2min + "-" + r2max, "triangle");
            }
            edgeSize = edgePoints.size();
        } else if (SOC_STEER_LOG.DEBUG) {
            SOC_STEER_LOG.AddLogLine(me.getName() + " no S3max2", "triangle");
        }
        for (int i = 0; i < edgePoints.size(); ++i) {
            if (TriangleSteer.isSuitable((Location)edgePoints.get(i), S1, S2, propers, 8.0)) continue;
            edgePoints.set(i, null);
        }
        Location result = TriangleSteer.calculateBest(edgePoints, me.getLocation(), propers);
        if (SOC_STEER_LOG.DEBUG && result == null) {
            SOC_STEER_LOG.AddLogLineWithDate(me.getName() + ": no suitable edge points from total of:" + String.valueOf(edgePoints.size()), "triangleError");
        }
        if (SOC_STEER_LOG.DEBUG && result != null) {
            SOC_STEER_LOG.AddLogLine(me.getName() + ": has best suitable edge point:" + result.toString() + "distance: " + String.valueOf(me.getLocation().getDistance2D(result)), "triangle");
        }
        if (result == null && (double)Math.min(r1min, r2min) > Math.max(me.getLocation().getDistance2D(S2), me.getLocation().getDistance2D(S1))) {
            SOC_STEER_LOG.AddLogLineWithDate(me.getName() + " is to close to, going away from both", "triangle");
            Location mine = me.getLocation();
            Location middle = S1.add(S2.sub(S1).scale(0.0));
            return mine.add(middle.sub(mine).scale(-1.0));
        }
        if (SOC_STEER_LOG.DEBUG) {
            SOC_STEER_LOG.AddLogLine("--------------------------------------------", "triangle");
        }
        return result;
    }

    private static boolean isSuitable(Location point, Location fst, Location snd, TriangleSteeringProperties props, double tolerance) {
        if (props.getFstDistance().in((int)point.getDistance2D(fst), tolerance) && props.getSndDistance().in((int)point.getDistance2D(snd), tolerance)) {
            double a = point.getDistance2D(fst);
            double b = point.getDistance2D(snd);
            double c = fst.getDistance2D(snd);
            double gamma = Math.acos((c * c - a * a - b * b) / (-2.0 * a * b)) * 57.29577951308232;
            if (props.getAngle().in((int)gamma, tolerance / 5.0)) {
                if (SOC_STEER_LOG.DEBUG) {
                    // empty if block
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static Location calculateBest(ArrayList<Location> edgePoints, Location me, TriangleSteeringProperties props) {
        Location avgL = new Location(0.0, 0.0, 0.0);
        Location avgR = new Location(0.0, 0.0, 0.0);
        int countL = 0;
        int countR = 0;
        Vector3d divider = new Vector3d(props.getFstBot().getLocation().x - props.getSndBot().getLocation().x, props.getFstBot().getLocation().y - props.getSndBot().getLocation().y, 0.0);
        for (Location ll : edgePoints) {
            if (ll == null) continue;
            Vector3d point = ll.sub(props.getSndBot().getLocation()).asVector3d();
            if (SteeringTools.pointIsLeftFromTheVector(point, divider)) {
                avgL = avgL.add(ll);
                ++countL;
                continue;
            }
            avgR = avgR.add(ll);
            ++countR;
        }
        boolean Lsuit = false;
        if (countL != 0 && TriangleSteer.isSuitable(avgL = avgL.scale(1.0 / (double)countL), props.getFstBot().getLocation(), props.getSndBot().getLocation(), props, 1.0)) {
            if (SOC_STEER_LOG.DEBUG) {
                SOC_STEER_LOG.AddLogLine("suitable t\u011b\u017ei\u0161t\u011b L: " + avgL.toString(), "triangle");
            }
            Lsuit = true;
        }
        boolean Rsuit = false;
        if (countR != 0 && TriangleSteer.isSuitable(avgR = avgR.scale(1.0 / (double)countR), props.getFstBot().getLocation(), props.getSndBot().getLocation(), props, 1.0)) {
            if (SOC_STEER_LOG.DEBUG) {
                SOC_STEER_LOG.AddLogLine("suitable t\u011b\u017ei\u0161t\u011b R: " + avgR.toString(), "triangle");
            }
            Rsuit = true;
        }
        if (Lsuit && avgL.getDistance2D(me) < avgR.getDistance2D(me) && Rsuit || Lsuit && !Rsuit) {
            return avgL;
        }
        if (Rsuit && !Lsuit || Rsuit && avgL.getDistance2D(me) >= avgR.getDistance2D(me) && Lsuit) {
            return avgR;
        }
        Location best = null;
        double min = 2.147483647E9;
        for (Location p : edgePoints) {
            double next;
            if (p == null || !((next = me.getDistance2D(p)) < min)) continue;
            best = p;
            min = next;
        }
        if (best == null && SOC_STEER_LOG.DEBUG) {
            SOC_STEER_LOG.AddLogLine("nenasli jsme vhodny bod, tzn s nami hybou uz jen pritazlivo odpudive sily vuci dalsim postavam ", "triangleError");
        }
        return best;
    }

    private Vector3d attraction(UT2004Bot botself, UT2004Bot other, double trashhold) {
        trashhold = trashhold < 1.0 ? 1.0 : trashhold;
        double max = this.properties.getFstDistance().getMax();
        double min = this.properties.getFstDistance().getMin();
        double actual = botself.getLocation().getDistance2D(other.getLocation());
        Vector3d result = new Vector3d(0.0, 0.0, 0.0);
        if (actual > max * trashhold) {
            result = new Vector3d(other.getLocation().x - botself.getLocation().x, other.getLocation().y - botself.getLocation().y, 0.0);
            result.normalize();
            result.scale(actual / max);
            if (SOC_STEER_LOG.DEBUG) {
                SOC_STEER_LOG.AddLogLine("!! " + botself.getName() + ": too far from " + other.getName() + " --strength " + result.length(), "triangle");
            }
        }
        if (actual < min * trashhold) {
            result = new Vector3d(botself.getLocation().x - other.getLocation().x, botself.getLocation().y - other.getLocation().y, 0.0);
            result.normalize();
            result.scale(min / actual);
            if (SOC_STEER_LOG.DEBUG) {
                SOC_STEER_LOG.AddLogLine("!! " + botself.getName() + ": too close to " + other.getName() + " --strength " + result.length(), "triangle");
            }
        }
        return result;
    }

    private Location getFocus() {
        if (this.properties.getHeadingType() == null) {
            return null;
        }
        String headingType = this.properties.getHeadingType();
        UT2004Bot fst = this.properties.getFstBot();
        UT2004Bot snd = this.properties.getSndBot();
        Interval headingValue = this.properties.getHeadingValue();
        int fromFst = 0;
        boolean headingToAgents = false;
        if (headingType.compareTo(fst.getName().substring(0, 1)) == 0) {
            fromFst = 100 - headingValue.avg();
            headingToAgents = true;
        } else if (headingType.compareTo(snd.getName().substring(0, 1)) == 0) {
            fromFst = headingValue.avg();
            headingToAgents = true;
        }
        if (headingToAgents) {
            Location fstL = fst.getLocation();
            Location sndL = snd.getLocation();
            Location shift = fstL.sub(sndL).scale((double)fromFst / 100.0);
            Location result = sndL.add(shift);
            return result;
        }
        if (headingType.compareTo(KTowards) == 0) {
            return null;
        }
        return null;
    }

    @Override
    public SteeringResult runSocial(Vector3d scaledActualVelocity, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, Location focus) {
        return (SteeringResult)this.run(scaledActualVelocity, wantsToGoFaster, wantsToStop, focus);
    }
}

