/*
 * Decompiled with CFR 0.152.
 */
package SocialSteeringsBeta;

import SocialSteeringsBeta.IAnimationEngine;
import SocialSteeringsBeta.ISocialSteering;
import SocialSteeringsBeta.SOC_STEER_LOG;
import SocialSteeringsBeta.SteeringResult;
import SteeringStuff.ISteering;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringManager;
import SteeringStuff.SteeringType;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetWalk;
import javax.vecmath.Vector3d;

public class SocialSteeringManager
extends SteeringManager {
    protected IAnimationEngine animationEngine;
    private static final double KPaceTreshold = 100.0;
    private int lastWS = 0;

    public SocialSteeringManager(UT2004Bot bot, Raycasting raycasting, AdvancedLocomotion locomotion, IAnimationEngine engine, double multiplier) {
        super(bot, raycasting, locomotion, multiplier);
        this.animationEngine = engine;
    }

    public SocialSteeringManager(UT2004Bot bot, Raycasting raycasting, AdvancedLocomotion locomotion, IAnimationEngine engine) {
        this(bot, raycasting, locomotion, engine, 1.0);
    }

    @Override
    public void moveTheBot(Vector3d nextVelocity, boolean everyoneWantsToGoFaster, Location focusLocation) {
        double nextVelocityLength;
        double precision = 3.0;
        if (nextVelocity instanceof SteeringResult) {
            precision = ((SteeringResult)nextVelocity).getAccurancyMultiplier();
            if (SOC_STEER_LOG.DEBUG) {
                SOC_STEER_LOG.AddLogLine(String.valueOf(precision), SOC_STEER_LOG.KSync);
            }
        }
        if ((nextVelocityLength = nextVelocity.length() * this.multiplier) < 0.01) {
            this.myNextVelocity = new Vector3d(0.0, 0.0, 0.0);
            this.locomotion.stopMovement();
            if (this.animationEngine.canBeInterupt(this.botself)) {
                this.animationEngine.playAnimation("idleanim", this.botself, false);
                this.locomotion.setSpeed(0.0);
            }
            this.lastWS = 0;
            return;
        }
        int walkType = precision < 2.0 ? 1 : (nextVelocityLength < 22000.0 ? 2 : 3);
        double nextVelMult = nextVelocityLength / 220.0;
        nextVelocityLength = nextVelMult * 220.0;
        nextVelocity.normalize();
        nextVelocity.scale(nextVelocityLength);
        this.myNextVelocity = new Vector3d(nextVelocity.x, nextVelocity.y, nextVelocity.z);
        this.botself.getAct().act((CommandMessage)new Configuration().setSpeedMultiplier(Double.valueOf(nextVelocityLength / 220.0)).setAutoTrace(Boolean.valueOf(true)).setDrawTraceLines(Boolean.valueOf(this.drawRaycasting)));
        if (this.animationEngine.canBeInterupt(this.botself)) {
            switch (walkType) {
                case 1: {
                    Location tLoc = new Location(this.botself.getLocation().x + nextVelocity.x, this.botself.getLocation().y + nextVelocity.y, this.botself.getLocation().z);
                    Move m = new Move();
                    m.setFirstLocation(tLoc);
                    m.setFocusLocation(focusLocation);
                    this.locomotion.setSpeed(0.3);
                    this.botself.getAct().act((CommandMessage)m);
                    if (this.lastWS == walkType) break;
                    if (SOC_STEER_LOG.DEBUG) {
                        SOC_STEER_LOG.AddLogLine("slowMove", SOC_STEER_LOG.KSync + this.botself.getName());
                    }
                    this.botself.getAct().act((CommandMessage)new SetWalk().setWalk(Boolean.valueOf(true)).setRunAnim("walk_drunk").setWalkAnim("walk_drunk"));
                    this.animationEngine.playAnimation("walk_drunk", this.botself, true);
                    break;
                }
                case 2: {
                    Location tLoc = new Location(this.botself.getLocation().x + nextVelocity.x, this.botself.getLocation().y + nextVelocity.y, this.botself.getLocation().z);
                    Move mm = new Move();
                    mm.setFirstLocation(tLoc);
                    mm.setFocusLocation(tLoc);
                    this.locomotion.setSpeed(0.9);
                    this.botself.getAct().act((CommandMessage)mm);
                    if (this.lastWS == walkType) break;
                    if (SOC_STEER_LOG.DEBUG) {
                        SOC_STEER_LOG.AddLogLine("Walk", SOC_STEER_LOG.KSync + this.botself.getName());
                    }
                    this.botself.getAct().act((CommandMessage)new SetWalk().setWalk(Boolean.valueOf(true)).setRunAnim("walk_carry01").setWalkAnim("walk_carry01"));
                    this.animationEngine.playAnimation("walk_carry01", this.botself, true);
                }
            }
        } else {
            if (SOC_STEER_LOG.DEBUG) {
                SOC_STEER_LOG.AddLogLine("Wait for animation unineruptible animation", SOC_STEER_LOG.KSync + this.botself.getName());
            }
            this.locomotion.setSpeed(0.0);
        }
        this.lastWS = walkType;
    }

    @Override
    protected Location setFocusSpecific(SteeringType steeringType, boolean wantsToStop, Location newFocus, Location focusLoc) {
        if (steeringType == SteeringType.TRIANGLE) {
            return newFocus;
        }
        return super.setFocusSpecific(steeringType, wantsToStop, newFocus, focusLoc);
    }

    @Override
    protected Vector3d setVelocitySpecific(ISteering steering, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, Location newFocus) {
        if (steering instanceof ISocialSteering) {
            return ((ISocialSteering)steering).runSocial(this.myNextVelocity, wantsToGoFaster, wantsToStop, newFocus);
        }
        return super.setVelocitySpecific(steering, wantsToGoFaster, wantsToStop, newFocus);
    }
}

