package SocialSteeringsBeta;

import SteeringStuff.ISteering;
import SteeringStuff.RefBoolean;
import SteeringStuff.SteeringManager;
import SteeringStuff.SteeringType;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetWalk;
import javax.vecmath.Vector3d;

/**
 *
 * @author Petr
 */
public class SocialSteeringManager extends SteeringManager{

    protected IAnimationEngine animationEngine;
    private static final double KPaceTreshold = 100;
    private int lastWS  = 0;

    public SocialSteeringManager(UT2004Bot bot, Raycasting raycasting, AdvancedLocomotion locomotion,IAnimationEngine engine, double multiplier) {
        super(bot, raycasting, locomotion, multiplier);
        animationEngine = engine;
    }

    public SocialSteeringManager(UT2004Bot bot, Raycasting raycasting, AdvancedLocomotion locomotion, IAnimationEngine engine) {
        this(bot, raycasting, locomotion, engine ,1);

    }


    /**
     * DOCASNY komentar v CZ
     * Pridana funkcionalita by mela byt schopna <br/>
     * a)zastavit pohyb pokud bude animationEngine prehravat neprerusitelnou animaci<br/>
     * b)pouzivat 3 rychlosti pohybu misto puvodnich 2<br/>
     * c)treti rychlost pohybu nechava postavu natocenou do focus celou dobu pohybu, tedy je vhodne pouzit "animaci slapani zeli" <br/>
     * @param nextVelocity
     * @param everyoneWantsToGoFaster
     * @param focusLocation
     */
    @Override
    public void moveTheBot(Vector3d nextVelocity, boolean everyoneWantsToGoFaster, Location focusLocation) {

        double precision = 3;
        if (nextVelocity instanceof SteeringResult) {
           
            precision = ((SteeringResult) nextVelocity).getAccurancyMultiplier();
            //<editor-fold defaultstate="collapsed" desc="debug">
            if (SOC_STEER_LOG.DEBUG) {
                SOC_STEER_LOG.AddLogLine(String.valueOf(precision), SOC_STEER_LOG.KSync);
            }
            //</editor-fold>
        }
        //super.moveTheBot(nextVelocity, everyoneWantsToGoFaster, focusLocation);

        //determinates how we will move(run = 3, walk = 2, pace = 1)
        int walkType;

        double nextVelocityLength = nextVelocity.length() * multiplier; //The multiplier enables to enlarge or decrease the velocity. E.g. to make the bot to run.
     
        if (nextVelocityLength <0.01){
            myNextVelocity = new Vector3d(0,0,0);
            locomotion.stopMovement();
            if(animationEngine.canBeInterupt(botself)){
                animationEngine.playAnimation("idleanim", botself, false);
                locomotion.setSpeed(0.0); //just for sure:D
            }
            lastWS = 0;
            return;
        }
        
        if(precision < 2)
        {
            walkType = 1;
        }else if(nextVelocityLength < WALK_VELOCITY_LENGTH *100) //TODO: hack, we will just test pace and walk
        {
            walkType = 2;
        }else //running
        {
            walkType = 3;
        }
        
        
        
        //<editor-fold defaultstate="collapsed" desc="wants to go faster">
//        if (nextVelocityLength < 0.8*WALK_VELOCITY_LENGTH && everyoneWantsToGoFaster) {
//            if (SteeringManager.DEBUG) System.out.println("we enlarge the velocity");
//            nextVelocityLength = 0.8 * WALK_VELOCITY_LENGTH;
//        }
        
         //</editor-fold>
        
        double nextVelMult = nextVelocityLength / WALK_VELOCITY_LENGTH;
        nextVelocityLength = nextVelMult * WALK_VELOCITY_LENGTH;
        nextVelocity.normalize();
        nextVelocity.scale(nextVelocityLength);
       
        
        myNextVelocity = new Vector3d(nextVelocity.x, nextVelocity.y, nextVelocity.z);

        botself.getAct().act(new Configuration().setSpeedMultiplier(nextVelocityLength / WALK_VELOCITY_LENGTH).setAutoTrace(true).setDrawTraceLines(drawRaycasting));

        

        if(animationEngine.canBeInterupt(botself))
        {
            switch (walkType) {
                case 1:
                    Location tLoc = new Location(botself.getLocation().x + nextVelocity.x, botself.getLocation().y + nextVelocity.y, botself.getLocation().z);

                    Move m = new Move();
                    m.setFirstLocation(tLoc);
                    m.setFocusLocation(focusLocation);
                    
                    locomotion.setSpeed(0.3);
                    botself.getAct().act(m);
                    if(lastWS == walkType) break;
                     //<editor-fold defaultstate="collapsed" desc="debug">
                     if (SOC_STEER_LOG.DEBUG) {
                    SOC_STEER_LOG.AddLogLine("slowMove", SOC_STEER_LOG.KSync + botself.getName());
                     }
                    //</editor-fold>
                    //TODO: hack used wrong animation 
                    botself.getAct().act(new SetWalk().setWalk(true).setRunAnim("walk_drunk").setWalkAnim("walk_drunk"));
                    animationEngine.playAnimation("walk_drunk", botself, true);
                    break;
                case 2:
             
                    tLoc = new Location(botself.getLocation().x + nextVelocity.x, botself.getLocation().y + nextVelocity.y, botself.getLocation().z);
                    
                    Move mm = new Move();
                    mm.setFirstLocation(tLoc);
                    mm.setFocusLocation(tLoc);
                    
                    locomotion.setSpeed(0.9);
                    botself.getAct().act(mm);
                    if(lastWS == walkType) break; 
                    //<editor-fold defaultstate="collapsed" desc="debug">
                     if (SOC_STEER_LOG.DEBUG) {
                    SOC_STEER_LOG.AddLogLine("Walk", SOC_STEER_LOG.KSync + botself.getName());
                     }
                    //</editor-fold> 
                     //TODO: hack used wrong animation 
                    botself.getAct().act(new SetWalk().setWalk(true).setRunAnim("walk_carry01").setWalkAnim("walk_carry01"));
                    animationEngine.playAnimation("walk_carry01", botself, true);
                    
                   
                    break;
            }
        }else
        {
            //<editor-fold defaultstate="collapsed" desc="debug">
             if (SOC_STEER_LOG.DEBUG) {
            SOC_STEER_LOG.AddLogLine("Wait for animation unineruptible animation", SOC_STEER_LOG.KSync + botself.getName());
             }
            //</editor-fold>
            locomotion.setSpeed(0.0);
            //animation that can not be interrupted is played on botself, so we do not move
        }
        lastWS = walkType;
        

    }

    @Override
    protected Location setFocusSpecific(SteeringType steeringType, boolean wantsToStop, Location newFocus, Location focusLoc) {
        if(steeringType == SteeringType.TRIANGLE)
        {
            return newFocus;
        }
        return super.setFocusSpecific(steeringType, wantsToStop, newFocus, focusLoc);
    }

    @Override
    protected Vector3d setVelocitySpecific(ISteering steering, RefBoolean wantsToGoFaster, RefBoolean wantsToStop, Location newFocus) {
        if(steering  instanceof ISocialSteering){
            return ((ISocialSteering)steering).runSocial(myNextVelocity, wantsToGoFaster, wantsToStop, newFocus);
        }else{
            return super.setVelocitySpecific(steering, wantsToGoFaster, wantsToStop, newFocus);
        }
    }
    
    




}
