/*
 * Decompiled with CFR 0.152.
 */
package SteeringStuff;

import java.awt.Color;
import java.io.Serializable;
import java.util.LinkedList;

public enum SteeringType implements Serializable
{
    OBSTACLE_AVOIDANCE(1, "Obstacle Avoidance", new Color(0.60784316f, 0.39607844f, 0.20784314f, 0.5f)),
    PEOPLE_AVOIDANCE(2, "People Avoidance", new Color(0.9019608f, 0.5019608f, 0.28235295f, 0.5f)),
    TARGET_APPROACHING(3, "Target Approaching", new Color(0.5647059f, 0.827451f, 0.08235294f, 0.5f)),
    PATH_FOLLOWING(4, "Path Following", new Color(0.25490198f, 0.60784316f, 0.20784314f, 0.3f)),
    WALL_FOLLOWING(5, "Wall Following", new Color(1.0f, 0.7294118f, 0.34509805f, 0.5f)),
    LEADER_FOLLOWING(6, "Leader Following", new Color(0.23529412f, 0.6862745f, 0.39215687f, 0.5f)),
    WALK_ALONG(7, "Walk Along", new Color(1.0f, 0.5686275f, 0.3372549f, 0.5f)),
    TRIANGLE(8, "Triangle", new Color(0.0f, 0.0f, 0.0f, 0.5f));

    private int order;
    private String name;
    private Color color;

    private SteeringType(int order, String name, Color color) {
        this.order = order;
        this.name = name;
        this.color = color;
    }

    public static LinkedList<SteeringType> getCollection() {
        LinkedList<SteeringType> result = new LinkedList<SteeringType>();
        for (SteeringType type : SteeringType.values()) {
            result.add(type);
        }
        return result;
    }

    public Color getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }
}

