package cz.cuni.amis.pogamut.sposh.ut2004.senses;

import cz.cuni.amis.pogamut.sposh.context.UT2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;

/**
 * Get current health of the bot.
 * @author Honza
 */
@PrimitiveInfo(name = "health", description = "Return how many points does bot have")
public class Health extends StateSense<UT2004Context, Integer> {

    public Health(UT2004Context ctx) {
        super("health", ctx);
    }

    @Override
    public Integer query(VariableContext params) {
        return ctx.getInfo().getHealth();
    }
}
