package cz.cuni.amis.pogamut.sposh.context;

import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.teamcomm.bot.UT2004TCClient;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.UT2004TCServer;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.protocol.messages.TCControlServerAlive;

/**
 * State context with {@link UT2004TCClient} available through {@link #getTCClient()}.
 * @author Jimmy
 */
public class UT2004TCContext<BOT extends UT2004Bot> extends UT2004Context<BOT> {

	protected UT2004TCClient tcClient;
	
	public UT2004TCContext(String name, BOT bot) {
		super(name, bot);
	}

	protected void initializeModules(BOT bot) {
		super.initializeModules(bot);
		tcClient = new UT2004TCClient(bot, bot.getWorldView());		
	}
	
	/**
	 * Team-Communication client, auto-connects to {@link UT2004TCServer} once the server advertised itself via {@link TCControlServerAlive} message.
	 * @return
	 */
	public UT2004TCClient getTCClient() {
		return tcClient;
	}

}
