/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class Iterators<NODE>
implements Iterator<NODE>,
Iterable<NODE> {
    private Iterator<NODE>[] iterators;
    private int currentIteratorIndex;
    private Iterator<NODE> previousIterator;
    private Iterator<NODE> iterator;
    private boolean switched;
    private boolean removed;
    private boolean next;

    public Iterators(Iterator<NODE> ... iterators) {
        this.init(iterators);
    }

    public Iterators(Iterable<NODE> ... iterables) {
        Iterator[] iterators = new Iterator[iterables == null ? 0 : iterables.length];
        for (int i = 0; i < iterables.length; ++i) {
            iterators[i] = iterables[i] == null ? null : iterables[i].iterator();
        }
        this.init(iterators);
    }

    private void init(Iterator<NODE> ... iterators) {
        if (iterators == null || iterators.length == 0) {
            this.currentIteratorIndex = 1;
            this.iterator = null;
        } else {
            this.iterators = iterators;
            this.currentIteratorIndex = 0;
            this.previousIterator = null;
            this.iterator = iterators[0];
            this.switched = false;
            this.removed = false;
            this.next = false;
        }
    }

    private boolean nextIterator() {
        if (this.iterators == null || this.currentIteratorIndex >= this.iterators.length) {
            return false;
        }
        this.previousIterator = this.iterator;
        this.switched = true;
        do {
            ++this.currentIteratorIndex;
            if (this.currentIteratorIndex >= this.iterators.length) {
                return false;
            }
            this.iterator = this.iterators[this.currentIteratorIndex];
        } while (this.iterator == null || !this.iterator.hasNext());
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext() || this.nextIterator();
    }

    @Override
    public NODE next() {
        if (this.iterator == null) {
            throw new NoSuchElementException("Last iterator fully used.");
        }
        if (this.iterator.hasNext() || this.nextIterator()) {
            this.next = true;
            this.switched = false;
            this.removed = false;
            return this.iterator.next();
        }
        throw new NoSuchElementException("Last iterator fully used.");
    }

    @Override
    public void remove() {
        if (!this.next) {
            throw new IllegalStateException("next() method has never been successfully called, no element to remove!");
        }
        if (this.removed) {
            throw new IllegalStateException("remove() was called twice for the same element, unsupported!");
        }
        if (this.switched) {
            this.previousIterator.remove();
        } else {
            this.iterator.remove();
        }
        this.removed = true;
    }

    @Override
    public Iterator<NODE> iterator() {
        return this;
    }
}

