/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.jumppad;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.jumppad.JumppadCollectorTask;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;

class JumppadResult {
    private final JumppadCollectorTask task;
    private final List<NavPoint> jumppads;

    JumppadResult(JumppadCollectorTask task) {
        this.task = task;
        this.jumppads = new LinkedList<NavPoint>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void export() {
        if (this.jumppads.isEmpty()) {
            return;
        }
        OutputStreamWriter fstream = null;
        try {
            String fullFilePath = this.task.getResultPath() + this.task.getFileName();
            File resultFile = new File(fullFilePath);
            resultFile.getParentFile().mkdirs();
            fstream = new FileWriter(resultFile);
            BufferedWriter out = new BufferedWriter(fstream);
            for (NavPoint jumppad : this.jumppads) {
                Location location = jumppad.getLocation();
                out.write(String.format("%f;%f;%f\n", location.x, location.y, location.z));
            }
            out.close();
        }
        catch (IOException ex) {
        }
        finally {
            try {
                if (fstream != null) {
                    fstream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    void add(NavPoint navPoint) {
        this.jumppads.add(navPoint);
    }
}

