/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.EvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.MapPathsBotParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.NavigationFactory;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data.MapPathsResult;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.MapPathsEvaluationTask;
import java.util.HashMap;
import java.util.Map;

public class MapPathsBot
extends EvaluatingBot {
    private IPathPlanner myPathPlanner;
    private IUT2004Navigation myNavigation;

    public MapPathsBotParameters getParams() {
        return (MapPathsBotParameters)this.bot.getParams();
    }

    protected void initializePathFinding(UT2004Bot bot) {
        super.initializePathFinding(bot);
        this.myPathPlanner = NavigationFactory.getPathPlanner(this, bot, this.getParams().getPathPlanner());
        this.myNavigation = NavigationFactory.getNavigation(this, bot, this.getParams().getNavigation());
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("MapPathsBot");
    }

    @Override
    public void beforeFirstLogic() {
        MapPathsEvaluationTask.PathType pathType = this.getParams().getPathType();
        MapPathsResult result = new MapPathsResult(this.getParams().getTask(), this.log);
        for (Map.Entry<UnrealId, NavPoint> entry : this.navPoints.getNavPoints().entrySet()) {
            NavPoint from = entry.getValue();
            boolean removeAll = from.isLiftCenter() && this.removeLifts(pathType);
            HashMap<UnrealId, NavPointNeighbourLink> outgoingEdges = new HashMap<UnrealId, NavPointNeighbourLink>(from.getOutgoingEdges());
            for (Map.Entry<UnrealId, NavPointNeighbourLink> edgeEntry : outgoingEdges.entrySet()) {
                if (removeAll) {
                    this.navBuilder.removeEdgesBetween(entry.getKey().getStringId(), edgeEntry.getKey().getStringId());
                    continue;
                }
                NavPointNeighbourLink edge = edgeEntry.getValue();
                int edgeFlags = edge.getFlags();
                boolean remove = !this.evaluateFlags(edgeFlags, pathType);
                if (!remove) continue;
                this.navBuilder.removeEdge(entry.getKey().getStringId(), edgeEntry.getKey().getStringId());
            }
        }
        this.fwMap.refreshPathMatrix();
        boolean relevantOnly = this.getParams().getRelevantOnly();
        for (NavPoint from : this.navPoints.getNavPoints().values()) {
            if (relevantOnly && !this.isRelevant(from)) continue;
            for (NavPoint to : this.navPoints.getNavPoints().values()) {
                if (from.equals(to) || relevantOnly && !this.isRelevant(to)) continue;
                IPathFuture<NavPoint> path = this.fwMap.computePath(from, to);
                if (path == null || path.get() == null) {
                    result.addFailed();
                    continue;
                }
                result.addSuccessful();
            }
        }
        result.export();
        this.isCompleted = true;
        this.bot.stop();
    }

    private boolean evaluateFlags(int edgeFlags, MapPathsEvaluationTask.PathType pathType) {
        int jumpFlag = 8;
        boolean isJump = (edgeFlags & jumpFlag) == jumpFlag;
        switch (pathType) {
            case ALL: 
            case NO_LIFTS: {
                return true;
            }
            case NO_JUMPS: 
            case NO_JUMP_NO_LIFTS: {
                return !isJump;
            }
        }
        throw new AssertionError((Object)pathType.name());
    }

    private boolean removeLifts(MapPathsEvaluationTask.PathType pathType) {
        return pathType == MapPathsEvaluationTask.PathType.NO_LIFTS || pathType == MapPathsEvaluationTask.PathType.NO_JUMP_NO_LIFTS;
    }

    private boolean isRelevant(NavPoint from) {
        return from.isPlayerStart() || from.isInvSpot();
    }
}

