/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator;

import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.DirectRunner;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.EvaluatorHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class ServerRunner {
    private static final Properties properties = new Properties();
    private static String label;
    public static final boolean isLab = true;
    private final List<EvaluatorHandle> evaluations = new LinkedList<EvaluatorHandle>();
    private List<File> tasks;
    private boolean isResume = false;
    private static final Logger log;

    public static boolean doCompress() {
        return Boolean.parseBoolean(properties.getProperty("compress"));
    }

    public static boolean doDelete() {
        return Boolean.parseBoolean(properties.getProperty("delete"));
    }

    public static String getExecutionDir() {
        return properties.getProperty("execution.dir");
    }

    public static String getUnrealHome() {
        return properties.getProperty("unreal.home");
    }

    public static String getRecordsPath() {
        return ServerRunner.getUnrealHome() + "/Demos";
    }

    public static int getPathRecordsLimit() {
        return Integer.parseInt(properties.getProperty("path.records.limit"));
    }

    static String getStatsBasePath() {
        return properties.getProperty("stats.dir");
    }

    static int getProcessorMultiplier() {
        return Integer.parseInt(properties.getProperty("proc.multiplier"));
    }

    public ServerRunner() {
        log.setLevel(Level.ALL);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        handler.setLevel(Level.ALL);
        log.addHandler(handler);
    }

    public void initTasks(String[] args) {
        this.tasks = new ArrayList<File>();
        String evalDir = ".";
        if (args.length >= 1) {
            evalDir = args[0];
        }
        File x = new File(evalDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".eval.xml");
            }
        };
        this.tasks.addAll(Arrays.asList(x.listFiles(filter)));
        if (args.length >= 2) {
            this.isResume = args[1].equals("--resume");
            if (!this.isResume) {
                label = args[1];
            } else if (args.length >= 3) {
                label = args[2];
            }
        }
    }

    public static void main(String[] args) {
        ServerRunner runner = new ServerRunner();
        ServerRunner.initRunner(args);
        runner.initTasks(args);
        if (ServerRunner.hasCapacityForMultiEvaluation() && runner.getTasks().size() > 1) {
            log.fine("Multi evaluation");
            runner.run(label);
        } else {
            log.fine("Direct evaluation");
            DirectRunner directRunner = new DirectRunner(runner, label);
            directRunner.run(runner.isResume);
        }
        System.exit(0);
    }

    private void run(String label) {
        log.log(Level.INFO, "Starting multiple evaluation of {0} tasks", this.tasks.size());
        boolean done = this.tasks.isEmpty();
        while (!done) {
            boolean hasFreeTasks = true;
            while (this.hasCapacity() && hasFreeTasks) {
                File task = this.getFreeTask();
                if (task == null) {
                    hasFreeTasks = false;
                    continue;
                }
                EvaluatorHandle handle = new EvaluatorHandle();
                if (!handle.createEvaluator(task, log, this.isResume, label)) continue;
                log.fine("Created new evaluation handler");
                this.evaluations.add(handle);
            }
            log.log(Level.INFO, "Tasks in progress: {0}, Unfinished tasks: {1}", new Object[]{this.evaluations.size(), this.tasks.size()});
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.checkRunningEvaluations();
            done = this.tasks.isEmpty();
        }
    }

    private void checkRunningEvaluations() {
        LinkedList<EvaluatorHandle> finishedHandles = new LinkedList<EvaluatorHandle>();
        block7: for (EvaluatorHandle handle : this.evaluations) {
            switch (handle.getStatus()) {
                case NEW: {
                    continue block7;
                }
                case CREATED: {
                    continue block7;
                }
                case RUNNING: {
                    continue block7;
                }
                case NOT_RESPONDING: {
                    continue block7;
                }
                case FAILED: 
                case DESTROYED: 
                case COMPLETED: {
                    File task = handle.getTask();
                    log.log(Level.INFO, "Tasks completed. Status: {0}", (Object)handle.getStatus());
                    this.tasks.remove(task);
                    finishedHandles.add(handle);
                    continue block7;
                }
            }
            throw new AssertionError((Object)handle.getStatus().name());
        }
        for (EvaluatorHandle handle : finishedHandles) {
            this.evaluations.remove(handle);
        }
    }

    private static boolean hasCapacityForMultiEvaluation() {
        int threshold = 3;
        int available = Runtime.getRuntime().availableProcessors() * ServerRunner.getProcessorMultiplier();
        return available >= threshold;
    }

    private boolean hasCapacity() {
        int available;
        int used = 0 + this.evaluations.size() * 2;
        return used < (available = Runtime.getRuntime().availableProcessors() * ServerRunner.getProcessorMultiplier());
    }

    protected File getFreeTask() {
        for (File task : this.tasks) {
            boolean isFree = true;
            for (EvaluatorHandle handle : this.evaluations) {
                if (handle.getTask() != task) continue;
                isFree = false;
                break;
            }
            if (!isFree) continue;
            return task;
        }
        return null;
    }

    public List<File> getTasks() {
        return this.tasks;
    }

    private static void initRunner(String[] args) {
        if (args.length > 1) {
            log.log(Level.INFO, "Unreal home: {0}", ServerRunner.getUnrealHome());
            log.log(Level.INFO, "Exec dir: {0}", ServerRunner.getExecutionDir());
        }
    }

    private static void loadProperties() throws FileNotFoundException, IOException {
        File propertiesFile = new File("config.properties");
        if (!propertiesFile.exists()) {
            throw new FileNotFoundException("Required properties file config.properties doesn't exist!");
        }
        properties.load(new FileInputStream(propertiesFile));
    }

    static {
        try {
            ServerRunner.loadProperties();
        }
        catch (IOException ex) {
            Logger.getLogger(ServerRunner.class.getName()).log(Level.SEVERE, null, ex);
        }
        log = Logger.getLogger("ServerRunner");
    }
}

