/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshConstants;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.OffMeshEdge;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004Draw;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.DrawStayingDebugLines;
import java.util.List;
import java.util.logging.Logger;
import math.geom3d.Point3D;

public class NavMeshDraw
extends UT2004Draw {
    private NavMesh navMesh;

    public NavMeshDraw(NavMesh navMesh, Logger log, IUT2004ServerProvider serverProvider) {
        super(log, serverProvider);
        this.navMesh = navMesh;
    }

    public boolean draw(boolean drawMesh, boolean drawOffMeshLinks) {
        if (this.navMesh == null || !this.navMesh.isLoaded()) {
            return false;
        }
        if (drawMesh) {
            for (int i = 0; i < this.navMesh.polyCount(); ++i) {
                DrawStayingDebugLines d = new DrawStayingDebugLines();
                String lines = this.polygonToDebugString(i);
                d.setVectors(lines);
                d.setColor(new Location(255.0, 255.0, 255.0));
                d.setClearAll(i == 0);
                this.getServer().getAct().act(d);
            }
        }
        if (drawOffMeshLinks) {
            for (OffMeshPoint op : this.navMesh.getOffMeshPoints()) {
                for (OffMeshEdge oe : op.getOutgoingEdges()) {
                    DrawStayingDebugLines d = new DrawStayingDebugLines();
                    String lines = this.offMeshEdgeToDebugString(oe);
                    d.setVectors(lines);
                    d.setColor(NavMeshConstants.getColorForOffMeshConnection(oe, this.getServer()));
                    d.setClearAll(false);
                    this.getServer().getAct().act(d);
                }
            }
        }
        return true;
    }

    public void draw(String lines, Location color) {
        DrawStayingDebugLines d = new DrawStayingDebugLines();
        d.setVectors(lines);
        d.setColor(color);
        d.setClearAll(false);
        this.getServer().getAct().act(d);
    }

    public void unDraw() {
        DrawStayingDebugLines d = new DrawStayingDebugLines();
        d.setClearAll(true);
        this.getServer().getAct().act(d);
    }

    public void drawOnePolygon(int i, Location color) {
        DrawStayingDebugLines d = new DrawStayingDebugLines();
        String lines = this.polygonToDebugString(i);
        d.setVectors(lines);
        d.setColor(color);
        d.setClearAll(false);
        this.getServer().getAct().act(d);
    }

    public void drawOnePolygon(int i) {
        this.drawOnePolygon(i, new Location(255.0, 255.0, 0.0));
    }

    private void drawAtom(INavMeshAtom atom, Location location) {
        if (atom.getClass() == NavMeshPolygon.class) {
            NavMeshPolygon p = (NavMeshPolygon)atom;
            this.drawOnePolygon(p.getPolygonId(), location);
        }
    }

    public void drawPolygonPath(List<INavMeshAtom> polygonPath, Location location) {
        for (INavMeshAtom atom : polygonPath) {
            this.drawAtom(atom, location);
        }
    }

    public void drawPath(IPathFuture<ILocated> path, Location color) {
        List<ILocated> pathList = path.get();
        for (int i = 0; i < pathList.size() - 1; ++i) {
            StringBuilder lines = new StringBuilder();
            lines.append(pathList.get((int)i).getLocation().x).append(",");
            lines.append(pathList.get((int)i).getLocation().y).append(",");
            lines.append(pathList.get((int)i).getLocation().z + 40.0).append(";");
            lines.append(pathList.get((int)(i + 1)).getLocation().x).append(",");
            lines.append(pathList.get((int)(i + 1)).getLocation().y).append(",");
            lines.append(pathList.get((int)(i + 1)).getLocation().z + 40.0).append("");
            this.draw(lines.toString(), color);
        }
    }

    public void drawOnlyBiggestLeaf() {
        for (int i = 0; i < this.navMesh.polyCount(); ++i) {
            if (!this.navMesh.getBiggestLeafInTree().polys.contains(i)) continue;
            DrawStayingDebugLines d = new DrawStayingDebugLines();
            String lines = this.polygonToDebugString(i);
            d.setVectors(lines);
            d.setColor(new Location(255.0, 255.0, 0.0));
            d.setClearAll(false);
            this.getServer().getAct().act(d);
        }
    }

    public String toDebugString() {
        StringBuilder result = new StringBuilder("");
        for (int i = 0; i < this.navMesh.getPolys().size(); ++i) {
            int[] p = this.navMesh.getPolys().get(i);
            for (int j = 0; j < p.length; ++j) {
                if (result.length() > 0) {
                    result.append(";");
                }
                double[] v1 = this.navMesh.getVerts().get(p[j]);
                double[] v2 = j == p.length - 1 ? this.navMesh.getVerts().get(p[0]) : this.navMesh.getVerts().get(p[j + 1]);
                result.append(v1[0] + "," + v1[1] + "," + v1[2] + ";" + v2[0] + "," + v2[1] + "," + v2[2]);
            }
        }
        return result.toString();
    }

    public String polygonToDebugString(int polygonNumber) {
        StringBuilder result = new StringBuilder("");
        int[] p = this.navMesh.getPolys().get(polygonNumber);
        for (int j = 0; j < p.length; ++j) {
            if (result.length() > 0) {
                result.append(";");
            }
            double[] v1 = this.navMesh.getVerts().get(p[j]);
            double[] v2 = j == p.length - 1 ? this.navMesh.getVerts().get(p[0]) : this.navMesh.getVerts().get(p[j + 1]);
            result.append(v1[0] + "," + v1[1] + "," + (v1[2] + 30.0) + ";" + v2[0] + "," + v2[1] + "," + (v2[2] + 30.0));
        }
        return result.toString();
    }

    private String offMeshEdgeToDebugString(OffMeshEdge oe) {
        StringBuilder result = new StringBuilder("");
        Location l1 = oe.getFrom().getLocation();
        Location l2 = oe.getTo().getLocation();
        result.append(l1.x + "," + l1.y + "," + l1.z + ";" + l2.x + "," + l2.y + "," + l2.z);
        double[] vector = new double[]{l1.x - l2.x, l1.y - l2.y, l1.z - l2.z};
        double length = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        vector[0] = vector[0] * (1.0 / length * 20.0);
        vector[1] = vector[1] * (1.0 / length * 20.0);
        vector[2] = vector[2] * (1.0 / length * 20.0);
        Point3D cross = new Point3D(l2.x + vector[0], l2.y + vector[1], l2.z + vector[2]);
        double[] vector2 = new double[]{vector[1] / 2.0, -vector[0] / 2.0};
        Point3D arrowPoint1 = new Point3D(cross.getX() + vector2[0], cross.getY() + vector2[1], cross.getZ());
        Point3D arrowPoint2 = new Point3D(cross.getX() - vector2[0], cross.getY() - vector2[1], cross.getZ());
        result.append(";");
        result.append(arrowPoint1.getX() + "," + arrowPoint1.getY() + "," + arrowPoint1.getZ() + ";" + l2.x + "," + l2.y + "," + l2.z);
        result.append(";");
        result.append(arrowPoint2.getX() + "," + arrowPoint2.getY() + "," + arrowPoint2.getZ() + ";" + l2.x + "," + l2.y + "," + l2.z);
        result.append(";");
        result.append(arrowPoint1.getX() + "," + arrowPoint1.getY() + "," + arrowPoint1.getZ() + ";" + arrowPoint2.getX() + "," + arrowPoint2.getY() + "," + arrowPoint2.getZ());
        return result.toString();
    }

    private String pathToDebugString(IPathFuture<ILocated> path) {
        StringBuilder result = new StringBuilder("");
        ILocated p0 = null;
        List<ILocated> pathList = path.get();
        for (ILocated p1 : pathList) {
            if (result.length() > 0) {
                result.append(";");
            }
            if (p0 != null) {
                result.append(Math.round(p0.getLocation().x) + "," + Math.round(p0.getLocation().y) + "," + Math.round(p0.getLocation().z) + ";" + Math.round(p1.getLocation().x) + "," + Math.round(p1.getLocation().y) + "," + Math.round(p1.getLocation().z));
            }
            p0 = p1;
        }
        return result.toString();
    }
}

