/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.maps.HashMapList;
import java.util.Iterator;

public class UT2004MapTweaks {
    private HashMapList<String, IMapTweak> tweaks = new HashMapList();
    private LogCategory log;

    public UT2004MapTweaks(UT2004Bot bot) {
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.registerDefaultTweaks();
    }

    public LogCategory getLog() {
        return this.log;
    }

    public void register(String mapName, IMapTweak tweak) {
        this.tweaks.add(mapName.toLowerCase(), tweak);
    }

    public void clearTweaks(String mapName) {
        this.tweaks.remove(mapName);
    }

    public void clearAllTweaks() {
        this.tweaks.clear();
    }

    public void tweak(NavigationGraphBuilder builder) {
        String mapName = builder.getMapName().toLowerCase();
        Object mapTweaks = this.tweaks.get(mapName);
        if (mapTweaks == null || mapTweaks.size() == 0) {
            this.log.warning("No navigation graph tweaks for map " + builder.getMapName());
            return;
        }
        this.log.warning("Tweaking navigation graph for map " + builder.getMapName());
        Iterator i$ = mapTweaks.iterator();
        while (i$.hasNext()) {
            IMapTweak mapTweak = (IMapTweak)i$.next();
            if (mapTweak == null) continue;
            this.log.fine("Applying tweak: " + mapTweak.toString());
            try {
                mapTweak.tweak(builder);
            }
            catch (Exception e) {
                this.log.severe(ExceptionToString.process("Failed to apply tweak.", e));
            }
        }
    }

    protected void registerDefaultTweaks() {
        this.register("DM-1on1-Albatross", new IMapTweak(){

            @Override
            public void tweak(NavigationGraphBuilder builder) {
                UT2004MapTweaks.this.tweak_DM_1on1_Albatross(builder);
            }
        });
        this.register("DM-1on1-Trite", new IMapTweak(){

            @Override
            public void tweak(NavigationGraphBuilder builder) {
                UT2004MapTweaks.this.tweak_DM_1on1_Trite(builder);
            }
        });
        this.register("DM-1on1-Roughinery-FPS", new IMapTweak(){

            @Override
            public void tweak(NavigationGraphBuilder builder) {
                UT2004MapTweaks.this.tweak_DM_1on1_Roughinery_FPS(builder);
            }
        });
    }

    protected void tweak_DM_1on1_Roughinery_FPS(NavigationGraphBuilder builder) {
        builder.removeEdge("PathNode74", "InventorySpot4");
        builder.removeEdge("PathNode51", "PathNode11");
        builder.removeEdge("PathNode11", "PathNode105");
        builder.removeEdge("PathNode25", "PathNode46");
        builder.removeEdge("PathNode26", "PathNode15");
        builder.removeEdge("PlayerStart12", "PathNode106");
        builder.removeEdge("PathNode126", "InventorySpot44");
        builder.removeEdge("PathNode34", "PathNode33");
        builder.modifyNavPoint("InventorySpot28").addZ(-50.0).apply();
        builder.modifyNavPoint("InventorySpot29").addZ(-50.0).apply();
        builder.modifyNavPoint("InventorySpot30").addZ(-50.0).apply();
        builder.modifyNavPoint("InventorySpot31").addZ(-50.0).apply();
    }

    protected void tweak_DM_1on1_Albatross(NavigationGraphBuilder builder) {
        builder.removeEdge("PathNode54", "JumpSpot4");
        builder.modifyNavPoint("PathNode2").modifyEdgeTo("InventorySpot321").removeJumpFlag().modifyEdge();
        builder.modifyNavPoint("InventorySpot321").modifyEdgeTo("PathNode2").removeJumpFlag().modifyEdge();
        builder.modifyNavPoint("InventorySpot321").modifyEdgeTo("InventorySpot322").removeJumpFlag().modifyEdge();
        builder.modifyNavPoint("InventorySpot322").modifyEdgeTo("InventorySpot321").removeJumpFlag().modifyEdge();
        builder.modifyNavPoint("InventorySpot322").modifyEdgeTo("InventorySpot323").removeJumpFlag().modifyEdge();
        builder.modifyNavPoint("InventorySpot323").modifyEdgeTo("InventorySpot322").removeJumpFlag().modifyEdge();
        builder.modifyNavPoint("InventorySpot323").modifyEdgeTo("PlayerStart3").removeJumpFlag().modifyEdge();
        builder.modifyNavPoint("PlayerStart3").modifyEdgeTo("InventorySpot323").removeJumpFlag().modifyEdge();
    }

    protected void tweak_DM_1on1_Trite(NavigationGraphBuilder builder) {
        builder.removeEdge("JumpSpot0", "InventorySpot125");
    }

    public static interface IMapTweak {
        public void tweak(NavigationGraphBuilder var1);
    }
}

