/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.jumppad;

import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.TaskBotParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.jumppad.JumppadCollectorBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.EvaluationTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JumppadCollectorTask
extends EvaluationTask<TaskBotParameters, JumppadCollectorBot> {
    private String mapName;
    private String resultPath;

    public JumppadCollectorTask() {
        super(TaskBotParameters.class, JumppadCollectorBot.class);
    }

    private JumppadCollectorTask(String map, String resultPath) {
        this();
        this.mapName = map;
        this.resultPath = resultPath;
    }

    @Override
    public String getMapName() {
        return this.mapName;
    }

    @Override
    public String getResultPath() {
        String fullPath = String.format("%s/", this.resultPath, this.getMapName());
        File resultFile = new File(fullPath);
        resultFile.mkdirs();
        return fullPath;
    }

    @Override
    public String getLogPath() {
        return null;
    }

    @Override
    public String getFileName() {
        return String.format("%s.jumppads", this.mapName);
    }

    @Override
    public void setResultBasePath(String basePath) {
    }

    @Override
    public TaskBotParameters getBotParams() {
        return new TaskBotParameters<JumppadCollectorTask>(this);
    }

    @Override
    public Level getLogLevel() {
        return Level.OFF;
    }

    public static List<JumppadCollectorTask> createBatch(List<String> mapNames, String resultPath) {
        ArrayList<JumppadCollectorTask> list = new ArrayList<JumppadCollectorTask>(mapNames.size());
        for (String map : mapNames) {
            JumppadCollectorTask task = new JumppadCollectorTask(map, resultPath);
            list.add(task);
        }
        return list;
    }
}

