/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.NavigationState;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.LocationUpdate;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.EvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.NavigationFactory;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;

public class JumpInspectingBot
extends EvaluatingBot {
    private IWorldEventListener<LocationUpdate> listener;
    Phase phase = Phase.ToStart;
    double jumpDistance = 400.0;
    NavPoint startSpot = null;
    Location endSpot = null;
    int step = 0;
    boolean inEvaluation = false;
    boolean jumpedAlready = false;
    boolean inJump = false;
    Location beforeJumpMax = null;
    Location afterJumpMax = null;
    Location beforeJumpMin = null;
    Location afterJumpMin = null;
    private IPathPlanner myPathPlanner;
    private IUT2004Navigation myNavigation;
    double zOnTheGround = -78.15;
    int jumpCount = 0;
    double maxJump = Double.NEGATIVE_INFINITY;
    boolean turned = false;

    protected void initializePathFinding(UT2004Bot bot) {
        super.initializePathFinding(bot);
        this.myPathPlanner = NavigationFactory.getPathPlanner(this, bot, "navMesh");
        this.myNavigation = NavigationFactory.getNavigation(this, bot, "acc");
    }

    public void beforeFirstLogic() {
        super.beforeFirstLogic();
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        this.bot.getLog().setLevel(Level.WARNING);
        this.move.getLog().setLevel(Level.WARNING);
        this.listener = new IWorldEventListener<LocationUpdate>(){

            public void notify(LocationUpdate t) {
                LocationUpdate locationUpdate = t;
                Phase lastPhase = JumpInspectingBot.this.phase;
                switch (lastPhase) {
                    case Running: {
                        if (JumpInspectingBot.this.inJump) {
                            JumpInspectingBot.this.log.warning("LOCATION UPDATE - L: {0}, V: {1}, R: {2}, SimTime: {3}", new Object[]{locationUpdate.getLoc(), locationUpdate.getVel(), locationUpdate.getRot(), locationUpdate.getSimTime()});
                        }
                        if (!JumpInspectingBot.this.inJump || JumpInspectingBot.this.isOnTheGround(locationUpdate.getLoc())) break;
                        JumpInspectingBot.this.phase = Phase.Jumping;
                        break;
                    }
                    case Jumping: {
                        if (locationUpdate.getLoc().z > JumpInspectingBot.this.maxJump) {
                            JumpInspectingBot.this.maxJump = locationUpdate.getLoc().z;
                        }
                        JumpInspectingBot.this.log.warning("LOCATION UPDATE - L: {0}, V: {1}, R: {2}, SimTime: {3}", new Object[]{locationUpdate.getLoc(), locationUpdate.getVel(), locationUpdate.getRot(), locationUpdate.getSimTime()});
                        if (!JumpInspectingBot.this.isOnTheGround(locationUpdate.getLoc())) break;
                        JumpInspectingBot.this.phase = Phase.AfterJump;
                        JumpInspectingBot.this.inJump = false;
                    }
                }
                switch (JumpInspectingBot.this.phase) {
                    case Running: {
                        JumpInspectingBot.this.beforeJumpMax = locationUpdate.getLoc();
                        break;
                    }
                    case Jumping: {
                        if (lastPhase == Phase.Running) {
                            JumpInspectingBot.this.beforeJumpMin = locationUpdate.getLoc();
                        }
                        JumpInspectingBot.this.afterJumpMin = locationUpdate.getLoc();
                        break;
                    }
                    case AfterJump: {
                        if (lastPhase != Phase.Jumping) break;
                        JumpInspectingBot.this.afterJumpMax = locationUpdate.getLoc();
                        double jumpLengthMax = JumpInspectingBot.this.afterJumpMax.getDistance2D(JumpInspectingBot.this.beforeJumpMax);
                        double jumpLengthMin = JumpInspectingBot.this.afterJumpMin.getDistance2D(JumpInspectingBot.this.beforeJumpMin);
                        JumpInspectingBot.this.log.log(Level.WARNING, "JUMP FINISHED: MAX: {0} MIN: {1}", new Object[]{jumpLengthMax, jumpLengthMin});
                        JumpInspectingBot.this.log.log(Level.WARNING, "Before MAX loc: {0}", (Object)JumpInspectingBot.this.beforeJumpMax);
                        JumpInspectingBot.this.log.log(Level.WARNING, "After MAX loc: {0}", (Object)JumpInspectingBot.this.afterJumpMax);
                        JumpInspectingBot.this.log.log(Level.WARNING, "Before MIN loc: {0}", (Object)JumpInspectingBot.this.beforeJumpMin);
                        JumpInspectingBot.this.log.log(Level.WARNING, "After MIN loc: {0}", (Object)JumpInspectingBot.this.afterJumpMin);
                    }
                }
            }
        };
        this.world.addEventListener(LocationUpdate.class, this.listener);
        this.myNavigation.addStrongNavigationListener((FlagListener)new FlagListener<NavigationState>(){

            public void flagChanged(NavigationState changedValue) {
                if (changedValue == NavigationState.TARGET_REACHED && JumpInspectingBot.this.phase == Phase.ToStart && JumpInspectingBot.this.bot.getLocation().getDistance2D(JumpInspectingBot.this.startSpot.getLocation()) < 100.0) {
                    JumpInspectingBot.this.phase = Phase.OnStart;
                }
            }
        });
        String firstSpotId = "DM-1on1-Idoma.InventorySpot11";
        String secondSpotId = "DM-1on1-Roughinery.InventorySpot123";
        this.startSpot = this.navPoints.getNavPoint(UnrealId.get((String)firstSpotId));
        this.endSpot = new Location(this.startSpot.getLocation()).setX(600.0);
    }

    public void logic() {
        if (this.bot.getVelocity().size() < 10.0) {
            switch (this.phase) {
                case ToStart: {
                    this.body.getAction().respawn((ILocated)this.startSpot);
                    this.phase = Phase.OnStart;
                    break;
                }
                case OnStart: {
                    if (!this.info.atLocation((ILocated)this.startSpot)) break;
                    this.zOnTheGround = this.bot.getLocation().z;
                    this.act.act((CommandMessage)new Move(this.endSpot, null, null, this.endSpot));
                    this.phase = Phase.Running;
                    break;
                }
                default: {
                    this.phase = Phase.ToStart;
                }
            }
        }
        if (this.phase == Phase.Running && this.isOnTheGround(this.bot.getLocation()) && this.bot.getLocation().getDistance2D(this.startSpot.getLocation()) > this.jumpDistance) {
            this.move.jump(true, 0.39, 680.0);
            this.log.warning("JUMP INITIATED");
            this.inJump = true;
            ++this.jumpCount;
        }
        if (this.jumpCount > 30) {
            this.log.log(Level.WARNING, "MAX JUMP: {0}", (Object)this.maxJump);
            this.log.info("No more jumps to jump, we are finished...");
            this.isCompleted = true;
            new Runnable(){

                public void run() {
                    JumpInspectingBot.this.bot.stop();
                }
            }.run();
        }
    }

    private boolean isOnTheGround(Location location) {
        return location.z <= this.zOnTheGround + 1.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        ToStart,
        OnStart,
        Running,
        Jumping,
        AfterJump,
        AtEnd;

    }
}

