/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator;

import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.FileNames;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.ServerRunner;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.SingleTaskEvaluator;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.EvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.ExtendedBotNavigationParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.NavigationEvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.PathContainer;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data.EvaluationResult;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data.RecordType;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.IEvaluationTask;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.INavigationEvaluationTask;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.task.NavigationEvaluationTask;
import cz.cuni.amis.pogamut.ut2004.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import org.zeroturnaround.zip.ZipUtil;

public class SingleNavigationTaskEvaluator
extends SingleTaskEvaluator {
    private String currentLog = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute(IEvaluationTask task, boolean isResume, String label) {
        if (!NavigationEvaluationTask.class.isAssignableFrom(task.getClass())) {
            return super.execute(task);
        }
        NavigationEvaluationTask nTask = (NavigationEvaluationTask)task;
        if (nTask.getRecordType() != RecordType.PATH && nTask.getRecordType() != RecordType.PATH_FAILED) {
            return super.execute(task);
        }
        task.setResultBasePath(ServerRunner.getStatsBasePath());
        int status = 0;
        UCCWrapper server = null;
        UT2004Bot bot = null;
        int stopTimeout = 21600000;
        boolean done = false;
        int iteration = 0;
        Object params = task.getBotParams();
        if (label != null) {
            File file = new File(task.getResultPath(), label + ".label");
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                log.info(ex.getMessage());
            }
        }
        if (isResume) {
            ExtendedBotNavigationParameters extParams = this.tryResume((NavigationEvaluationTask)task);
            if (extParams == null) {
                return 0;
            }
            params = extParams;
            iteration = extParams.getIteration() - 1;
        }
        while (true) {
            ExtendedBotNavigationParameters paramsExt;
            NavigationEvaluatingBot evalBot;
            block44: {
                Object var14_16;
                if (done) {
                    System.out.close();
                    this.processResult(task);
                    return status;
                }
                try {
                    try {
                        this.setupLog(task.getLogPath(), iteration);
                        ++iteration;
                        server = SingleNavigationTaskEvaluator.run(task.getMapName());
                        System.out.println("Setting control port to: " + server.getControlPort());
                        System.setProperty("pogamut.ut2004.server.port", Integer.toString(server.getControlPort()));
                        UT2004BotRunner botRunner = new UT2004BotRunner(task.getBotClass(), "EvaluatingBot", server.getHost(), server.getBotPort());
                        botRunner.setLogLevel(task.getLogLevel());
                        log.fine("Starting evaluation bot.");
                        System.out.println("Starting evaluation bot from NavigationTaskEvaluator.");
                        bot = (UT2004Bot)botRunner.startAgents(new UT2004BotParameters[]{params}).get(0);
                        bot.awaitState(IAgentStateDown.class, (long)stopTimeout);
                    }
                    catch (UCCStartException ex) {
                        status = -1;
                        log.throwing(SingleTaskEvaluator.class.getSimpleName(), "execute", ex);
                        var14_16 = null;
                        if (bot != null && bot.notInState(new Class[]{IAgentStateDown.class})) {
                            bot.stop();
                            bot.kill();
                            status = 0;
                            System.out.println("Bad termination of bot.");
                        }
                        if (server != null) {
                            server.stop();
                        }
                        if (bot != null) {
                            System.out.println("Correct repeat finally..");
                            evalBot = (NavigationEvaluatingBot)bot.getController();
                            if (status == 0) {
                                paramsExt = evalBot.getNewExtendedParams();
                                System.out.println("Correct status.");
                                System.out.printf("EVALUATION ITERATION COMPLETED - Processed paths: %d, Remaining paths: %d", paramsExt.getEvaluationResult().getProcessedCount(), paramsExt.getPathContainer().size());
                                if (paramsExt.getEvaluationResult().getProcessedCount() >= paramsExt.getLimitForCompare() || paramsExt.getPathContainer().isEmpty()) {
                                    done = true;
                                } else {
                                    params = new ExtendedBotNavigationParameters((INavigationEvaluationTask)task, paramsExt.getPathContainer(), paramsExt.getEvaluationResult());
                                    ((ExtendedBotNavigationParameters)((Object)params)).setIteration(paramsExt.getIteration() + 1);
                                }
                                this.exportPathContainer(task, paramsExt.getPathContainer());
                            }
                        }
                        if (status != 0) {
                            done = true;
                        }
                        bot = null;
                        System.gc();
                        continue;
                    }
                    catch (PogamutException pex) {
                        if (bot != null && ((EvaluatingBot)bot.getController()).isCompleted()) {
                            status = 0;
                            log.fine("Evaluation completed");
                            System.out.println("Evaluation completed");
                        } else {
                            status = -2;
                            log.throwing(SingleTaskEvaluator.class.getSimpleName(), "execute", pex);
                            System.out.println("Unknown Pogamut exception.");
                        }
                        var14_16 = null;
                        if (bot != null && bot.notInState(new Class[]{IAgentStateDown.class})) {
                            bot.stop();
                            bot.kill();
                            status = 0;
                            System.out.println("Bad termination of bot.");
                        }
                        if (server != null) {
                            server.stop();
                        }
                        if (bot != null) {
                            System.out.println("Correct repeat finally..");
                            evalBot = (NavigationEvaluatingBot)bot.getController();
                            if (status == 0) {
                                paramsExt = evalBot.getNewExtendedParams();
                                System.out.println("Correct status.");
                                System.out.printf("EVALUATION ITERATION COMPLETED - Processed paths: %d, Remaining paths: %d", paramsExt.getEvaluationResult().getProcessedCount(), paramsExt.getPathContainer().size());
                                if (paramsExt.getEvaluationResult().getProcessedCount() >= paramsExt.getLimitForCompare() || paramsExt.getPathContainer().isEmpty()) {
                                    done = true;
                                } else {
                                    params = new ExtendedBotNavigationParameters((INavigationEvaluationTask)task, paramsExt.getPathContainer(), paramsExt.getEvaluationResult());
                                    ((ExtendedBotNavigationParameters)((Object)params)).setIteration(paramsExt.getIteration() + 1);
                                }
                                this.exportPathContainer(task, paramsExt.getPathContainer());
                            }
                        }
                        if (status != 0) {
                            done = true;
                        }
                        bot = null;
                        System.gc();
                        continue;
                    }
                    var14_16 = null;
                    if (bot == null) break block44;
                }
                catch (Throwable throwable) {
                    var14_16 = null;
                    if (bot != null && bot.notInState(new Class[]{IAgentStateDown.class})) {
                        bot.stop();
                        bot.kill();
                        status = 0;
                        System.out.println("Bad termination of bot.");
                    }
                    if (server != null) {
                        server.stop();
                    }
                    if (bot != null) {
                        System.out.println("Correct repeat finally..");
                        evalBot = (NavigationEvaluatingBot)bot.getController();
                        if (status == 0) {
                            paramsExt = evalBot.getNewExtendedParams();
                            System.out.println("Correct status.");
                            System.out.printf("EVALUATION ITERATION COMPLETED - Processed paths: %d, Remaining paths: %d", paramsExt.getEvaluationResult().getProcessedCount(), paramsExt.getPathContainer().size());
                            if (paramsExt.getEvaluationResult().getProcessedCount() >= paramsExt.getLimitForCompare() || paramsExt.getPathContainer().isEmpty()) {
                                done = true;
                            } else {
                                params = new ExtendedBotNavigationParameters((INavigationEvaluationTask)task, paramsExt.getPathContainer(), paramsExt.getEvaluationResult());
                                ((ExtendedBotNavigationParameters)((Object)params)).setIteration(paramsExt.getIteration() + 1);
                            }
                            this.exportPathContainer(task, paramsExt.getPathContainer());
                        }
                    }
                    if (status != 0) {
                        done = true;
                    }
                    bot = null;
                    System.gc();
                    throw throwable;
                }
                if (bot.notInState(new Class[]{IAgentStateDown.class})) {
                    bot.stop();
                    bot.kill();
                    status = 0;
                    System.out.println("Bad termination of bot.");
                }
            }
            if (server != null) {
                server.stop();
            }
            if (bot != null) {
                System.out.println("Correct repeat finally..");
                evalBot = (NavigationEvaluatingBot)bot.getController();
                if (status == 0) {
                    paramsExt = evalBot.getNewExtendedParams();
                    System.out.println("Correct status.");
                    System.out.printf("EVALUATION ITERATION COMPLETED - Processed paths: %d, Remaining paths: %d", paramsExt.getEvaluationResult().getProcessedCount(), paramsExt.getPathContainer().size());
                    if (paramsExt.getEvaluationResult().getProcessedCount() >= paramsExt.getLimitForCompare() || paramsExt.getPathContainer().isEmpty()) {
                        done = true;
                    } else {
                        params = new ExtendedBotNavigationParameters((INavigationEvaluationTask)task, paramsExt.getPathContainer(), paramsExt.getEvaluationResult());
                        ((ExtendedBotNavigationParameters)((Object)params)).setIteration(paramsExt.getIteration() + 1);
                    }
                    this.exportPathContainer(task, paramsExt.getPathContainer());
                }
            }
            if (status != 0) {
                done = true;
            }
            bot = null;
            System.gc();
        }
    }

    public int execute(IEvaluationTask task) {
        return this.execute(task, false, null);
    }

    protected void setupLog(String logPath, int iteration) {
        if (iteration != 0) {
            System.out.close();
            if (this.currentLog != null) {
                File currentLogFile = new File(this.currentLog);
                if (ServerRunner.doCompress()) {
                    ZipUtil.packEntry((File)currentLogFile, (File)new File(this.currentLog + ".zip"));
                    currentLogFile.delete();
                    File[] demos = currentLogFile.getParentFile().listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".demo4");
                        }
                    });
                    if (demos.length > 0) {
                        ZipUtil.packEntries((File[])demos, (File)new File(currentLogFile.getParent() + "/demos-" + (iteration - 1) + ".zip"));
                        for (File demo : demos) {
                            demo.delete();
                        }
                    }
                }
            }
        }
        try {
            if (logPath != null) {
                this.currentLog = String.format("%s-%d.log", logPath.substring(0, logPath.length() - 4), iteration);
                System.setOut(new PrintStream(this.currentLog));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void exportPathContainer(IEvaluationTask task, PathContainer pathContainer) {
        String path = FileNames.joinPath(task.getResultPath(), "pathcontainer.csv");
        pathContainer.exportToFile(path);
    }

    private ExtendedBotNavigationParameters tryResume(INavigationEvaluationTask task) {
        File newResultDir = new File(task.getResultPath());
        File lastResult = null;
        long lastResultModification = 0L;
        for (File oldResult : newResultDir.getParentFile().listFiles()) {
            if (!oldResult.isDirectory() || oldResult.equals(newResultDir) || oldResult.lastModified() <= lastResultModification) continue;
            lastResult = oldResult;
            lastResultModification = oldResult.lastModified();
        }
        for (File newFile : newResultDir.listFiles()) {
            newFile.delete();
        }
        newResultDir.delete();
        if (lastResult == null) {
            return null;
        }
        File pathContainerFile = FileNames.getFile(lastResult, "pathcontainer.csv");
        if (!pathContainerFile.exists()) {
            return null;
        }
        task.setResultPath(lastResult.getAbsolutePath());
        PathContainer pathContainer = new PathContainer(null);
        pathContainer.buildFromFile(pathContainerFile, false);
        EvaluationResult results = new EvaluationResult(pathContainer.size(), task.getMapName(), null, task.getResultPath());
        File resultFile = FileNames.getFile(lastResult, "data.csv");
        if (resultFile.exists()) {
            results.loadFromFile(resultFile, pathContainer.size());
        }
        ExtendedBotNavigationParameters params = new ExtendedBotNavigationParameters(task, pathContainer, results);
        params.setIteration(results.getProcessedCount() / ServerRunner.getPathRecordsLimit() + 1);
        return params;
    }
}

