/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator;

import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.SingleNavigationTaskEvaluator;
import cz.cuni.amis.utils.process.ProcessExecution;
import cz.cuni.amis.utils.process.ProcessExecutionConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;

public class EvaluatorHandle {
    private Status status = Status.NEW;
    private ProcessExecution processExecution;
    private File task;
    private boolean isDebug = false;

    public File getTask() {
        return this.task;
    }

    public boolean createEvaluator(File task, Logger log, boolean isResume, String label) {
        this.task = task;
        if (this.status != Status.NEW) {
            return false;
        }
        String separator = System.getProperty("file.separator");
        String classpath = System.getProperty("java.class.path");
        String path = System.getProperty("java.home") + separator + "bin" + separator + "java";
        ArrayList<String> command = new ArrayList<String>();
        command.add("-cp");
        command.add(classpath);
        if (this.isDebug) {
            command.add("-Xdebug");
            command.add("-Xrunjdwp:transport=dt_socket,server=y,address=8888,suspend=y");
        }
        command.add("-Xms128m");
        command.add("-Xmx1024m");
        command.add(SingleNavigationTaskEvaluator.class.getName());
        command.add(task.getAbsolutePath());
        if (isResume) {
            command.add("--resume");
        }
        if (label != null) {
            command.add(label);
        }
        ProcessExecutionConfig config = new ProcessExecutionConfig();
        config.setPathToProgram(path);
        config.setExecutionDir(".");
        config.setArgs(command);
        config.setRedirectStdErr(false);
        config.setRedirectStdOut(false);
        this.processExecution = new ProcessExecution(config, log);
        this.processExecution.start();
        this.status = Status.CREATED;
        return true;
    }

    public Status getStatus() {
        if (this.processExecution != null) {
            if (this.processExecution.isRunning()) {
                return Status.RUNNING;
            }
            switch (this.processExecution.getExitValue()) {
                case 0: {
                    this.status = Status.COMPLETED;
                    this.processExecution = null;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    this.status = Status.FAILED;
                }
            }
        }
        return this.status;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NEW,
        CREATED,
        RUNNING,
        NOT_RESPONDING,
        FAILED,
        DESTROYED,
        COMPLETED;

    }
}

