/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.Path;
import cz.cuni.amis.utils.collections.MyCollections;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathContainer {
    private final int tabooRetryCount = 1;
    IVisionWorldView world;
    private HashMap<WorldObjectId, Set<WorldObjectId>> paths;
    private HashMap<Path, Integer> tabooPaths;
    private Set<NavPoint> starts = null;
    private boolean isInitialized = false;
    private Path currentTabooPath = null;
    private boolean loadFromFile;
    private File dataFile;
    private List<String> triteNavPoints = Arrays.asList("DM-1on1-Trite.PathNode37", "DM-1on1-Trite.InventorySpot72", "DM-1on1-Trite.InventorySpot89", "DM-1on1-Trite.InventorySpot106", "DM-1on1-Trite.InventorySpot105", "DM-1on1-Trite.InventorySpot98");

    public PathContainer(IVisionWorldView world) {
        this.world = world;
        this.paths = new HashMap();
        this.tabooPaths = new HashMap();
        this.isInitialized = world != null;
    }

    public PathContainer(Object object, boolean loadFromFile, File dataFile) {
        this.loadFromFile = loadFromFile;
        this.dataFile = dataFile;
    }

    public Path getPath() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.paths.isEmpty()) {
            if (this.currentTabooPath != null) {
                this.resetTabooPath();
            }
            this.currentTabooPath = MyCollections.getRandom(this.tabooPaths.keySet());
            return this.currentTabooPath;
        }
        WorldObjectId start = MyCollections.getRandom(this.paths.keySet());
        Set<WorldObjectId> ends = this.paths.get(start);
        while (ends == null) {
            start = MyCollections.getRandom(this.paths.keySet());
            ends = this.paths.get(start);
        }
        if (ends != null) {
            NavPoint startNavPoint = (NavPoint)this.world.get(start);
            WorldObjectId end = MyCollections.getRandom(ends);
            ends.remove(end);
            if (ends.isEmpty()) {
                this.paths.remove(start);
                if (this.getStarts() != null) {
                    this.getStarts().remove(startNavPoint);
                }
            }
            return new Path(startNavPoint, (NavPoint)this.world.get(end));
        }
        return null;
    }

    private void resetTabooPath() {
        this.tabooPaths.remove(this.currentTabooPath);
        this.currentTabooPath = null;
    }

    public Path getPath(NavPoint start) {
        if (this.isEmpty()) {
            return null;
        }
        NavPoint pathStart = start;
        Set<WorldObjectId> ends = this.paths.get(pathStart.getId());
        if (ends == null) {
            this.getStarts().remove(pathStart);
            this.paths.remove(pathStart.getId());
            return null;
        }
        WorldObjectId end = MyCollections.getRandom(ends);
        ends.remove(end);
        if (ends.isEmpty()) {
            this.paths.remove(pathStart.getId());
            if (this.getStarts() != null) {
                this.getStarts().remove(pathStart);
            }
        }
        return new Path(pathStart, (NavPoint)this.world.get(end));
    }

    public void build() {
        this.build(-1);
    }

    public void buildRelevant(int limit) {
        Map<WorldObjectId, NavPoint> navPoints = this.world.getAll(NavPoint.class);
        HashSet<WorldObjectId> relevantNavPoints = new HashSet<WorldObjectId>();
        for (NavPoint navPoint : navPoints.values()) {
            if (!navPoint.isInvSpot() && !navPoint.isPlayerStart()) continue;
            relevantNavPoints.add(navPoint.getId());
        }
        this.buildPaths(relevantNavPoints, limit);
    }

    public void buildRelevant() {
        this.buildRelevant(-1);
    }

    public boolean isEmpty() {
        return this.paths.isEmpty() && (this.tabooPaths.isEmpty() || this.tabooPaths.size() == 1 && this.currentTabooPath != null);
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (Set<WorldObjectId> set : this.paths.values()) {
            size += set.size();
        }
        return size + (this.currentTabooPath == null ? this.tabooPaths.size() : this.tabooPaths.size() - 1);
    }

    void build(int limit) {
        Map<WorldObjectId, NavPoint> navPoints = this.world.getAll(NavPoint.class);
        HashSet<WorldObjectId> navPointsIds = new HashSet<WorldObjectId>(navPoints.keySet());
        this.buildPaths(navPointsIds, limit);
    }

    private void buildPaths(Set<WorldObjectId> navPoints, int limit) {
        block6: {
            boolean buildIncrementaly;
            this.paths.clear();
            int pathCount = navPoints.size() * (navPoints.size() - 1);
            boolean bl = buildIncrementaly = limit < pathCount / 5;
            if (limit < 0 || !buildIncrementaly) {
                HashSet<WorldObjectId> relevantEnds = new HashSet<WorldObjectId>(navPoints);
                for (WorldObjectId navPointId : navPoints) {
                    HashSet<WorldObjectId> ends = new HashSet<WorldObjectId>(relevantEnds);
                    ends.remove(navPointId);
                    this.paths.put(navPointId, ends);
                }
            }
            if (limit <= 0) break block6;
            if (!buildIncrementaly) {
                while (pathCount > limit) {
                    this.getPath();
                    --pathCount;
                }
            } else {
                pathCount = 0;
                while (pathCount < limit) {
                    WorldObjectId end;
                    WorldObjectId start = MyCollections.getRandom(navPoints);
                    if (start.equals(end = MyCollections.getRandom(navPoints))) continue;
                    pathCount += this.addPath(start, end);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFromFile(File file, boolean isRepeat) {
        this.paths.clear();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            if (isRepeat) {
                reader.readLine();
            }
            String line = reader.readLine();
            while (line != null) {
                String[] splitLine = line.split(";");
                if (splitLine.length >= (isRepeat ? 3 : 2)) {
                    WorldObjectId startId = WorldObjectId.get(splitLine[isRepeat ? 1 : 0]);
                    WorldObjectId endId = WorldObjectId.get(splitLine[isRepeat ? 2 : 1]);
                    if (!isRepeat && splitLine.length == 3) {
                        this.addPath(startId, endId);
                    } else {
                        this.addPath(startId, endId);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePathsFromFile(String path) {
        this.paths.clear();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(path));
            reader.readLine();
            String line = reader.readLine();
            while (line != null) {
                String[] splitLine = line.split(";");
                if (splitLine.length >= 3) {
                    WorldObjectId startId = WorldObjectId.get(splitLine[1]);
                    WorldObjectId endId = WorldObjectId.get(splitLine[2]);
                    this.removePath(startId, endId);
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToFile(String path) {
        File pathsFile = new File(path);
        if (this.isEmpty()) {
            pathsFile.delete();
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(pathsFile));
            for (Map.Entry<WorldObjectId, Set<WorldObjectId>> entry : this.paths.entrySet()) {
                String start = entry.getKey().getStringId();
                for (WorldObjectId end : entry.getValue()) {
                    writer.write(String.format("%s;%s", start, end.getStringId()));
                    writer.newLine();
                }
            }
            for (Map.Entry<Object, Object> entry : this.tabooPaths.entrySet()) {
                Path tabooPath = (Path)entry.getKey();
                writer.write(String.format("%s;%s;%d", tabooPath.getStart().getId().getStringId(), tabooPath.getEnd().getId().getStringId(), entry.getValue()));
                writer.newLine();
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(PathContainer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private int addPath(WorldObjectId start, WorldObjectId end) {
        Set<WorldObjectId> pathsFromStart = this.paths.get(start);
        if (pathsFromStart == null) {
            pathsFromStart = new HashSet<WorldObjectId>();
            this.paths.put(start, pathsFromStart);
        }
        if (pathsFromStart.add(end)) {
            return 1;
        }
        return 0;
    }

    public boolean addTabooPath(Path path) {
        Integer retries;
        if (this.currentTabooPath != null && !this.currentTabooPath.equals(path)) {
            this.resetTabooPath();
        }
        if ((retries = this.tabooPaths.get(path)) == null) {
            this.tabooPaths.put(path, 1);
        } else {
            if (retries <= 1) {
                this.tabooPaths.remove(path);
                return false;
            }
            this.tabooPaths.put(path, retries - 1);
        }
        return true;
    }

    public void setWorld(IVisionWorldView world) {
        this.world = world;
        boolean bl = this.isInitialized = world != null;
        if (!this.isInitialized || this.loadFromFile) {
            // empty if block
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    private Set<NavPoint> getStarts() {
        if (this.starts == null && this.isInitialized) {
            this.starts = new HashSet<NavPoint>();
            for (WorldObjectId startId : this.paths.keySet()) {
                NavPoint start = (NavPoint)this.world.get(startId);
                this.starts.add(start);
            }
        }
        return this.starts;
    }

    private void removePath(WorldObjectId startId, WorldObjectId endId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

