/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.ServerRunner;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.BotNavigationParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.EvaluatingBot;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.ExtendedBotNavigationParameters;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.NavigationFactory;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.NavigationState;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.Path;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.bot.PathContainer;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data.EvaluationResult;
import cz.cuni.amis.pogamut.ut2004.navigation.evaluator.data.PathResult;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;

public class NavigationEvaluatingBot
extends EvaluatingBot {
    private IPathPlanner<ILocated> myPathPlanner;
    private IUT2004Navigation myNavigation;
    private PathContainer pathContainer;
    private Path currentPath;
    private NavigationState state;
    private Date startDate;
    private EvaluationResult result;
    private boolean waitForRecordStart = false;
    private IPathFuture<ILocated> waitingPath = null;
    private boolean failedToBuildPath = false;
    private boolean failedInNavigate = false;
    private boolean isRespawning = false;
    private ILocated respawnLocation = null;
    private long lastRespawn = Long.MAX_VALUE;
    private boolean teleportFailed = false;

    public BotNavigationParameters getParams() {
        return (BotNavigationParameters)this.bot.getParams();
    }

    public ExtendedBotNavigationParameters getExtendedParams() {
        if (!this.hasExtendedParams()) {
            return null;
        }
        BotNavigationParameters params = this.getParams();
        if (params.getClass() == ExtendedBotNavigationParameters.class) {
            return (ExtendedBotNavigationParameters)params;
        }
        return null;
    }

    public boolean hasExtendedParams() {
        return this.getParams().isPathRecord();
    }

    public ExtendedBotNavigationParameters getNewExtendedParams() {
        ExtendedBotNavigationParameters params = this.getExtendedParams();
        if (params == null) {
            params = new ExtendedBotNavigationParameters(this.getParams(), this.pathContainer, this.result);
        } else {
            params.setPathContainer(this.pathContainer);
            params.setEvaluationResult(this.result);
        }
        params.getEvaluationResult().setLog(null);
        params.getPathContainer().setWorld(null);
        return params;
    }

    protected void initializePathFinding(UT2004Bot bot) {
        super.initializePathFinding(bot);
        this.myPathPlanner = NavigationFactory.getPathPlanner(this, bot, this.getParams().getPathPlanner());
        this.myNavigation = NavigationFactory.getNavigation(this, bot, this.getParams().getNavigation());
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setName("NavigationEvaluatingBot").setManualSpawn(false);
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        ExtendedBotNavigationParameters extendedParams = this.getExtendedParams();
        if (extendedParams == null) {
            this.pathContainer = new PathContainer(this.world);
            NavigationFactory.initializePathContainer(this.pathContainer, this);
            this.result = new EvaluationResult(this.pathContainer.size(), this.info.game.getMapName(), this.log, this.getParams().getResultPath());
        } else {
            this.pathContainer = extendedParams.getPathContainer();
            this.pathContainer.setWorld(this.world);
            this.result = extendedParams.getEvaluationResult();
            this.result.setLog(this.log);
        }
        this.currentPath = this.getNextPath(null);
        this.state = NavigationState.NotMoving;
        this.myNavigation.getPathExecutor().getState().addStrongListener(new FlagListener<IPathExecutorState>(){

            @Override
            public void flagChanged(IPathExecutorState changedValue) {
                NavigationEvaluatingBot.this.pathExecutorStateChange(changedValue.getState());
            }
        });
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.myNavigation.getPathExecutor().getLog().setLevel(this.getParams().getLogLevel());
    }

    public void beforeFirstLogic() {
        if (this.getParams().isFullRecord()) {
            this.result.startRecording(this.act);
        }
    }

    public void logic() {
        this.log.info("--- Logic iteration ---");
        this.isRespawning = false;
        if (this.currentPath == null) {
            this.log.warning("Current path was NULL, which was unexpected!");
            this.currentPath = this.getNextPath(null);
        }
        this.navigatePath();
    }

    private void navigatePath() {
        this.log.info(String.format("Navigating path ID = %s", this.currentPath.getId()));
        if (this.state == NavigationState.Navigating) {
            boolean reachedTarget = this.info.atLocation(this.currentPath.getEnd().getLocation());
            if (reachedTarget) {
                this.state = NavigationState.AtTheTarget;
                this.log.info("Reached end of path...");
            } else {
                if (!this.myNavigation.isNavigating()) {
                    this.state = NavigationState.Failed;
                    this.failedInNavigate = true;
                }
                this.log.info("Navigation in progress...");
                return;
            }
        }
        if (this.state == NavigationState.OnWayToStart) {
            boolean reachedStart = this.info.atLocation(this.currentPath.getStart().getLocation());
            if (reachedStart) {
                this.state = NavigationState.NotMoving;
                this.log.info("Reached start of path...");
            } else {
                if (this.teleportFailed) {
                    this.log.info("Navigating to start from nearest NavPoint.");
                    this.myNavigation.navigate(this.currentPath.getStart());
                    if (new Date().getTime() - this.lastRespawn > 15000L) {
                        this.state = NavigationState.FailedOnWayToStart;
                        this.myNavigation.stopNavigation();
                    }
                } else {
                    this.log.info("Respawn to start in progress...");
                    if (new Date().getTime() - this.lastRespawn > 1000L) {
                        this.teleportFailed = true;
                        NavPoint nearest = this.getNearestLinkedNavPoint(this.currentPath.getStart());
                        this.initRespawn(nearest);
                        this.myNavigation.navigate(this.currentPath.getStart());
                    }
                }
                return;
            }
        }
        if (this.state == NavigationState.AtTheTarget) {
            this.log.info("Successfuly reached end. Hooray!");
            if (this.getParams().isPathRecord()) {
                this.result.stopRecording(this.act, this.currentPath, this.getParams().keepOnlyFailedRecords());
            }
            this.sendMessageToGame("Successfuly completed path!");
            this.result.addResult(this.currentPath, PathResult.ResultType.Completed, new Date().getTime() - this.startDate.getTime());
            this.startDate = null;
            this.log.info(String.format("Completed %d/%d paths...", this.result.getProcessedCount(), this.result.getTotalPaths()));
            this.currentPath = this.getNextPath(this.currentPath.getEnd());
            this.state = NavigationState.NotMoving;
        }
        if (this.state == NavigationState.Failed || this.state == NavigationState.FailedOnWayToStart) {
            PathResult.ResultType type;
            this.log.info("Navigation failed!");
            NavPoint nearestNavPoint = this.info.getNearestNavPoint();
            Location botLocation = this.info.getLocation();
            if (this.state == NavigationState.Failed) {
                if (this.getParams().isPathRecord()) {
                    this.result.stopRecording(this.act, this.currentPath, false);
                }
                this.sendMessageToGame("Path navigating failed!");
                type = this.failedToBuildPath ? PathResult.ResultType.NotBuilt : (this.failedInNavigate ? PathResult.ResultType.FailedInNavigate : PathResult.ResultType.Failed);
                this.result.addResult(this.currentPath, type, this.startDate == null ? 0L : new Date().getTime() - this.startDate.getTime(), botLocation, nearestNavPoint);
            } else if (!this.pathContainer.addTabooPath(this.currentPath)) {
                this.sendMessageToGame("Path navigating failed!");
                type = this.failedInNavigate ? PathResult.ResultType.FailedToStartInNavigate : PathResult.ResultType.FailedToStart;
                this.result.addResult(this.currentPath, type, 0L, botLocation, nearestNavPoint);
            }
            this.failedToBuildPath = false;
            this.failedInNavigate = false;
            this.startDate = null;
            this.currentPath = this.getNextPath(nearestNavPoint);
            this.state = NavigationState.NotMoving;
        }
        if (this.state != NavigationState.NotMoving) {
            this.log.severe("Invalid state!");
            return;
        }
        boolean atStart = this.info.atLocation(this.currentPath.getStart());
        if (atStart) {
            IPathFuture<ILocated> path = this.waitForRecordStart ? this.waitingPath : this.myPathPlanner.computePath(this.currentPath.getStart(), this.currentPath.getEnd());
            while (path == null || path.get() == null) {
                this.sendMessageToGame("Path building failed!");
                this.result.addResult(this.currentPath, PathResult.ResultType.NotBuilt, 0L);
                NavPoint origStart = this.currentPath.getStart();
                this.currentPath = this.getNextPath(origStart);
                if (origStart.equals(this.currentPath.getStart())) {
                    path = this.myPathPlanner.computePath(this.currentPath.getStart(), this.currentPath.getEnd());
                    continue;
                }
                this.initRespawn(this.currentPath.getStart());
                this.state = NavigationState.NotMoving;
                return;
            }
            this.currentPath.computeMetrics(path);
            if (this.getParams().isPathRecord() && !this.waitForRecordStart) {
                this.result.startRecording(this.act, this.currentPath);
                this.waitForRecordStart = true;
                this.waitingPath = path;
                return;
            }
            this.waitForRecordStart = false;
            this.waitingPath = null;
            this.startDate = new Date();
            this.log.info("Starting navigation on the path.");
            this.myNavigation.navigate(path);
            this.state = NavigationState.Navigating;
        } else {
            this.log.info("Starting respawn to the start.");
            this.initRespawn(this.currentPath.getStart());
            this.state = NavigationState.OnWayToStart;
            this.teleportFailed = false;
        }
    }

    private NavPoint getNearestLinkedNavPoint(NavPoint start) {
        HashSet<NavPoint> neigbours = new HashSet<NavPoint>();
        for (NavPointNeighbourLink edge : start.getIncomingEdges().values()) {
            neigbours.add(edge.getFromNavPoint());
        }
        return (NavPoint)DistanceUtils.getNearest(neigbours, start);
    }

    public void botKilled(BotKilled event) {
        if (!this.isRespawning) {
            if (this.respawnLocation == null) {
                this.log.info("Bot died!");
                this.state = this.state == NavigationState.OnWayToStart ? NavigationState.FailedOnWayToStart : NavigationState.Failed;
                this.myNavigation.stopNavigation();
            }
        } else {
            this.isRespawning = false;
        }
    }

    protected void pathExecutorStateChange(PathExecutorState state) {
        switch (state) {
            case PATH_COMPUTATION_FAILED: {
                this.failedToBuildPath = true;
                this.state = this.state == NavigationState.OnWayToStart ? NavigationState.FailedOnWayToStart : NavigationState.Failed;
                break;
            }
            case TARGET_REACHED: {
                break;
            }
            case STUCK: {
                this.state = this.state == NavigationState.OnWayToStart ? NavigationState.FailedOnWayToStart : NavigationState.Failed;
                break;
            }
        }
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(NavigationEvaluatingBot.class, "NavigationEvaluatingBot").setMain(true).setLogLevel(Level.INFO).startAgent();
    }

    private Path getNextPath(NavPoint start) {
        Path path;
        int processedCount = this.result.getProcessedCount();
        if (this.getParams().isPathRecord()) {
            int iteration;
            ExtendedBotNavigationParameters params = this.getExtendedParams();
            int n = iteration = params == null ? 1 : params.getIteration();
            if (processedCount >= iteration * ServerRunner.getPathRecordsLimit()) {
                this.wrapUpEvaluation();
                return null;
            }
        }
        this.log.log(Level.WARNING, "Requested next path, from {0}", start == null ? "NULL" : start);
        Path path2 = path = start == null ? this.pathContainer.getPath() : this.pathContainer.getPath(start);
        if (path == null) {
            this.log.info("No path from requested node found, looking for another");
            path = this.pathContainer.getPath();
        }
        if (path == null || processedCount >= this.getParams().getLimitForCompare()) {
            this.wrapUpEvaluation();
        }
        if (processedCount > 0 && processedCount % 10 == 0) {
            this.result.exportAggregate();
        }
        return path;
    }

    private void wrapUpEvaluation() {
        this.log.info("No more paths to navigate, we are finished...");
        this.isCompleted = true;
        new Runnable(){

            public void run() {
                NavigationEvaluatingBot.this.bot.stop();
            }
        }.run();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sendMessageToGame(String message) {
        this.body.getCommunication().sendGlobalTextMessage(message);
    }

    public void botShutdown() {
        if (this.getParams().isFullRecord()) {
            this.result.stopRecording(this.act, this.getParams().keepOnlyFailedRecords() && !this.result.hasFailedResult());
        }
        this.result.exportAggregate();
        this.result.export(true);
        super.botShutdown();
    }

    private void initRespawn(ILocated location) {
        this.respawnLocation = location;
        this.log.warning("Killing bot to init respawning of bot.");
        this.isRespawning = true;
        this.lastRespawn = new Date().getTime();
        this.respawn();
    }

    private void respawn() {
        if (this.respawnLocation == null) {
            this.log.warning("Respawning bot.");
            this.body.getAction().respawn();
        } else {
            this.log.log(Level.WARNING, "Respawning bot to location {0}.", this.respawnLocation);
            this.body.getAction().respawn(this.respawnLocation);
            this.respawnLocation = null;
        }
    }
}

