/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.navmeshbot;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@AgentScoped
public class NavMeshBot
extends UT2004BotModuleController {
    private boolean speak = false;
    private boolean drawNavMesh = true;
    private boolean drawOffMeshLinks = false;
    private boolean raycasting = false;
    private int errorMsg = 0;
    private boolean navMeshDrawn = false;
    private double waitForMesh = 0.0;
    private double waitingForMesh = 0.0;
    private boolean offMeshLinksDrawn = false;
    private double waitForOffMeshLinks = 0.0;
    private double waitingForOffMeshLinks = 0.0;
    private int sayState = -2;
    private double sayNext = 0.0;
    private boolean navigate = false;
    private List<Location> raycastLocations = new ArrayList<Location>();

    public void mapInfoObtained() {
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setName("NavMeshBot");
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        if (this.navMeshModule.isInitialized()) {
            this.say("Hello! Prepare to be amazed with NavMesh!");
        } else {
            this.say("NavMesh failed to initialize :-(");
            String map = gameInfo.getLevel();
            this.say("Current map: " + map);
            File meshFile = new File("meshes/" + map + ".navmesh");
            if (meshFile.exists()) {
                this.say("NavMesh file does not exist at: " + meshFile.getAbsolutePath());
                this.say("Provide NavMesh file and rerun the bot.");
            } else {
                this.say("NavMesh file DOES exist at: " + meshFile.getAbsolutePath());
                this.say("But there is probably some bogus in there... try to renegerate / fix and rerun the bot.");
            }
        }
    }

    public void logic() throws PogamutException {
        if (!this.navMeshModule.isInitialized()) {
            this.say("NAV MESH NOT INITIALIZED - SEE STARTUP LOGS FOR MORE INFO... (" + ++this.errorMsg + ")");
            return;
        }
        if (this.drawNavMesh && !this.drawNavMesh()) {
            return;
        }
        if (!this.speak && this.drawOffMeshLinks && !this.drawOffMeshLinks()) {
            return;
        }
        if (this.speak) {
            if (!this.speak()) {
                return;
            }
        } else {
            this.navigate = true;
        }
        if (this.navigate && !this.navigate()) {
            return;
        }
    }

    private boolean speak() {
        this.sayNext -= this.info.getTimeDelta();
        if (this.sayNext > 0.0) {
            return true;
        }
        this.sayNext = 8.0;
        switch (this.sayState) {
            case -2: {
                this.say("Done, now sit and watch how I can navigate around!");
                this.sayNext = 3.0;
                break;
            }
            case -1: {
                this.navigate = true;
                break;
            }
            case 0: {
                this.say("Notice how I'm NOT using navigation graph that comes with UT2004.");
                break;
            }
            case 1: {
                this.say("Yeah, that's right, I DO NOT NEED IT!");
                break;
            }
            case 2: {
                this.say("Whooo that feels great!");
                break;
            }
            case 3: {
                this.say("You know, the freedom to move around like a human.");
                this.sayNext = 14.0;
                break;
            }
            case 4: {
                this.say("...");
                this.sayNext = 1.5;
                break;
            }
            case 5: {
                if (this.navMeshModule.getNavMesh().getOffMeshPoints().size() == 0) {
                    this.sayState = 17;
                    return true;
                }
                this.say("Well, but I'm not honest with you.");
                this.sayNext = 4.0;
                break;
            }
            case 6: {
                this.say("I do need the navigation graph from time to time.");
                this.sayNext = 7.0;
                break;
            }
            case 7: {
                this.say("Let me show you.");
                this.nmNav.stopNavigation();
                this.sayNext = 1.0;
                this.navigate = false;
                break;
            }
            case 8: {
                if (!this.offMeshLinksDrawn) {
                    this.say("I actually need it to compute off-mesh links, see?");
                }
                if (this.drawOffMeshLinks()) break;
                this.sayNext = 0.0;
                this.sayState = 8;
                return false;
            }
            case 9: {
                this.say("But I'm using them to make my NavMesh navigation even cooler!");
                break;
            }
            case 10: {
                this.say("I LOVE IT!");
                break;
            }
            case 11: {
                this.say("Send Kudos to Bohuslav Machac, former student of Charles University in Prague, for tinkering my navigation code out!");
                this.sayNext = 20.0;
                break;
            }
            case 12: {
                this.say("Still here?");
                this.sayNext = 2.0;
                break;
            }
            case 13: {
                this.say("You might like to know that we have a tool chain that can generate NavMesh out of any UT2004 map.");
                this.sayNext = 5.0;
                break;
            }
            case 14: {
                this.say("So you can run me on custom maps as well!");
                this.sayNext = 3.0;
                break;
            }
            case 15: {
                this.say("Check out: svn://artemis.ms.mff.cuni.cz/pogamut/trunk/project/Addons/UT2004NavMeshTools");
                this.sayNext = 3.0;
                break;
            }
            case 16: {
                this.say("And send some Kudos to Mikko Mononen for creating Recast as well!");
                this.sayNext = 10.0;
                break;
            }
            case 17: {
                if (this.levelGeometryModule.isInitialized()) {
                    this.say("Hey, I've just realized that I have info about the geometry of the map as well!");
                    this.sayNext = 3.0;
                    break;
                }
                this.say("Sadly I do not have info about the map geometry with me right now, so I cannot show you may raycasting abilities...");
                this.speak = false;
                break;
            }
            case 18: {
                this.say("Cool! That means I can do some raycasting as well!");
                this.nmNav.stopNavigation();
                this.raycasting = true;
                break;
            }
            case 19: {
                this.speak = false;
            }
        }
        ++this.sayState;
        return true;
    }

    private boolean navigate() {
        if (this.nmNav.isNavigating()) {
            return false;
        }
        if (this.raycasting) {
            this.raycast();
        }
        NavPoint np = this.navPoints.getRandomNavPoint();
        this.nmNav.navigate((ILocated)np);
        return false;
    }

    private void raycast() {
        if (!this.levelGeometryModule.isInitialized()) {
            return;
        }
        this.nmNav.stopNavigation();
        double distance = Double.POSITIVE_INFINITY;
        for (Location loc : this.raycastLocations) {
            double d = loc.getDistance(this.info.getLocation());
            if (!(d < distance)) continue;
            distance = d;
        }
        if (distance < 1500.0) {
            return;
        }
        this.raycastLocations.add(this.info.getLocation());
        double raycastDistance = 500.0;
        this.say("Let's do some raycasting from here (client-side of course) up to " + (int)Math.round(raycastDistance) + " UT units distance.");
        int[] directions = new int[]{-1, 0, 1};
        ArrayList<LevelGeometry.RaycastResult> results = new ArrayList<LevelGeometry.RaycastResult>();
        StopWatch watch = new StopWatch();
        watch.start();
        int raycastCount = 0;
        for (int x : directions) {
            for (int y : directions) {
                for (int z : directions) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    ++raycastCount;
                    Location rayVector = new Location((double)x, (double)y, (double)z).getNormalized().scale(raycastDistance);
                    Location rayFrom = this.info.getLocation();
                    Location rayTo = this.info.getLocation().add(rayVector);
                    results.add(this.levelGeometryModule.getLevelGeometry().raycast(rayFrom, rayTo));
                }
            }
        }
        watch.stop();
        for (LevelGeometry.RaycastResult raycast : results) {
            if (raycast.hit) {
                this.draw.drawLine(Color.RED, raycast.from, raycast.hitLocation);
                this.draw.drawCube(Color.ORANGE, raycast.hitLocation, 8.0);
                this.draw.drawPolygon(Color.orange, this.levelGeometryModule.getLevelGeometry().getTriangle(raycast.hitTriangle));
                continue;
            }
            this.draw.drawLine(Color.BLUE, raycast.from, raycast.to);
            this.draw.drawCube(Color.CYAN, raycast.to, 8.0);
        }
        this.say(raycastCount + " raycasts in " + watch.timeStr());
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException((Throwable)e, (Object)this);
        }
    }

    private boolean drawNavMesh() {
        if (!this.navMeshDrawn) {
            this.navMeshDrawn = true;
            this.say("Drawing NavMesh...");
            this.navMeshModule.getNavMeshDraw().clearAll();
            this.navMeshModule.getNavMeshDraw().draw(true, false);
            this.say("Okey, drawing commands issued, now we have to wait a bit till it gets drawn completely...");
            this.waitForMesh = (double)(this.navMeshModule.getNavMesh().getPolys().size() / 40) - 2.5;
            this.waitingForMesh = -this.info.getTimeDelta();
        }
        if (this.waitForMesh > 0.0) {
            this.waitForMesh -= this.info.getTimeDelta();
            this.waitingForMesh += this.info.getTimeDelta();
            if (this.waitingForMesh > 2.0) {
                this.waitingForMesh = 0.0;
                this.say((int)Math.round(this.waitForMesh) + "s...");
            }
            if (this.waitForMesh > 0.0) {
                return false;
            }
        }
        return true;
    }

    private boolean drawOffMeshLinks() {
        if (!this.offMeshLinksDrawn) {
            this.offMeshLinksDrawn = true;
            if (this.navMeshModule.getNavMesh().getOffMeshPoints().size() == 0) {
                this.say("Ha! There are no off-mesh points / links within this map!");
                return true;
            }
            this.say("Drawing OffMesh Links...");
            this.navMeshModule.getNavMeshDraw().draw(false, true);
            this.say("Okey, drawing commands issued, now we have to wait a bit till it gets drawn completely...");
            this.waitForOffMeshLinks = this.navMeshModule.getNavMesh().getOffMeshPoints().size() / 10;
            this.waitingForOffMeshLinks = -this.info.getTimeDelta();
        }
        if (this.waitForOffMeshLinks > 0.0) {
            this.waitForOffMeshLinks -= this.info.getTimeDelta();
            this.waitingForOffMeshLinks += this.info.getTimeDelta();
            if (this.waitingForOffMeshLinks > 2.0) {
                this.waitingForOffMeshLinks = 0.0;
                this.say((int)Math.round(this.waitForOffMeshLinks) + "s...");
            }
            if (this.waitForOffMeshLinks > 0.0) {
                return false;
            }
        }
        return true;
    }

    private void say(String text) {
        if (this.speak) {
            this.body.getCommunication().sendGlobalTextMessage(text);
        }
        this.log.info("SAY: " + text);
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(NavMeshBot.class, "NavMeshBot").setMain(true).startAgents(1);
    }
}

