/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.teamcommbot;

import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.examples.teamcommbot.TCHello;
import cz.cuni.amis.pogamut.ut2004.teamcomm.bot.UT2004BotTCController;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCMessage;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCMessageData;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoBotJoined;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoBotLeft;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelBotJoined;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelBotLeft;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelCreated;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelDestroyed;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.UT2004TCServer;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.Cooldown;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.future.FutureStatus;
import cz.cuni.amis.utils.future.FutureWithListeners;
import cz.cuni.amis.utils.future.IFutureListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

@AgentScoped
public class TeamCommBot
extends UT2004BotTCController<UT2004Bot> {
    private static String[] names = new String[]{"Peter", "James", "Johnny", "Craig", "Jimmy", "Steve", "Ronnie", "Bobby"};
    private static int number;
    private int myNumber;
    Cooldown msgCooldown = new Cooldown(3000L);
    int msgNum = 0;
    int myChannelId = -1;

    public Initialize getInitializeCommand() {
        this.myNumber = ++number;
        return new Initialize().setName(names[this.myNumber % names.length] + (this.myNumber < 3 ? "-RED" : "-BLUE")).setTeam(Integer.valueOf(this.myNumber < 3 ? 0 : 1));
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.tcClient.getLog().setLevel(Level.ALL);
    }

    public String toString(TCMessage tcMessage) {
        StringBuffer sb = new StringBuffer();
        sb.append(tcMessage.getTarget());
        switch (tcMessage.getTarget()) {
            case CHANNEL: {
                sb.append("[");
                sb.append(tcMessage.getChannelId());
                sb.append("]");
            }
        }
        sb.append(" from " + tcMessage.getSource().getStringId());
        sb.append(" of type ");
        sb.append(tcMessage.getMessageType().getToken());
        sb.append(": ");
        sb.append(String.valueOf(tcMessage.getMessage()));
        return sb.toString();
    }

    @EventListener(eventClass=TCInfoBotJoined.class)
    public void tcBotJoined(TCInfoBotJoined botJoined) {
        this.log.info("@EventListener(TCInfoBotJoined): Bot " + botJoined.getBotId().getStringId() + " from team " + botJoined.getTeam() + " has joined the TC server.");
    }

    @EventListener(eventClass=TCInfoBotLeft.class)
    public void tcBotLeft(TCInfoBotLeft botLeft) {
        this.log.info("@EventListener(TCInfoBotLeft): Bot " + botLeft.getBotId().getStringId() + " from team " + botLeft.getTeam() + " has left the TC server.");
    }

    @EventListener(eventClass=TCInfoTeamChannelCreated.class)
    public void tcInfoTeamChannelCreated(TCInfoTeamChannelCreated channelCreated) {
        this.log.info("@EventListener(TCInfoTeamChannelCreated): New team channel " + channelCreated.getChannel().getChannelId() + " created by " + channelCreated.getChannel().getCreator().getStringId() + ".");
        if (this.myNumber > 1) {
            this.log.info("Joining channel " + channelCreated.getChannel().getChannelId() + " !");
            this.tcClient.requestJoinChannel(channelCreated.getChannel().getChannelId());
        }
    }

    @EventListener(eventClass=TCInfoTeamChannelDestroyed.class)
    public void tcInfoTeamChannelDestroyed(TCInfoTeamChannelDestroyed channelDestroyed) {
        this.log.info("@EventListener(TCInfoTeamChannelDestroyed): Team channel " + channelDestroyed.getChannelId() + " destroyed by " + channelDestroyed.getDestroyer().getStringId() + ".");
    }

    @EventListener(eventClass=TCInfoTeamChannelBotJoined.class)
    public void tcInfoTeamChannelBotJoined(TCInfoTeamChannelBotJoined botJoined) {
        this.log.info("@EventListener(TCInfoTeamChannelBotJoined): Bot " + botJoined.getBotId().getStringId() + " joined team channel " + botJoined.getChannelId() + ".");
    }

    @EventListener(eventClass=TCInfoTeamChannelBotLeft.class)
    public void tcInfoTeamChannelBotLeft(TCInfoTeamChannelBotLeft botLeft) {
        this.log.info("@EventListener(TCInfoTeamChannelBotLeft): Bot " + botLeft.getBotId().getStringId() + " left team channel " + botLeft.getChannelId() + ".");
    }

    @EventListener(eventClass=TCMessage.class)
    public void tcMessage(TCMessage tcMessage) {
        this.log.info("@EventListener(TCMessage): " + this.toString(tcMessage));
    }

    @EventListener(eventClass=TCHello.class)
    public void hello(TCHello hello) {
        this.log.info("@EventListener(TCHello): " + hello.getWho().getStringId() + " says '" + hello.getMsg() + "'");
    }

    public void logic() {
        if (!this.tcClient.isConnected()) {
            this.msgNum = 0;
            this.myChannelId = -1;
            return;
        }
        for (TCMessage msg : this.tcClient.getMessages()) {
            this.log.info("InLogic: " + this.toString(msg));
        }
        if (this.myNumber != 1) {
            return;
        }
        if (this.tcClient.getConnectedAllBots().size() != 3) {
            return;
        }
        if (!this.msgCooldown.tryUse()) {
            return;
        }
        ++this.msgNum;
        switch (this.msgNum) {
            case 1: {
                this.log.info("Sending to ALL...");
                this.tcClient.sendToAll((TCMessageData)new TCHello(this.info.getId(), "Hyo ALL!"));
                return;
            }
            case 2: {
                this.log.info("Sending to TEAM...");
                this.tcClient.sendToTeam((TCMessageData)new TCHello(this.info.getId(), "Hyo TEAM!"));
                return;
            }
            case 3: {
                HashSet connected = new HashSet(this.tcClient.getConnectedAllBots());
                connected.remove(this.info.getId());
                UnrealId sendTo = (UnrealId)MyCollections.getRandom(connected);
                if (sendTo != null) {
                    this.log.info("Sending to BOT " + sendTo.getStringId() + "...");
                    this.tcClient.sendToBot(sendTo, (TCMessageData)new TCHello(this.info.getId(), "Private ears only!"));
                }
                return;
            }
            case 4: {
                this.log.info("Creating channel...");
                this.tcClient.requestCreateChannel().addFutureListener((IFutureListener)new IFutureListener<TCInfoTeamChannelCreated>(){

                    public void futureEvent(FutureWithListeners<TCInfoTeamChannelCreated> source, FutureStatus oldStatus, FutureStatus newStatus) {
                        if (newStatus == FutureStatus.FUTURE_IS_READY) {
                            TeamCommBot.this.log.info("Channel " + ((TCInfoTeamChannelCreated)source.get()).getChannel().getChannelId() + " created...");
                            TeamCommBot.this.myChannelId = ((TCInfoTeamChannelCreated)source.get()).getChannel().getChannelId();
                        } else {
                            TeamCommBot.this.log.warning("FAILED TO CREATE CHANNEL -> retrying...");
                            TeamCommBot.this.myChannelId = -1;
                            TeamCommBot.this.msgNum = 3;
                        }
                    }
                });
                return;
            }
            case 5: {
                if (this.myChannelId < 0) {
                    --this.msgNum;
                    return;
                }
                if (this.tcClient.getChannel(this.myChannelId).getConnectedBots().size() <= 1) {
                    this.log.warning("There are too few bots in the channel...");
                    --this.msgNum;
                    return;
                }
                this.log.info("Sending to CHANNEL...");
                this.tcClient.sendToChannel(this.myChannelId, (TCMessageData)new TCHello(this.info.getId(), "Channels are great!"));
                return;
            }
            case 6: {
                this.log.info("Destroying channel...");
                this.tcClient.requestDestroyChannel(this.myChannelId).addFutureListener((IFutureListener)new IFutureListener<TCInfoTeamChannelDestroyed>(){

                    public void futureEvent(FutureWithListeners<TCInfoTeamChannelDestroyed> source, FutureStatus oldStatus, FutureStatus newStatus) {
                        if (newStatus == FutureStatus.FUTURE_IS_READY) {
                            TeamCommBot.this.log.info("Channel destroyed...");
                            TeamCommBot.this.myChannelId = -1;
                            TeamCommBot.this.msgNum = 0;
                        } else {
                            TeamCommBot.this.log.info("FAILED TO DESTROY THE CHANNEL ...");
                            if (TeamCommBot.this.tcClient.getChannel(TeamCommBot.this.myChannelId) == null) {
                                TeamCommBot.this.log.info("Channel does not exist nevertheless...");
                                TeamCommBot.this.myChannelId = -1;
                                TeamCommBot.this.msgNum = 0;
                            } else {
                                TeamCommBot.this.log.info("Channel still exist, retrying...");
                                TeamCommBot.this.msgNum = 5;
                            }
                        }
                    }
                });
            }
            case 8: {
                --this.msgNum;
                return;
            }
        }
    }

    public void botKilled(BotKilled event) {
        this.navigation.stopNavigation();
    }

    public static void main(String[] args) throws PogamutException {
        UT2004TCServer tcServer = UT2004TCServer.startTCServer();
        new UT2004BotRunner(TeamCommBot.class, "TCBot").setMain(true).setLogLevel(Level.WARNING).startAgents(3);
    }

    static {
        List n = MyCollections.toList((Object[])names);
        Collections.shuffle(n);
        names = n.toArray(new String[n.size()]);
        number = 0;
    }
}

