package cz.cuni.amis.pogamut.ut2004.examples.navgraphexporter;

import java.io.File;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.MapExport;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 * NavGraph exporter bot is used to show how to export navigation graph or import it ...
 *
 * @author Jakub Gemrot aka Jimmy
 */
@AgentScoped
public class NavGraphExporterBot extends UT2004BotModuleController {

    @Override
    public void prepareBot(UT2004Bot bot) {    	    	
    }
    
    /**
     * Here we can modify initializing command for our bot, e.g., sets its name
     * or skin.
     *
     * @return instance of {@link Initialize}
     */
    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("NavGrapheExporterBot");
    }

    /**
     * Handshake with GameBots2004 is over - bot has information about the map
     * in its world view. Many agent modules are usable since this method is
     * called.
     *
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     */
    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    	// HERE WE CAN EITHER EXPORT or IMPORT NAVIGATION GRAPH
    	
    	// EXPORTING NAVIGATION GRAPH
    	File output = new File("./" + navBuilder.getMapName() + "-orig.xml");
    	navBuilder.exportAsXML(output);
    	
    	// IMPORTING NAVIGATION GRAPH
    	File input = new File("./" + navBuilder.getMapName() + "-patch.xml");
    	if (input.exists()) { // IF PATCH FILE EXISTS
    		// LOAD THE MAP PATCH XML DEFINITION
    		MapExport map = navBuilder.importFromXML(input);
    		// APPLY THE MAP PATCH TO CURRENT GRAPH
    		navBuilder.apply(map);
    		
    		// OK AND TO CHECK WHETHER OUT PATCHES WERE APPLIED... EXPORT IT AGAIN
    		output = new File("./" + navBuilder.getMapName() + "-patched.xml");
        	navBuilder.exportAsXML(output);
    	}
    	
    	// NOTE THAT fwMap WILL AUTO-REBUILD ITS PATH AFTER THIS botInitialized() ENDS ...
    	// ... so in logic() you may safely start using your patched navgraph
    }

    @Override
    public void beforeFirstLogic() {
    	// HERE fwMap HAS ITS PATH MATRIX ALREADY RECOMPUTED!
    }

    @Override
    public void logic() throws PogamutException {
    	// HERE fwMap HAS ITS PATH MATRIX ALREADY RECOMPUTED!
    	log.info("---LOGIC---");
    }

    /**
     * This method is called when the bot is started either from IDE or from
     * command line.
     *
     * @param args
     */
    public static void main(String args[]) throws PogamutException {
        // wrapped logic for bots executions, suitable to run single bot in single JVM
        new UT2004BotRunner(NavGraphExporterBot.class, "NavGrapheExporterBot").setMain(true).startAgent();
    }
}
