package cz.cuni.amis.pogamut.ut2004.examples.attackbot;

import cz.cuni.amis.pogamut.sposh.context.UT2004Context;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.NavigationState;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004DistanceStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004PositionStuckDetector;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetector.UT2004TimeStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UT2004ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.utils.flag.FlagListener;

/**
 * Context is a class that funsions like a shared object between all primitives.
 * You may use default {@link UT2004Context} or create custom one, that is
 * extended to fulfill needs of your bot (extended memory, custom map planner
 * and other stuff).
 *
 * Remmeber to call method {@link UT2004Context#initialize() }, otherwise you
 * will end up with uninitialized modules and very likely with {@link NullPointerException}.
 *
 * @author knight, Honza
 */
public class AttackBotContext extends UT2004Context<UT2004Bot> {
    
    /** Current item our bot is currently going for */
    public Item targetItem = null;
    /** Target enemy player we are currently shooting at */
    public Player targetPlayer = null;
    
    /** Used to taboo items we were stuck going for or we have picked up recently */
    public TabooSet<Item> tabooItems;

    /**
     * AutoFixer monitors movement of agent and when it detects faulty
     * connection in the waypoints, it removes them from navigation logic.
     */
    UT2004PathAutoFixer autoFixer;

    public AttackBotContext(UT2004Bot bot) {
        super("AttackBotContext", bot);
        // IMPORTANT: Various modules of context must be initialized.
        initialize();
        
        
        
        // INITIALIZE CUSTOM MODULES
        tabooItems = new TabooSet<Item>(bot);
        
        this.getNavigation().addStrongNavigationListener(new FlagListener<NavigationState>() {
            @Override
            public void flagChanged(NavigationState changedValue) {
                switch (changedValue) {
                    case PATH_COMPUTATION_FAILED:
                    case STUCK:
                        if (targetItem != null)
                            tabooItems.add(targetItem, 30);
                    break;
                    case TARGET_REACHED:
                        if (targetItem != null)
                            tabooItems.add(targetItem, 5);                        
                    break;
                }
            }
        });
        
        this.getWeaponPrefs()
                .addGeneralPref(UT2004ItemType.LIGHTNING_GUN, true)
                .addGeneralPref(UT2004ItemType.SHOCK_RIFLE, true)
                .addGeneralPref(UT2004ItemType.FLAK_CANNON, true)
                .addGeneralPref(UT2004ItemType.MINIGUN, true)                
                .addGeneralPref(UT2004ItemType.LINK_GUN, true)
                .addGeneralPref(UT2004ItemType.ASSAULT_RIFLE, true);                        
    }
}
