package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.Param;
import cz.cuni.amis.pogamut.sposh.executor.ParamsAction;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;

/**
 * Starts shooting sensed player (player detected by sense triggering this action) and
 * sets it as focus in the navigation module. 
 * Shooting will NOT be stopped when this action is done().
 * 
 * @author knight
 */
@PrimitiveInfo(name="StartShootingSensedPlayer", description="Starts shooting player returned by sense triggering this action. Shooting will NOT bet stopped when this action is done().")
public class StartShootingSensedPlayer extends ParamsAction<AttackBotContext> {

    public StartShootingSensedPlayer(AttackBotContext ctx) {
        super(ctx);
    }

    public void init() {

    }

    public ActionResult run() {
        if (ctx.targetPlayer != null) {
            ctx.getShoot().shoot(ctx.getWeaponPrefs(), ctx.targetPlayer);            
            ctx.getNavigation().setFocus(ctx.targetPlayer);
            return ActionResult.RUNNING;
        } else {
            ctx.getLog().warning("Warning! StartShootingSensedPlayer : run() - ctx.targetPlayer == null !");
            return ActionResult.RUNNING_ONCE;
        }
    }

    public void done() {
        
    }
}
