package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.executor.Param;
import cz.cuni.amis.pogamut.sposh.executor.ParamsSense;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;

/**
 * This sense will determine, if bot can see the flag holder of the input team.
 *
 * @author knight
 */
@PrimitiveInfo(name = "SeeFlagHolder", description = "Do we see the flag holder that is a member of input $team (parameter $team with possible values \"our\" and \"enemy\")? If yes we will set this player to variable for shoot actions to work properly.")
public class SeeFlagHolder extends ParamsSense<AttackBotContext, Boolean> {

    public SeeFlagHolder(AttackBotContext ctx) {
        super(ctx, Boolean.class);
    }

    public Boolean query(@Param("$team") Team team) {
        FlagInfo flag;
        if (team == Team.ENEMY) {
            flag = ctx.getCTF().getOurFlag();
        } else {
            flag = ctx.getCTF().getEnemyFlag();        
        }
        
        Player flagHolder = ctx.getPlayers().getPlayer(flag.getHolder());
        if (flagHolder != null) {
            if (flagHolder.isVisible()) {
                ctx.targetPlayer = flagHolder;
                return true;          
            }
        }
        
        return false;
    }
   
}
