package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.Param;
import cz.cuni.amis.pogamut.sposh.executor.ParamsAction;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType.Category;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.Collection;

/**
 * Action for picking various items on the map.
 *
 * @author knight
 */
@PrimitiveInfo(name = "PickItems", description = "Go around the map and try to pick items with category supported by parameter $category (possible values \"weapons\", \"armor\", \"ammo\" and \"health\"")
public class PickItems extends ParamsAction<AttackBotContext> {

    public PickItems(AttackBotContext ctx) {
        super(ctx);
    }
    
    public void init(@Param("$category") String category) {
        ItemType.Category choosenCategory;
        if (category.toLowerCase().contentEquals("weapons"))
            choosenCategory = Category.WEAPON;
        else if (category.toLowerCase().contentEquals("ammo"))
            choosenCategory = Category.AMMO;
        else if (category.toLowerCase().contentEquals("health"))
            choosenCategory = Category.HEALTH;
        else if (category.toLowerCase().contentEquals("armor"))
            choosenCategory = Category.ARMOR;        
        else
            choosenCategory = Category.WEAPON;
                       
        Collection<Item> myItemsCollection = ctx.tabooItems.filter(ctx.getItems().getSpawnedItems(choosenCategory).values());
        
        ctx.targetItem = MyCollections.getRandomFiltered(myItemsCollection, new IFilter<Item>() {
            @Override
            public boolean isAccepted(Item object) {
                return ctx.getItems().isPickable(object);                
            }
        });
        
        if (ctx.targetItem != null) {        
            ctx.getNavigation().navigate(this.getCtx().targetItem);
        } else {
            ctx.getLog().warning("PickItems:init() - Could not find suitable item of category. ctx.targetItem == null. We will get random item of category!");
            ctx.targetItem = MyCollections.getRandom(ctx.tabooItems.filter(ctx.getItems().getAllItems(choosenCategory).values()));
            if (ctx.targetItem != null) {        
                ctx.getNavigation().navigate(this.getCtx().targetItem);
            } else {
                ctx.getLog().warning("PickItems:init() - Could not find suitable RANDOM item of category. ctx.targetItem == null. We will get random item!");
                ctx.targetItem = MyCollections.getRandom(ctx.getItems().getAllItems().values());
                ctx.getNavigation().navigate(this.getCtx().targetItem);
            }
        }
    }

    public ActionResult run() {
        if (ctx.targetItem != null) {
            if (!ctx.getNavigation().isNavigating() && !ctx.getInfo().atLocation(ctx.targetItem)) {
                ctx.getNavigation().navigate(ctx.targetItem);
                return ActionResult.RUNNING;
            } else if (ctx.getNavigation().isNavigating()) {
                return ActionResult.RUNNING;    
            }
        }
        
        return ActionResult.RUNNING_ONCE;                                        
    }
    
    public void done() {
        
    }
}
