package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;

/**
 * Boolean sense for detecting, if the bot is holding the flag of enemy team.
 *
 * @author knight
 */
@PrimitiveInfo(name = "MyBotHoldsEnemyFlag", description = "Is flag of enemy team held by my bot?")
public class MyBotHoldsEnemyFlag extends StateSense<AttackBotContext, Boolean> {

    public MyBotHoldsEnemyFlag(AttackBotContext ctx) {
        super(ctx);
    }

    @Override
    public Boolean query(VariableContext params) {
        return ctx.getCTF().isBotCarryingEnemyFlag();        
    }
}
