package cz.cuni.amis.pogamut.ut2004.examples.attackbot;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.sposh.ut2004.StateSposhLogicController;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.IOException;
import java.util.logging.Level;

/**
 * Create simple CTF bot that tries to play the game. It is rather stupid, but
 * it should try to capture the enemy flags, return its own dropped flag home,
 * fire at enemy flag holders and if everything fails, pick items from the map.
 *
 * This bot should be run basically only on CTF-1on1-Joust, it is demonstration
 * bot, not real AttackBot.
 *
 * @see IUT2004BotController Controller for various methods called during
 * construction of bot.
 * @author Honza
 */
public class AttackBotLogic extends StateSposhLogicController<UT2004Bot, AttackBotContext> {

    private String SPOSH_PLAN_RESOURCE = "sposh/plan/attackbot.lap";

    @Override
    protected String getPlan() throws IOException {
        return getPlanFromResource(SPOSH_PLAN_RESOURCE);                
    }

    /**
     * Create context that can be accessed in every state primitive.
     *
     * @return new context of this bot.
     */
    @Override
    protected AttackBotContext createContext() {
        return new AttackBotContext(bot);
    }

    static int botCount = 0;
    
    /**
     * Initialize command of the bot, called during initial handshake, init can
     * set things like name of bot, its skin, skill, team ect.
     *
     * @see Initialize
     * @return
     */
    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("AttackBot").setTeam((botCount++ % 2 == 0) ? AgentInfo.TEAM_BLUE : AgentInfo.TEAM_RED);
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        log.setLevel(Level.WARNING);
        bot.getLogger().getCategory(SPOSH_LOG_CATEGORY).setLevel(Level.WARNING);
        
        
    }

    @Override
    public void botKilled(BotKilled event) {
    }

    /**
     * Create an {@link ExternalBot} with custom made logic and try to connect
     * to Unreal Server at localhost:3000
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(AttackBotLogic.class, "AttackBot").setMain(true).setLogLevel(Level.WARNING).startAgents(4);
    }
}
