package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.Param;
import cz.cuni.amis.pogamut.sposh.executor.ParamsAction;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;

/**
 * Go to base of specified team.
 *
 * @author knight
 */
@PrimitiveInfo(name = "GoToFlagBase", description = "Go to the flag base specified team. The $team can be either \"our\" or \"enemy\".")
public class GoToBase extends ParamsAction<AttackBotContext> {

    private NavPoint baseNavPoint = null;

    public GoToBase(AttackBotContext ctx) {
        super(ctx);
    }

    public void init(@Param("$team") Team team) {
        if (team == Team.ENEMY)
            baseNavPoint = ctx.getCtf().getEnemyBase();
        else
            baseNavPoint = ctx.getCtf().getOurBase();
         
        ctx.getNavigation().navigate(baseNavPoint);
    }

    public ActionResult run() {
        if (ctx.getInfo().atLocation(baseNavPoint)) {
            return ActionResult.RUNNING_ONCE;
        } else if (!ctx.getNavigation().isNavigating()) {
            ctx.getNavigation().navigate(baseNavPoint);
        }
        
        return ActionResult.RUNNING;        
    }

    public void done() {
        baseNavPoint = null;
    }
}
