package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.executor.Param;
import cz.cuni.amis.pogamut.sposh.executor.ParamsSense;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;

/**
 * Sense that detects the state of the flag.
 *
 * @author knight
 */
@PrimitiveInfo(name = "FlagState", description = "Is flag of team $team (values for $team are \"our\" and \"enemy\".) in a state $state (values for $state are \"held\", \"dropped\" and \"home\")?")
public class FlagState extends ParamsSense<AttackBotContext, Boolean> {

    public FlagState(AttackBotContext ctx) {
        super(ctx, Boolean.class);
    }

    public Boolean query(@Param("$team") Team team, @Param("$state") String flagState) {
        FlagInfo flag;        
        
        if (team == Team.OUR) {
            flag = ctx.getCtf().getOurFlag();                        
            return flag.getState().toLowerCase().contentEquals(flagState.toLowerCase());            
        } else {
            flag = ctx.getCtf().getEnemyFlag();            
            return flag.getState().toLowerCase().contentEquals(flagState.toLowerCase());                    
        }
        
    }
}
