package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.Param;
import cz.cuni.amis.pogamut.sposh.executor.ParamsSense;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;

/**
 * This sense will determine, if the bot can see a player.
 *
 * @author knight
 */
@PrimitiveInfo(name = "SeePlayer", description = "Do I see a player ($team can be \"our\" or \"enemy\")? If yes we will set this player to variable for shoot actions to work properly.")
public class SeePlayer extends ParamsSense<AttackBotContext, Boolean> {

    public SeePlayer(AttackBotContext ctx) {
        super(ctx, Boolean.class);
    }

    public Boolean query(@Param("$team") Team team) {
        if (team == Team.OUR) {
            if (ctx.getPlayers().canSeeFriends()) {
                ctx.targetPlayer = ctx.getPlayers().getNearestVisibleFriend();                
                return true;
            }                        
        } else { 
            if (ctx.getPlayers().canSeeEnemies()) {
                ctx.targetPlayer = ctx.getPlayers().getNearestVisibleEnemy();                                
                return true;
            }                          
        }
        return false;
    }    
}
