package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateAction;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavPoints;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;
import cz.cuni.amis.utils.collections.MyCollections;

/**
 * Action for walking randomly around the map.
 *
 * @author knight
 */
@PrimitiveInfo(name = "RunRandomly", description = "Go around the map randomly.")
public class RunRandomly extends StateAction<AttackBotContext> {

    public RunRandomly(AttackBotContext ctx) {
        super(ctx);
    }

    @Override
    public void init(VariableContext params) {        
        NavPoint nav = MyCollections.getRandom(ctx.getWorld().getAll(NavPoint.class).values());
        ctx.getNavigation().navigate(nav);
    }

    @Override
    public ActionResult run(VariableContext params) {
        if (ctx.getNavigation().isNavigating()) {
            return ActionResult.RUNNING;
        }
        
        return ActionResult.RUNNING_ONCE;
    }

    @Override
    public void done(VariableContext params) {

    }
}
