package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.sposh.executor.*;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;
import java.text.MessageFormat;

/**
 * This action will move the agent to the team flag in the CTF game.
 *
 * @author knight
 */
@PrimitiveInfo(name = "GoToFlag", description = "Move to the last known location of the flag of $team (either \"our\" or \"enemy\"). Flag should be visible for this to work!")
public class GoToFlag extends ParamsAction<AttackBotContext> {

    Location flagLocation;
            
    public GoToFlag(AttackBotContext ctx) {
        super(ctx);
    }

    public void init(@Param("$team") Team team) {
        FlagInfo flag;

        if (team == Team.OUR) {
            flag = ctx.getCtf().getOurFlag();
        } else {
            flag = ctx.getCtf().getEnemyFlag();
        } 

        flagLocation = flag.getLocation();
        if (flagLocation != null) {
            ctx.getNavigation().navigate(flagLocation);
            ctx.getNavigation().setFocus(flagLocation);
        }
    }
    
    public ActionResult run() {
        if (flagLocation != null) {
            if (!ctx.getNavigation().isNavigating() && !ctx.getInfo().atLocation(flagLocation)) {
                ctx.getNavigation().navigate(flagLocation);                
                return ActionResult.RUNNING;
            } else {
                return ActionResult.RUNNING_ONCE;
            }
        } else
            return ActionResult.RUNNING_ONCE;               
    }

    public void done() {
        flagLocation = null;        
        ctx.getNavigation().setFocus(null);
    }
}
