package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.Param;
import cz.cuni.amis.pogamut.sposh.executor.ParamsAction;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;

/**
 * Approaches sensed player (player detected by sense triggering this action).
 * Needs to be called repeatedly!
 *
 * @author knight
 */
@PrimitiveInfo(name="FollowSensedPlayer", description="Approaches player returned by sense triggering this action.")
public class FollowPlayer extends ParamsAction<AttackBotContext> {

    public FollowPlayer(AttackBotContext ctx) {
        super(ctx);
    }

    public void init() {

    }

    public ActionResult run() {
        if (ctx.targetPlayer != null) {
            ctx.getNavigation().navigate(ctx.targetPlayer);
            ctx.getNavigation().setFocus(ctx.targetPlayer);
            return ActionResult.RUNNING;
        } else {
            ctx.getLog().warning("Warning! FollowPlayer : run() - ctx.targetPlayer == null !");
            return ActionResult.RUNNING_ONCE;
        }
    }

    public void done() {
        ctx.getNavigation().setFocus(null);
    }
}
