package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.executor.Param;
import cz.cuni.amis.pogamut.sposh.executor.ParamsSense;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;

/**
 * Is flag of specified team on the ground? The team is specified by the
 * <dfn>$teamname</dfn> are "our" and "enemy".
 *
 * @author knight
 */
@PrimitiveInfo(name = "FlagVisible", description = "Is flag of target $team visible? Possible values for $team are \"our\" and \"enemy\".")
public class FlagIsVisible extends ParamsSense<AttackBotContext, Boolean> {

    public FlagIsVisible(AttackBotContext ctx) {
        super(ctx, Boolean.class);
    }

    public Boolean query(@Param("$team") Team target) {
        if (target == Team.OUR) {
            return ctx.getCtf().getOurFlag().isVisible();
        } else {
            return ctx.getCtf().getEnemyFlag().isVisible();
        }
    }
}
