package cz.cuni.attackbot;

import cz.cuni.amis.pogamut.sposh.executor.ActionResult;
import cz.cuni.amis.pogamut.sposh.executor.Param;
import cz.cuni.amis.pogamut.sposh.executor.ParamsAction;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.examples.attackbot.AttackBotContext;

/**
 * Approaches and shoots sensed player (player detected by sense triggering this action).
 * Needs to be called repeatedly!
 *
 * @author knight
 */
@PrimitiveInfo(name="ApproachAndShootSensedPlayer", description="Approaches and shoots player returned by sense triggering this action.")
public class ApproachAndShootSensedPlayer extends ParamsAction<AttackBotContext> {

    public ApproachAndShootSensedPlayer(AttackBotContext ctx) {
        super(ctx);
    }

    public void init() {

    }

    public ActionResult run() {
        if (ctx.targetPlayer != null) {
            ctx.getShoot().shoot(ctx.getWeaponPrefs(), ctx.targetPlayer);
            ctx.getNavigation().navigate(ctx.targetPlayer);
            ctx.getNavigation().setFocus(ctx.targetPlayer);
            return ActionResult.RUNNING;
        } else {
            ctx.getLog().warning("Warning!  ApproachAndShootSensedPlayer : run() - ctx.targetEnemyPlayer == null !");
            return ActionResult.RUNNING_ONCE;
        }
    }

    public void done() {
        ctx.getShoot().stopShooting();
        ctx.getNavigation().setFocus(null);
    }
}
