/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.visibility;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.VisibilityCreator;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.model.VisibilityMatrix;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.impl.UT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapperConf;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004ServerRunner;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.IniFile;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class VisibilityBatchCreator {
    private static final String ARG_UT2004_HOME_DIR = "ut2004";
    private static final String ARG_ALL_DM_MAPS = "all-dm-maps";
    private static final String ARG_ALL_CTF_MAPS = "all-ctf-maps";
    private static final String ARG_ALL_DOM_MAPS = "all-dom-maps";
    private static final String ARG_MAPS_LIST = "maps";
    private static final String ARG_UCC_INSTANCES = "ucc-instances";
    private static final String ARG_OUTPUT_DIR = "output-dir";
    private static final String ARG_CONTINUE = "continue";
    private static JSAP jsap;
    private static boolean headerOutput;
    private static File ut2004Dir;
    private static File uccFile;
    private static File gb2004File;
    private static File mapsDir;
    private static File iniFile;
    private static File outputDir;
    private static LogCategory log;
    private static int instances;
    private static List<CountDownLatch> latches;
    private static List<String> reports;
    private static List<String> maps;
    private static List<UCCWrapperConf> uccWrapperConfs;
    private static boolean justContinue;

    public static boolean isLinux() {
        return System.getProperty("os.name").contains("Linux");
    }

    private static void init(JSAPResult config) {
        log = new LogCategory("Batch");
        log.addConsoleHandler();
        log.setLevel(Level.ALL);
        VisibilityBatchCreator.header();
        if (config.getString(ARG_UT2004_HOME_DIR) == null) {
            VisibilityBatchCreator.fail("Missing argument --ut2004");
        }
        if (!(ut2004Dir = new File(config.getString(ARG_UT2004_HOME_DIR))).exists() || !ut2004Dir.isDirectory()) {
            VisibilityBatchCreator.fail("Directory '" + ut2004Dir.getAbsolutePath() + "' does not exist or is not directory.");
        }
        if (!((uccFile = new File(ut2004Dir, "System/UCC.exe")).exists() && uccFile.isFile() || (uccFile = new File(ut2004Dir, "System/ucc.exe")).exists() && uccFile.isFile())) {
            if (!(!VisibilityBatchCreator.isLinux() || (uccFile = new File(ut2004Dir, "System/ucc-bin")).exists() && uccFile.isFile())) {
                uccFile = new File(ut2004Dir, "System/UCC-BIN");
            }
            if (!uccFile.exists() || !uccFile.isFile()) {
                uccFile = null;
            }
        }
        if (uccFile == null) {
            VisibilityBatchCreator.fail("Directory '" + ut2004Dir.getAbsolutePath() + "' does not contain UT2004.");
        }
        if (!(gb2004File = new File(ut2004Dir, "System/GameBots2004.u")).exists() || !gb2004File.isFile()) {
            VisibilityBatchCreator.fail("Directory '" + ut2004Dir.getAbsolutePath() + "' does not have GameBots2004 installed, file '" + gb2004File + "' not found.");
        }
        if (!(mapsDir = new File(ut2004Dir, "Maps")).exists() || !mapsDir.isDirectory()) {
            VisibilityBatchCreator.fail("Directory '" + ut2004Dir.getAbsolutePath() + "' does not have Maps subdirectory.");
        }
        if ((instances = config.getInt(ARG_UCC_INSTANCES)) <= 0 || instances >= 20) {
            VisibilityBatchCreator.fail("Wrong number of instances.");
        }
        if ((maps = VisibilityBatchCreator.gatherMaps(config)).size() == 0) {
            VisibilityBatchCreator.fail("No maps to analyze specified, misspecification / typos / wrong UT2004 dir?");
        }
        latches = new ArrayList<CountDownLatch>(maps.size());
        reports = new ArrayList<String>(maps.size());
        uccWrapperConfs = new ArrayList<UCCWrapperConf>(maps.size());
        for (String mapName : maps) {
            latches.add(new CountDownLatch(1));
            reports.add("NO REPORT");
            UCCWrapperConf uccWrapperConf = new UCCWrapperConf();
            uccWrapperConf.setUnrealHome(ut2004Dir.getAbsolutePath());
            uccWrapperConf.setStartOnUnusedPort(true);
            uccWrapperConf.setMapName(mapName);
            if (VisibilityBatchCreator.isCtfMap(mapName)) {
                uccWrapperConf.setGameType("BotCTFGame");
            } else {
                uccWrapperConf.setGameType("BotDeathMatch");
            }
            uccWrapperConfs.add(uccWrapperConf);
        }
        VisibilityBatchCreator.adjustIniFile();
        outputDir = config.getString(ARG_OUTPUT_DIR) == null ? new File(".") : new File(config.getString(ARG_OUTPUT_DIR));
        if (outputDir.exists()) {
            if (!outputDir.isDirectory()) {
                VisibilityBatchCreator.fail("Specified output directory '" + outputDir.getAbsolutePath() + "' is not a directory.");
            }
        } else {
            outputDir.mkdirs();
            if (!outputDir.exists() || !outputDir.isDirectory()) {
                VisibilityBatchCreator.fail("Could not create sepcified output directory '" + outputDir.getAbsolutePath() + "'.");
            }
        }
        log.info("Output dir: " + outputDir.getAbsolutePath());
        justContinue = config.getBoolean(ARG_CONTINUE);
    }

    private static boolean isCtfMap(String mapName) {
        return mapName.toLowerCase().startsWith("ctf-");
    }

    private static boolean isDmMap(String mapName) {
        return mapName.toLowerCase().startsWith("dm-");
    }

    private static boolean isDomMap(String mapName) {
        return mapName.toLowerCase().startsWith("dom-");
    }

    private static List<String> gatherMaps(JSAPResult config) {
        log.info("Reading maps...");
        boolean allDmMaps = config.getBoolean(ARG_ALL_DM_MAPS);
        boolean allCtfMaps = config.getBoolean(ARG_ALL_CTF_MAPS);
        boolean allDomMaps = config.getBoolean(ARG_ALL_DOM_MAPS);
        HashSet specMaps = new HashSet();
        MyCollections.toCollection((Object[])config.getStringArray(ARG_MAPS_LIST), specMaps);
        ArrayList<String> result = new ArrayList<String>();
        for (File map : mapsDir.listFiles()) {
            boolean include;
            String mapName = map.getName().substring(0, map.getName().lastIndexOf("."));
            boolean isCtf = VisibilityBatchCreator.isCtfMap(mapName);
            boolean isDm = VisibilityBatchCreator.isDmMap(mapName);
            boolean isDom = VisibilityBatchCreator.isDomMap(mapName);
            boolean isSpec = specMaps.contains(mapName);
            boolean bl = include = isCtf && allCtfMaps || isDm && allDmMaps || isDom && allDomMaps || isSpec;
            if (!include) continue;
            log.info("Included: " + mapName);
            result.add(mapName);
            specMaps.remove(map);
        }
        if (specMaps.size() > 0) {
            for (String mapName : specMaps) {
                log.warning("Map not found: " + mapName);
            }
        }
        return result;
    }

    private static void adjustIniFile() {
        iniFile = new File(ut2004Dir, "System/GameBots2004.ini");
        if (!iniFile.exists() || !iniFile.isFile()) {
            VisibilityBatchCreator.fail("Could not locate GB2004 ini file at: " + iniFile.getAbsolutePath());
        }
        log.info("Adjusting GameBots2004.ini, setting long times for CTF and DM games.");
        IniFile ini = new IniFile(iniFile);
        ini.getSection("GameBots2004.BotCTFGame").set("TimeLimit", "999999");
        ini.getSection("GameBots2004.BotDeathMatch").set("TimeLimit", "999999");
        ini.output(iniFile);
    }

    private static void perform(JSAPResult config) {
        VisibilityBatchCreator.header();
        VisibilityBatchCreator.init(config);
        VisibilityBatchCreator.process(maps);
        VisibilityBatchCreator.report();
        log.info("");
        log.info("DONE");
    }

    private static void report() {
        log.info("");
        log.info("======");
        log.info("REPORT");
        log.info("======");
        int job = -1;
        for (String report : reports) {
            log.info("");
            log.info("JOB " + ++job + " SUMMARY");
            log.info("----------------");
            log.info(report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void process(List<String> maps) {
        log.info("Going to process " + maps.size() + " maps.");
        log.info("Using #instances: " + instances);
        log.info("Firing up ThreadPoolExecutor...");
        ThreadPoolExecutor executor = new ThreadPoolExecutor(instances, instances, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(uccWrapperConfs.size()));
        try {
            log.info("Submitting jobs...");
            int jobIndex = -1;
            for (UCCWrapperConf uccConf : uccWrapperConfs) {
                executor.execute(new VisibilityJob(uccConf, ++jobIndex));
            }
            log.info("All jobs submitted, waiting for their completion...");
            for (CountDownLatch latch : latches) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted while waiting jobs completion!", e);
                }
            }
            log.info("All jobs finished.");
        }
        finally {
            try {
                log.info("Shutting down ThreadPoolExecutor...");
            }
            finally {
                executor.shutdownNow();
            }
        }
    }

    private static void fail(String errorMessage) {
        VisibilityBatchCreator.fail(errorMessage, null);
    }

    private static void fail(String errorMessage, Throwable e) {
        VisibilityBatchCreator.header();
        System.out.println("ERROR: " + errorMessage);
        System.out.println();
        if (e != null) {
            e.printStackTrace();
            System.out.println("");
        }
        System.out.println("Usage: java -jar ut2004-19-visibility-batch-creator...jar ");
        System.out.println("                " + jsap.getUsage());
        System.out.println();
        System.out.println(jsap.getHelp());
        System.out.println();
        System.exit(1);
    }

    private static void header() {
        if (headerOutput) {
            return;
        }
        System.out.println();
        System.out.println("================================================");
        System.out.println("Pogamut UT2004 Visibility Matrices Batch Creator");
        System.out.println("================================================");
        System.out.println();
        headerOutput = true;
    }

    public static void main(String[] args) throws PogamutException, JSAPException {
        jsap = new JSAP();
        FlaggedOption opt1 = new FlaggedOption(ARG_UT2004_HOME_DIR).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('u').setLongFlag("ut2004-home-dir");
        opt1.setHelp("UT2004 home directory containing GameBots2004 (System/GameBots2004.u) present.");
        jsap.registerParameter((Parameter)opt1);
        Switch sw1 = new Switch(ARG_ALL_DM_MAPS).setShortFlag('d').setLongFlag(ARG_ALL_DM_MAPS);
        sw1.setHelp("Create visibility matrices for all death-match maps.");
        jsap.registerParameter((Parameter)sw1);
        Switch sw2 = new Switch(ARG_ALL_CTF_MAPS).setShortFlag('c').setLongFlag(ARG_ALL_CTF_MAPS);
        sw2.setHelp("Create visibility matrices for all capture-the-flag maps.");
        jsap.registerParameter((Parameter)sw2);
        Switch sw21 = new Switch(ARG_ALL_DOM_MAPS).setShortFlag('p').setLongFlag(ARG_ALL_DOM_MAPS);
        sw1.setHelp("Create visibility matrices for all domination maps.");
        jsap.registerParameter((Parameter)sw21);
        FlaggedOption opt2 = new FlaggedOption(ARG_MAPS_LIST).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setList(true).setShortFlag('m').setLongFlag(ARG_MAPS_LIST);
        opt2.setHelp("One or more names of maps (e.g. DM-1on1-Albatross), which you want visibility matrices to be created for.");
        jsap.registerParameter((Parameter)opt2);
        Switch sw3 = new Switch(ARG_CONTINUE).setShortFlag('x').setLongFlag(ARG_CONTINUE);
        sw3.setHelp("Do not create visibility matrices for already created ones (output directory is searched first for the presence of visibility matrices).");
        jsap.registerParameter((Parameter)sw3);
        FlaggedOption opt3 = new FlaggedOption(ARG_UCC_INSTANCES).setStringParser((StringParser)JSAP.INTEGER_PARSER).setDefault("1").setRequired(false).setShortFlag('i').setLongFlag(ARG_UCC_INSTANCES);
        opt3.setHelp("How many UCC instances to use in parallel (min: 1, max: 20, recommended: 5). More instances requires more JVM memory, use of -Xmx1024m Java switch is advised.");
        jsap.registerParameter((Parameter)opt3);
        FlaggedOption opt4 = new FlaggedOption(ARG_OUTPUT_DIR).setStringParser((StringParser)JSAP.STRING_PARSER).setDefault(".").setRequired(false).setShortFlag('o').setLongFlag(ARG_OUTPUT_DIR);
        opt4.setHelp("Where to output visibility matrices.");
        jsap.registerParameter((Parameter)opt4);
        JSAPResult config = jsap.parse(args);
        int mapsCount = config.getStringArray(ARG_MAPS_LIST) == null ? 0 : config.getStringArray(ARG_MAPS_LIST).length;
        boolean dm = config.getBoolean(ARG_ALL_DM_MAPS);
        boolean ctf = config.getBoolean(ARG_ALL_CTF_MAPS);
        boolean success = config.success();
        try {
            VisibilityBatchCreator.perform(config);
        }
        catch (Exception e) {
            VisibilityBatchCreator.fail("Unforseen execution error.", e);
        }
    }

    static {
        headerOutput = false;
    }

    private static class VisibilityJob
    implements Runnable {
        private UCCWrapperConf conf;
        private int jobIndex;

        public VisibilityJob(UCCWrapperConf uccConf, int jobIndex) {
            this.conf = uccConf;
            this.jobIndex = jobIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.info("STARTED");
                if (justContinue) {
                    File file = VisibilityMatrix.getFile_All((File)outputDir, (String)this.conf.getMapName());
                    log.info("Checking existence of file: " + file.getAbsolutePath());
                    if (file.exists() && file.isFile()) {
                        log.info("File exists, '-x' specified (just continue), skipping creation of visibility matrix for map " + this.conf.getMapName() + ".");
                        reports.set(this.jobIndex, "Visibility matrix already exists for " + this.conf.getMapName() + ".");
                        return;
                    }
                }
                this.info("Firing up UT2004 dedicated server...");
                UCCWrapper ucc = new UCCWrapper(this.conf);
                try {
                    this.info("Connecting UT2004Server instance fo dedicated server...");
                    UT2004ServerModule serverModule = new UT2004ServerModule();
                    UT2004ServerFactory serverFactory = new UT2004ServerFactory(serverModule);
                    UT2004ServerRunner serverRunner = new UT2004ServerRunner((IAgentFactory)serverFactory);
                    List servers = serverRunner.startAgents(new UT2004AgentParameters[]{new UT2004AgentParameters().setWorldAddress((IWorldConnectionAddress)ucc.getServerAddress())});
                    UT2004Server server = null;
                    try {
                        server = (UT2004Server)servers.get(0);
                        this.info("Creating VisibilityCreator...");
                        VisibilityCreator creator = new VisibilityCreator(server);
                        this.info("Creating visibility matrix...");
                        creator.createAndSave(outputDir);
                    }
                    finally {
                        if (server != null) {
                            try {
                                this.info("Stopping UT2004Server instance...");
                            }
                            finally {
                                server.stop();
                            }
                        }
                    }
                }
                finally {
                    try {
                        this.info("Stopping UT2004 dedicated server...");
                    }
                    finally {
                        ucc.stop();
                    }
                }
                reports.set(this.jobIndex, "Visibility matrix created for " + this.conf.getMapName() + ".");
            }
            catch (Exception e) {
                reports.set(this.jobIndex, ExceptionToString.process((String)"Unforseen job exception.", (Throwable)e));
            }
            finally {
                try {
                    ((CountDownLatch)latches.get(this.jobIndex)).countDown();
                }
                finally {
                    this.info("FINISHED");
                }
            }
        }

        private void info(String msg) {
            log.info("[JOB-" + this.jobIndex + "] " + msg);
        }

        private void severe(String msg) {
            log.severe("[JOB-" + this.jobIndex + "] " + msg);
        }
    }
}

