/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.communicatingbot;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.comm.PogamutJVMComm;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.examples.communicatingbot.WeCanSeeEachOther;
import cz.cuni.amis.pogamut.ut2004.examples.communicatingbot.YouHaveBeenSpot;
import cz.cuni.amis.pogamut.ut2004.examples.communicatingbot.YouHaveBeenSpotToo;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.Cooldown;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;

@AgentScoped
public class CommunicatingBot
extends UT2004BotModuleController {
    protected static final int COMM_CHANNEL = 1;
    protected TabooSet<NavPoint> tabooNavPoints;
    protected NavPoint targetNavPoint;
    protected UT2004PathAutoFixer autoFixer;
    protected Heatup iAmSpot = new Heatup(4000L);
    protected UnrealId iAmSpotBy;
    protected Heatup iAmFixed = new Heatup(5000L);
    protected Cooldown doNotFix = new Cooldown(10000L);
    protected UnrealId iCanSeeId;
    protected Heatup iCanSee = new Heatup(6000L);

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.tabooNavPoints = new TabooSet(this.bot);
        this.autoFixer = new UT2004PathAutoFixer(this.bot, this.pathExecutor, this.fwMap, this.aStar, this.navBuilder);
        this.pathExecutor.getState().addStrongListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                CommunicatingBot.this.pathExecutorStateChange(changedValue.getState());
            }
        });
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        PogamutJVMComm.getInstance().getLog().setLevel(Level.FINE);
        PogamutJVMComm.getInstance().registerAgent((IObservingAgent)this.bot, 1);
    }

    public void botShutdown() {
        PogamutJVMComm.getInstance().unregisterAgent((IObservingAgent)this.bot);
    }

    @EventListener(eventClass=YouHaveBeenSpot.class)
    public void iCanSeePlayer(YouHaveBeenSpot event) {
        if (event.getPlayerId().equals((Object)this.info.getId())) {
            return;
        }
        if (this.iAmSpot.isHot()) {
            return;
        }
        if (event.getSeePlayerId().equals((Object)this.info.getId())) {
            this.iAmSpotBy = event.getPlayerId();
            this.iAmSpot.heat();
            if (this.players.getVisiblePlayer(this.iAmSpotBy) != null) {
                this.iAmFixed.heat();
                this.doNotFix.use();
                this.body.getCommunication().sendGlobalTextMessage("Hi! I can see you too!");
                PogamutJVMComm.getInstance().sendToOthers((IWorldChangeEvent)new YouHaveBeenSpotToo(this.info.getId(), this.iAmSpotBy), 1, (IObservingAgent)this.bot);
                this.move.turnTo(this.players.getPlayer(this.iAmSpotBy));
            }
        }
    }

    @EventListener(eventClass=YouHaveBeenSpotToo.class)
    public void iCanSeePlayerToo(YouHaveBeenSpotToo event) {
        if (this.iCanSee.isHot() && event.getSeePlayerId().equals((Object)this.info.getId())) {
            this.iAmFixed.heat();
            this.doNotFix.use();
            this.body.getCommunication().sendGlobalTextMessage("That's so cool!");
            PogamutJVMComm.getInstance().sendToOthers((IWorldChangeEvent)new WeCanSeeEachOther(this.info.getId(), event.getPlayerId()), 1, (IObservingAgent)this.bot);
        }
    }

    @EventListener(eventClass=WeCanSeeEachOther.class)
    public void weCanSeeEachOther(WeCanSeeEachOther event) {
        if (event.getSeePlayerId().equals((Object)this.info.getId())) {
            this.body.getCommunication().sendGlobalTextMessage("Hurray!");
        }
    }

    @ObjectClassEventListener(eventClass=WorldObjectUpdatedEvent.class, objectClass=Player.class)
    public void playerUpdated(WorldObjectUpdatedEvent<Player> event) {
        if (this.info.getId() == null) {
            return;
        }
        if (!((Player)event.getObject()).isVisible()) {
            return;
        }
        if (this.doNotFix.isHot()) {
            return;
        }
        if (this.iAmSpot.isHot() && this.iAmSpotBy != null && this.iAmSpotBy.equals((Object)((Player)event.getObject()).getId())) {
            this.iCanSeeId = ((Player)event.getObject()).getId();
            this.iAmFixed.heat();
            this.doNotFix.use();
            this.body.getCommunication().sendGlobalTextMessage("Hi! I can see you too!");
            PogamutJVMComm.getInstance().sendToOthers((IWorldChangeEvent)new YouHaveBeenSpotToo(this.info.getId(), this.iAmSpotBy), 1, (IObservingAgent)this.bot);
            return;
        }
        if (this.iCanSee.isCool()) {
            this.iCanSeeId = ((Player)event.getObject()).getId();
            this.iCanSee.heat();
            this.body.getCommunication().sendGlobalTextMessage("Hi, " + ((Player)event.getObject()).getName() + "!");
            PogamutJVMComm.getInstance().sendToOthers((IWorldChangeEvent)new YouHaveBeenSpot(this.info.getId(), this.iCanSeeId), 1, (IObservingAgent)this.bot);
        }
    }

    @ObjectClassEventListener(eventClass=WorldObjectDisappearedEvent.class, objectClass=Player.class)
    public void playerDisappear(WorldObjectDisappearedEvent<Player> event) {
        if (this.info.getId() == null) {
            return;
        }
        if (this.iCanSeeId != null && this.iCanSeeId.equals((Object)((Player)event.getObject()).getId())) {
            this.iCanSeeId = null;
            this.iCanSee.clear();
            this.iAmSpot.clear();
            this.iAmFixed.clear();
            this.body.getCommunication().sendGlobalTextMessage("I've lost you!");
        }
    }

    public void logic() {
        if (this.iAmFixed.isHot()) {
            if (this.navigation.isNavigating()) {
                this.navigation.stopNavigation();
            }
            return;
        }
        if (this.iAmSpot.isHot()) {
            if (this.navigation.isNavigating()) {
                this.navigation.stopNavigation();
            }
            this.move.turnHorizontal(30);
            return;
        }
        if (this.iCanSee.isHot()) {
            if (this.navigation.isNavigating()) {
                this.navigation.stopNavigation();
            }
            this.move.turnTo(this.players.getPlayer(this.iCanSeeId));
            return;
        }
        this.handleNavPointNavigation();
    }

    private void handleNavPointNavigation() {
        if (this.navigation.isNavigating()) {
            return;
        }
        this.targetNavPoint = this.getRandomNavPoint();
        if (this.targetNavPoint == null) {
            this.log.severe("COULD NOT CHOOSE ANY NAVIGATION POINT TO RUN TO!!!");
            if (this.world.getAll(NavPoint.class).size() == 0) {
                this.log.severe("world.getAll(NavPoint.class).size() == 0, there are no navigation ponits to choose from! Is exporting of nav points enabled in GameBots2004.ini inside UT2004?");
            }
            return;
        }
        this.navigation.navigate((ILocated)this.targetNavPoint);
    }

    public void botKilled(BotKilled event) {
        this.navigation.stopNavigation();
    }

    protected void pathExecutorStateChange(PathExecutorState state) {
        switch (state) {
            case PATH_COMPUTATION_FAILED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 180.0);
                break;
            }
            case TARGET_REACHED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 180.0);
                break;
            }
            case STUCK: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 60.0);
                break;
            }
            case STOPPED: {
                this.targetNavPoint = null;
            }
        }
    }

    protected NavPoint getRandomNavPoint() {
        NavPoint chosen = (NavPoint)MyCollections.getRandomFiltered(this.getWorldView().getAll(NavPoint.class).values(), this.tabooNavPoints);
        if (chosen != null) {
            return chosen;
        }
        this.log.warning("All navpoints are tabooized at this moment, choosing navpoint randomly!");
        return (NavPoint)MyCollections.getRandom(this.getWorldView().getAll(NavPoint.class).values());
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(CommunicatingBot.class, "CommunicatingBot").setMain(true).setLogLevel(Level.WARNING).startAgents(2);
    }
}

