/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.botobserver;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorState;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;

@AgentScoped
public class BotThatWillBeObserved
extends UT2004BotModuleController {
    protected TabooSet<NavPoint> tabooNavPoints;
    protected NavPoint targetNavPoint;
    protected UT2004PathAutoFixer autoFixer;
    protected int talking;

    public Initialize getInitializeCommand() {
        return new Initialize();
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.tabooNavPoints = new TabooSet(this.bot);
        this.autoFixer = new UT2004PathAutoFixer(this.bot, this.pathExecutor, this.fwMap, this.aStar, this.navBuilder);
        this.pathExecutor.getState().addStrongListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                BotThatWillBeObserved.this.pathExecutorStateChange(changedValue.getState());
            }
        });
    }

    public void beforeFirstLogic() {
        this.log.info("SPAWNED, name: " + this.info.getName());
        this.log.setLevel(Level.OFF);
    }

    public void logic() {
        this.log.info("--- Logic iteration ---");
        if (this.players.canSeePlayers() || this.navigation.getCurrentTargetPlayer() != null) {
            this.handlePlayerNavigation();
        } else {
            this.handleNavPointNavigation();
        }
    }

    private void handlePlayerNavigation() {
        if (this.navigation.isNavigating() && this.navigation.getCurrentTargetPlayer() != null) {
            this.logNavigation();
            return;
        }
        Player player = this.players.getNearestVisiblePlayer();
        if (player == null) {
            this.handleNavPointNavigation();
            return;
        }
        if (this.info.getLocation().getDistance(player.getLocation()) < 100.0) {
            this.talkTo(player);
            return;
        }
        this.navigation.navigate(player);
        this.logNavigation();
    }

    private void handleNavPointNavigation() {
        if (this.navigation.isNavigating()) {
            this.logNavigation();
            return;
        }
        this.targetNavPoint = this.getRandomNavPoint();
        if (this.targetNavPoint == null) {
            this.log.severe("COULD NOT CHOOSE ANY NAVIGATION POINT TO RUN TO!!!");
            if (this.world.getAll(NavPoint.class).size() == 0) {
                this.log.severe("world.getAll(NavPoint.class).size() == 0, there are no navigation ponits to choose from! Is exporting of nav points enabled in GameBots2004.ini inside UT2004?");
            }
            return;
        }
        this.talking = 0;
        this.navigation.navigate((ILocated)this.targetNavPoint);
        this.logNavigation();
    }

    private void logNavigation() {
        if (this.navigation.getCurrentTargetPlayer() != null) {
            this.log.info("Pursuing player:    " + this.navigation.getCurrentTargetPlayer());
        } else {
            this.log.info("Navigating to:      " + this.navigation.getCurrentTarget());
        }
        int pathLeftSize = this.pathExecutor.getPath() == null ? 0 : this.pathExecutor.getPath().size() - this.pathExecutor.getPathElementIndex();
        this.log.info("Path points left:   " + pathLeftSize);
        this.log.info("Remaining distance: " + this.pathExecutor.getRemainingDistance());
        this.log.info("Visible navpoints:  " + this.world.getAllVisible(NavPoint.class).size() + " / " + this.world.getAll(NavPoint.class).size());
        this.log.info("Visible items:      " + this.items.getVisibleItems().values() + " / " + this.world.getAll(Item.class).size());
        this.log.info("Visible players:    " + this.players.getVisiblePlayers().size());
    }

    private void talkTo(Player player) {
        this.move.turnTo(player);
        switch (this.talking) {
            case 0: {
                this.body.getCommunication().sendGlobalTextMessage("Hi!");
                break;
            }
            case 4: {
                this.body.getCommunication().sendGlobalTextMessage("Howdy!");
                break;
            }
            case 10: {
                this.body.getCommunication().sendGlobalTextMessage("I'm NavigationBot made to fool around and test Pogamut's navigation stuff!");
                break;
            }
            case 18: {
                this.body.getCommunication().sendGlobalTextMessage("My work is extremely important.");
                break;
            }
            case 24: {
                this.body.getCommunication().sendGlobalTextMessage("So do not interrupt me, ok?");
                break;
            }
            case 26: {
                if (!(this.random.nextDouble() > 0.5)) break;
                this.move.jump();
                break;
            }
            case 40: {
                this.body.getCommunication().sendGlobalTextMessage(this.getRandomLogoutMessage());
            }
        }
        ++this.talking;
        if (this.talking > 40) {
            this.talking = 25;
        }
    }

    private String getRandomLogoutMessage() {
        switch (this.random.nextInt(8)) {
            case 0: {
                return "I would appriciate if you log out or switch to SPECTATE mode.";
            }
            case 1: {
                return "Would you please log out or switch to SPECTATE mode.";
            }
            case 2: {
                return "Just log out, will ya?";
            }
            case 3: {
                return "As I've said, I'M SOMEONE, so log out, ok?";
            }
            case 4: {
                return "I can see you don't get it... LOGOUT! OK!";
            }
            case 5: {
                return "I hate when humans are so clueless... just press ESCAPE key and press Spectate button, that's all I want!";
            }
            case 6: {
                return "I guess you do not know how to switch to spectate mode, right? Just press ESCAPE key and press Spectate button";
            }
        }
        return "AHAHAHAYYYAAAA!";
    }

    public void botKilled(BotKilled event) {
        this.navigation.stopNavigation();
    }

    protected void pathExecutorStateChange(PathExecutorState state) {
        switch (state) {
            case PATH_COMPUTATION_FAILED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 180.0);
                break;
            }
            case TARGET_REACHED: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 180.0);
                break;
            }
            case STUCK: {
                this.tabooNavPoints.add((Object)this.targetNavPoint, 60.0);
                break;
            }
            case STOPPED: {
                this.targetNavPoint = null;
            }
        }
    }

    protected NavPoint getRandomNavPoint() {
        this.log.info("Picking new target navpoint.");
        NavPoint chosen = (NavPoint)MyCollections.getRandomFiltered(this.getWorldView().getAll(NavPoint.class).values(), this.tabooNavPoints);
        if (chosen != null) {
            return chosen;
        }
        this.log.warning("All navpoints are tabooized at this moment, choosing navpoint randomly!");
        return (NavPoint)MyCollections.getRandom(this.getWorldView().getAll(NavPoint.class).values());
    }

    public static void startBot() {
        new UT2004BotRunner(BotThatWillBeObserved.class, "ObservedBot").setMain(false).setLogLevel(Level.OFF).startAgent();
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(BotThatWillBeObserved.class, "ObservedBot").setMain(true).setLogLevel(Level.OFF).startAgent();
    }
}

