/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.emotionalbot;

import cz.cuni.amis.pogamut.ut2004.examples.emotionalbot.EmotionalBot;
import de.affect.emotion.Emotion;
import de.affect.emotion.EmotionType;
import de.affect.manage.AffectManager;
import de.affect.manage.event.AffectUpdateEvent;
import de.affect.manage.event.AffectUpdateListener;
import de.affect.mood.Mood;
import de.affect.xml.AffectInputDocument;
import de.affect.xml.AffectOutputDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ALMA
implements AffectUpdateListener {
    public EmotionalBot myAgent;
    public static AffectManager fAM = null;
    private static String sALMACOMP = "./conf/AffectComputation.aml";
    private static String sALMADEF = "./conf/CharacterDefinition.aml";
    public double currentTime;
    private static final boolean sGUIMode = false;
    public static Logger log = Logger.getLogger("global");

    public ALMA(EmotionalBot agent) {
        this.myAgent = agent;
        try {
            fAM = new AffectManager(ALMA.class.getClassLoader().getResourceAsStream(sALMACOMP), ALMA.class.getClassLoader().getResourceAsStream(sALMADEF), false);
            AffectManager.log.setLevel(Level.OFF);
            fAM.addAffectUpdateListener((AffectUpdateListener)this);
        }
        catch (IOException io) {
            log.info("Error during ALMA initialisation");
            io.printStackTrace();
            System.exit(-1);
        }
        catch (Exception xmle) {
            log.info("Error in ALMA configuration");
            xmle.printStackTrace();
            System.exit(-1);
        }
    }

    public synchronized void update(AffectUpdateEvent event) {
        AffectOutputDocument aod = event.getUpdate();
    }

    public Mood getCurrentMood(String agentName) {
        return fAM.getCharacterByName(agentName).getCurrentMood();
    }

    public List<Emotion> getAllEmotionsForElicitor(String agentName, String elicitor) {
        ArrayList<Emotion> emotionList = new ArrayList<Emotion>();
        Emotion tempEm = null;
        for (int j = 0; j < EmotionType.values().length; ++j) {
            tempEm = fAM.getCharacterByName(agentName).getEmotionHistory().getEmotionByElicitor(EmotionType.values()[j], (Object)elicitor);
            if (tempEm == null) continue;
            emotionList.add(tempEm);
        }
        return emotionList;
    }

    public Emotion getEmotionForElicitor(String agentName, String elicitor, EmotionType type) {
        return fAM.getCharacterByName(agentName).getEmotionHistory().getEmotionByElicitor(type, (Object)elicitor);
    }

    public Emotion getDominantEmotion(String agentName) {
        return fAM.getCharacterByName(agentName).getCurrentEmotions().getDominantEmotion();
    }

    public List<Emotion> getCurrentEmotions(String agentName) {
        if (fAM.getCharacterByName(agentName) != null) {
            return fAM.getCharacterByName(agentName).getCurrentEmotions().getEmotions();
        }
        return new ArrayList<Emotion>();
    }

    public AffectInputDocument.AffectInput createAffectInputBasicEEC(String actor, double desirability, double praiseworthiness, double appealingness, double likelihood, double liking, double realization, String elicitor, String agency) {
        AffectInputDocument.AffectInput aiInput = AffectInputDocument.AffectInput.Factory.newInstance();
        AffectInputDocument.AffectInput.Character perfCharacter = AffectInputDocument.AffectInput.Character.Factory.newInstance();
        perfCharacter.setName(actor);
        AffectInputDocument.AffectInput.BasicEEC eec = AffectInputDocument.AffectInput.BasicEEC.Factory.newInstance();
        eec.setDesirability(desirability);
        eec.setPraiseworthiness(praiseworthiness);
        eec.setAppealingness(appealingness);
        eec.setLikelihood(likelihood);
        eec.setLiking(liking);
        eec.setRealization(realization);
        eec.setAgency(agency.toLowerCase() == "self" ? AffectInputDocument.AffectInput.BasicEEC.Agency.SELF : AffectInputDocument.AffectInput.BasicEEC.Agency.OTHER);
        eec.setElicitor(elicitor);
        aiInput.setCharacter(perfCharacter);
        aiInput.setBasicEEC(eec);
        return aiInput;
    }

    public AffectInputDocument.AffectInput createAffectInput(String actor, AffectInputDocument.AffectInput.BasicEEC eec) {
        AffectInputDocument.AffectInput aiInput = AffectInputDocument.AffectInput.Factory.newInstance();
        AffectInputDocument.AffectInput.Character perfCharacter = AffectInputDocument.AffectInput.Character.Factory.newInstance();
        perfCharacter.setName(actor);
        aiInput.setCharacter(perfCharacter);
        aiInput.setBasicEEC(eec);
        return aiInput;
    }

    public void processAffectInput(AffectInputDocument.AffectInput ai, String event) {
        this.myAgent.getLog().warning("Name: " + ai.getCharacter().getName() + " Event: " + event + " \n" + this.myAgent.currentTime + " Vars: D: " + ai.getBasicEEC().getDesirability() + "; P: " + ai.getBasicEEC().getPraiseworthiness() + "; A: " + ai.getBasicEEC().getAppealingness() + "; Lh: " + ai.getBasicEEC().getLikelihood() + "; Li: " + ai.getBasicEEC().getLiking() + "; R: " + ai.getBasicEEC().getRealization() + "; Ag: " + ai.getBasicEEC().getAgency() + "; El.: " + ai.getBasicEEC().getElicitor());
        fAM.processSignal(ai);
    }
}

