/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.emotionalbot;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Jump;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetWalk;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.examples.emotionalbot.ALMA;
import cz.cuni.amis.pogamut.ut2004.examples.emotionalbot.EEventGenerator;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import de.affect.emotion.Emotion;
import de.affect.emotion.EmotionType;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.logging.Level;

@AgentScoped
public class EmotionalBot
extends UT2004BotModuleController {
    public String myName = "EmotionalBot";
    protected ALMA myALMA = null;
    protected EEventGenerator myEEventGenerator = null;
    private UT2004PathAutoFixer pathAutoFixer;
    private NavPoint targetNavPoint = null;
    public double currentTime;
    public boolean isWalking = false;
    public double lastMessageTime = 0.0;
    public static final double MESSAGE_DELAY = 3.0;
    public IWorldEventListener<BeginMessage> myBegListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage bm) {
            EmotionalBot.this.currentTime = bm.getTime();
        }
    };

    public Initialize getInitializeCommand() {
        Initialize init = new Initialize();
        init.setName(this.myName);
        return init;
    }

    public void prepareBot(UT2004Bot bot) {
        this.pathAutoFixer = new UT2004PathAutoFixer(bot, this.pathExecutor, this.fwMap, this.navBuilder);
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.myALMA = new ALMA(this);
        this.myEEventGenerator = new EEventGenerator(this, this.myALMA);
        this.getLog().setLevel(Level.WARNING);
        this.getWorldView().addEventListener(BeginMessage.class, this.myBegListener);
    }

    public void logic() throws PogamutException {
        if (this.currentTime - this.lastMessageTime > 3.0) {
            this.sendMessageAboutEmotions();
            this.lastMessageTime = this.currentTime;
        }
        if (this.myALMA.getCurrentMood(this.myName).getPleasure() > 0.0 && this.isWalking) {
            this.isWalking = false;
            this.getAct().act((CommandMessage)new SetWalk().setWalk(Boolean.valueOf(false)));
        } else if (this.myALMA.getCurrentMood(this.myName).getPleasure() < 0.0 && !this.isWalking) {
            this.isWalking = true;
            this.getAct().act((CommandMessage)new SetWalk().setWalk(Boolean.valueOf(true)));
        }
        if (this.myALMA.getDominantEmotion(this.myName).getType() == EmotionType.Joy && this.myALMA.getDominantEmotion(this.myName).getIntensity() > 0.45 && this.myALMA.getCurrentMood(this.myName).getPleasure() > 0.0) {
            if (this.navigation.isNavigating()) {
                this.navigation.stopNavigation();
            }
            this.getAct().act((CommandMessage)new Jump());
            return;
        }
        if (!this.navigation.isNavigating()) {
            this.targetNavPoint = this.pickNewRandomNavTarget();
            this.navigation.navigate((ILocated)this.targetNavPoint);
            return;
        }
    }

    private void sendMessageAboutEmotions() {
        String result = "";
        result = this.myALMA.getCurrentMood(this.myName).getPleasure() > 0.0 ? result + "I feel happy!" : result + "I feel sad!";
        Emotion dominantEmotion = this.myALMA.getDominantEmotion(this.myName);
        result = dominantEmotion != null ? result + " My dominant emotion is " + dominantEmotion.getType().toString() + " with intensity " + EmotionalBot.roundTwoDecimals(dominantEmotion.getIntensity()) + "!" : result + " No dominant emotion at this time.";
        this.getAct().act((CommandMessage)new SendMessage().setText(result).setFadeOut(Double.valueOf(3.0)).setGlobal(Boolean.valueOf(true)));
    }

    public void botKilled(BotKilled event) {
        this.isWalking = !this.isWalking;
    }

    private NavPoint pickNewRandomNavTarget() {
        this.getLog().severe("Picking new target navpoint.");
        Collection navPoints = this.getWorldView().getAll(NavPoint.class).values();
        int navPointIndex = this.random.nextInt(navPoints.size());
        int i = 0;
        for (NavPoint nav : navPoints) {
            if (i == navPointIndex) {
                return nav;
            }
            ++i;
        }
        throw new RuntimeException("No navpoint chosen. There are no navpoints in the list of known navpoints");
    }

    public static String roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("0.00");
        return twoDForm.format(d);
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(EmotionalBot.class, "EmotionalBot").setMain(true).startAgents(1);
    }
}

