/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.ctfbot;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.module.comm.PogamutJVMComm;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathAutoFixer;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UT2004ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.CTFBotParams;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.CloseInOnEnemy;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.GetEnemyFlag;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.GetHealth;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.GetItems;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.GetOurFlag;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.GoalManager;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;

@AgentScoped
public class CTFBot
extends UT2004BotModuleController<UT2004Bot> {
    @JProp
    public boolean shouldEngage = true;
    @JProp
    public boolean shouldPursue = true;
    @JProp
    public boolean shouldRearm = true;
    @JProp
    public boolean shouldCollectItems = true;
    @JProp
    public boolean shouldCollectHealth = true;
    @JProp
    public int healthLevel = 90;
    @JProp
    public int frags = 0;
    @JProp
    public int deaths = 0;
    protected GameInfo gameInfo;
    @JProp
    protected Location pathTarget;
    protected Player enemy = null;
    protected TabooSet<Item> tabooItems = null;
    protected GetItems getItemsGoal;
    protected boolean firstLogic = true;
    private UT2004PathAutoFixer autoFixer;
    protected GoalManager goalManager = null;
    protected final Heatup targetHU = new Heatup(5000L);
    protected int notMoving = 0;

    public CTFBotParams getParams() {
        if (!(this.bot.getParams() instanceof CTFBotParams)) {
            return null;
        }
        return (CTFBotParams)this.bot.getParams();
    }

    public Location getPathTarget() {
        return this.pathTarget;
    }

    @EventListener(eventClass=PlayerKilled.class)
    public void playerKilled(PlayerKilled event) {
        if (event.getKiller().equals((Object)this.info.getId())) {
            ++this.frags;
        }
        if (this.enemy == null) {
            return;
        }
        if (this.enemy.getId().equals((Object)event.getId())) {
            this.enemy = null;
        }
    }

    public void prepareBot(UT2004Bot bot) {
        this.tabooItems = new TabooSet(bot);
        this.autoFixer = new UT2004PathAutoFixer(bot, this.navigation.getPathExecutor(), this.fwMap, this.aStar, this.navBuilder);
        this.navigation.getPathExecutor().getState().addListener((FlagListener)new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                switch (changedValue.getState()) {
                    case STUCK: {
                        Item item = CTFBot.this.getItemsGoal.getItem();
                        if (item != null && CTFBot.this.pathTarget != null && item.getLocation().equals(CTFBot.this.pathTarget, 10.0)) {
                            CTFBot.this.tabooItems.add((Object)item, 10.0);
                        }
                        CTFBot.this.reset();
                        break;
                    }
                    case TARGET_REACHED: {
                        CTFBot.this.reset();
                    }
                }
            }
        });
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.MINIGUN, false);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.MINIGUN, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.LINK_GUN, false);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.LIGHTNING_GUN, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.SHOCK_RIFLE, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.ROCKET_LAUNCHER, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.LINK_GUN, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.ASSAULT_RIFLE, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.FLAK_CANNON, false);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.FLAK_CANNON, true);
        this.weaponPrefs.addGeneralPref((ItemType)UT2004ItemType.BIO_RIFLE, true);
        this.goalManager = new GoalManager(this.bot);
        this.goalManager.addGoal(new GetEnemyFlag(this));
        this.goalManager.addGoal(new GetOurFlag(this));
        this.goalManager.addGoal(new GetHealth(this));
        this.getItemsGoal = new GetItems(this);
        this.goalManager.addGoal(this.getItemsGoal);
        this.goalManager.addGoal(new CloseInOnEnemy(this));
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        this.gameInfo = gameInfo;
    }

    public Initialize getInitializeCommand() {
        if (this.getParams() == null) {
            return new Initialize();
        }
        return new Initialize().setDesiredSkill(Integer.valueOf(this.getParams().getSkillLevel())).setSkin(this.getParams().getBotSkin()).setTeam(this.getParams().getTeam());
    }

    public void botFirstSpawn(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
        PogamutJVMComm.getInstance().registerAgent((IObservingAgent)this.bot, self.getTeam());
    }

    public void botShutdown() {
        PogamutJVMComm.getInstance().unregisterAgent((IObservingAgent)this.bot);
    }

    public boolean goTo(ILocated target) {
        if (target == null) {
            this.log.info("goTo: null");
            return false;
        }
        this.log.info(String.format("goTo: %s %s", target.toString(), this.info.getLocation()));
        this.pathTarget = target.getLocation();
        this.navigation.navigate(target);
        return true;
    }

    public boolean goTo(Location target) {
        if (target == null) {
            this.log.info("goTo: null");
            return false;
        }
        this.log.info(String.format("goTo: %s %s", target.toString(), this.info.getLocation()));
        this.pathTarget = target.getLocation();
        this.navigation.navigate((ILocated)target);
        return true;
    }

    public boolean holdingOrSupporting() {
        FlagInfo ourFlag = this.getOurFlag();
        if (ourFlag == null) {
            return false;
        }
        UnrealId holderId = ourFlag.getHolder();
        if (holderId == null) {
            return false;
        }
        if (this.info.getId().equals((Object)holderId)) {
            return true;
        }
        Player holder = this.players.getPlayer(holderId);
        return holder.getTeam() == this.info.getTeam().intValue() && this.getInfo().getDistance((ILocated)holder) < 60.0;
    }

    public void updateFight() {
        if (this.enemy == null || this.enemy.isVisible()) {
            this.enemy = this.getPlayers().getNearestVisibleEnemy();
        }
        Player nearest_target = this.players.getNearestVisibleEnemy();
        if (this.enemy == null) {
            this.enemy = nearest_target;
        } else if (nearest_target == this.enemy) {
            this.targetHU.heat();
        } else if (this.targetHU.isCool()) {
            this.enemy = nearest_target;
        }
        this.shoot();
    }

    public void updateFight(Player newEnemy) {
        if (newEnemy == null || !newEnemy.isVisible()) {
            newEnemy = this.getPlayers().getNearestVisibleEnemy();
        }
        this.enemy = newEnemy;
        this.shoot();
    }

    public void shoot() {
        if (this.enemy != null && this.enemy.isVisible()) {
            this.shoot.shoot(this.weaponPrefs, (ILocated)this.enemy, new ItemType[0]);
        } else {
            this.shoot.stopShoot();
            this.enemy = null;
        }
    }

    protected void reset() {
        this.notMoving = 0;
        this.enemy = null;
        this.navigation.stopNavigation();
    }

    public NavPoint getOurFlagBase() {
        return this.ctf.getOurBase();
    }

    public NavPoint getEnemyFlagBase() {
        return this.ctf.getEnemyBase();
    }

    public FlagInfo getOurFlag() {
        return this.ctf.getOurFlag();
    }

    public FlagInfo getEnemyFlag() {
        return this.ctf.getEnemyFlag();
    }

    public Player getEnemy() {
        return this.enemy;
    }

    public void logic() {
        this.goalManager.executeBestGoal();
        this.log.info("OUR FLAG:                      " + this.ctf.getOurFlag());
        this.log.info("OUR BASE:                      " + this.ctf.getOurBase());
        this.log.info("CAN OUR TEAM POSSIBLY SCORE:   " + this.ctf.canOurTeamPossiblyScore());
        this.log.info("CAN OUR TEAM SCORE:            " + this.ctf.canOurTeamScore());
        this.log.info("CAN BOT SCORE:                 " + this.ctf.canBotScore());
        this.log.info("ENEMY FLAG:                    " + this.ctf.getEnemyFlag());
        this.log.info("ENEMY BASE:                    " + this.ctf.getEnemyBase());
        this.log.info("CAN ENEMY TEAM POSSIBLY SCORE: " + this.ctf.canEnemyTeamPossiblyScore());
        this.log.info("CAN ENEMY TEAM SCORE:          " + this.ctf.canEnemyTeamScore());
    }

    public TabooSet<Item> getTaboo() {
        return this.tabooItems;
    }

    public void botKilled(BotKilled event) {
        this.reset();
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(CTFBot.class, "CTFBot").setMain(true).startAgents(new UT2004BotParameters[]{new CTFBotParams().setBotSkin("HumanMaleA.MercMaleC").setSkillLevel(5).setTeam(0).setAgentId((IAgentId)new AgentId("CTFBot"))});
    }
}

