/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.ctfbot;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.CTFBot;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.Goal;
import java.util.LinkedList;
import java.util.Set;

public class GetItems
extends Goal {
    protected Item item = null;
    protected LinkedList<Item> itemsToRunAround;

    public GetItems(CTFBot bot) {
        super(bot);
    }

    @Override
    public void perform() {
        boolean atLocation = false;
        if (this.item != null && (atLocation = this.bot.getInfo().atLocation((ILocated)this.item))) {
            this.bot.getLog().info("Abandoning item.");
            this.bot.getTaboo().add((Object)this.item);
            this.item = null;
        }
        if (this.item == null || atLocation || !this.bot.getItems().getVisibleItems().containsKey(this.item.getId())) {
            Set items = this.bot.getTaboo().filter(this.itemsToRunAround);
            if (items.size() != 0) {
                this.item = (Item)items.iterator().next();
                this.bot.getLog().severe(String.format("Chosen item: %s", this.item));
                if (!this.bot.goTo((ILocated)this.item)) {
                    this.bot.getLog().info("Failed goTo");
                    this.bot.getTaboo().add((Object)this.item);
                }
            } else {
                this.bot.getLog().severe("Taboo clear");
                this.bot.getTaboo().clear();
            }
        } else {
            this.bot.getLog().severe("Item is ok");
            this.bot.goTo((ILocated)this.item);
        }
        this.bot.updateFight();
    }

    @Override
    public double getPriority() {
        this.itemsToRunAround = new LinkedList(this.bot.getItems().getVisibleItems().values());
        return 8 + this.bot.getItems().getVisibleItems().size();
    }

    @Override
    public boolean hasFailed() {
        return false;
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void abandon() {
        this.bot.getLog().info("abandoning GetItems");
        this.item = null;
    }

    public Item getItem() {
        return this.item;
    }
}

