/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.ctfbot;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.CTFBot;
import cz.cuni.amis.pogamut.ut2004.examples.ctfbot.Goal;

public class GetOurFlag
extends Goal {
    private static final double CAPTURE_SUPPORT_DISTANCE = 200.0;
    protected Player enemy = null;
    Location flagLocation;

    public GetOurFlag(CTFBot bot) {
        super(bot);
    }

    @Override
    public void perform() {
        UnrealId holderId = null;
        if (this.bot.getOurFlag() != null) {
            if (this.bot.getOurFlag().getLocation() != null) {
                this.flagLocation = this.bot.getOurFlag().getLocation();
            }
            if (this.flagLocation != null) {
                this.enemy = this.bot.getPlayers().getPlayer(holderId);
                this.bot.getLog().info(String.format("FlagLocation: %s %s %.2f", this.flagLocation, this.bot.getInfo().getLocation(), this.bot.getInfo().getDistance((ILocated)this.flagLocation)));
                if (this.enemy != null) {
                    this.bot.goTo((ILocated)this.enemy);
                    if (this.enemy.isVisible()) {
                        this.bot.updateFight(this.enemy);
                        return;
                    }
                } else {
                    this.bot.goTo(this.flagLocation);
                }
            } else {
                this.bot.goTo(this.bot.getEnemyFlagBase());
            }
        }
        this.bot.updateFight();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double getPriority() {
        if (this.bot.getOurFlag() == null || this.bot.getOurFlag().getState().equalsIgnoreCase("home")) {
            return 0.0;
        }
        if (this.bot.getEnemyFlag() == null) return 20.0;
        UnrealId holderId = this.bot.getEnemyFlag().getHolder();
        if (holderId != null) {
            Player holder = (Player)this.bot.getPlayers().getFriends().get(holderId);
            if (this.bot.getPlayers().getFriends().size() <= 1) return 55.0;
            if (!holderId.equals((Object)this.bot.getInfo().getId()) && !(holder.getLocation().getDistance(this.bot.getInfo().getLocation()) < 200.0)) return 20.0;
            return 0.0;
        }
        if (this.bot.getPlayers().getFriends().size() <= 1) return 55.0;
        return 0.0;
    }

    @Override
    public boolean hasFailed() {
        return false;
    }

    @Override
    public boolean hasFinished() {
        return false;
    }

    @Override
    public void abandon() {
    }
}

