/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples.navmeshdebugbot;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathExecutorState;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.ManualControl;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.UT2004Skins;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutorStuckState;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.INavMeshDraw;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.FunnelDebug;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GlobalChat;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FileAppender;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.Tuple2;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import javax.vecmath.Vector3d;
import org.apache.commons.io.FileUtils;

@AgentScoped
public class NavMeshDebugBot
extends UT2004BotModuleController {
    private static int INSTANCE = 0;
    public static final boolean MANUAL_CONTROL = true;
    public static final boolean AUTOLOAD_LEVEL_GEOMETRY = true;
    private static final long TIMESTAMP = System.currentTimeMillis();
    private long lastLogicTime = -1L;
    private long logicIterationNumber = 0L;
    private INavMeshDraw navMeshDraw;
    private boolean runLastFailures = true;
    private boolean restartNavigation = true;
    private boolean auto = true;
    private boolean navigateItems = true;
    private boolean autoclear = false;
    private boolean drawNavMesh = false;
    private boolean synthTest = false;
    private NavPoint targetNavpoint;
    private Set<NavPoint> visited = new HashSet<NavPoint>();
    private List<Color> pathColors = new ArrayList<Color>();
    private int lastPathColor = -1;
    private ManualControl manualControl;
    private FlagListener<IPathExecutorState> pathExecutorStateListener;
    private boolean lastManualActive = false;
    private boolean nextFailureRunning = true;
    private int lastFailureIndex = -1;
    private List<PathInfo> lastFailures = new ArrayList<PathInfo>();
    List<PathInfo> failedPaths = new ArrayList<PathInfo>();
    PathInfo pathInfo = new PathInfo();

    public void prepareBot(UT2004Bot bot) {
        super.prepareBot(bot);
        for (int shade = 0; shade <= 255; shade += 10) {
            float[] hsb = new float[3];
            Color.RGBtoHSB(255, shade, shade, hsb);
            this.pathColors.add(Color.getHSBColor(hsb[0], hsb[1], hsb[2]));
        }
        Collections.shuffle(this.pathColors);
    }

    public void initializeController(UT2004Bot bot) {
        super.initializeController(bot);
        this.navMeshDraw = this.navMeshModule.getNavMeshDraw();
        this.levelGeometryModule.setAutoLoad(true);
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setName("NavMeshDebugBot-" + INSTANCE++).setSkin(UT2004Skins.getSkin());
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        super.botInitialized(gameInfo, currentConfig, init);
        this.loadLastFailures();
        this.log.warning("INITIALIZING MANUAL CONTROL WINDOW");
        this.manualControl = new ManualControl(this.bot, this.info, this.body, this.levelGeometryModule, this.draw, this.navPointVisibility, this.navMeshModule);
    }

    private void sayGlobal(String msg) {
        this.body.getCommunication().sendGlobalTextMessage(msg);
        this.log.info(msg);
    }

    @EventListener(eventClass=GlobalChat.class)
    private void teamChat(GlobalChat msg) {
        if (msg.getText().toLowerCase().equals("next")) {
            this.restartNavigation = true;
            this.sayGlobal("Requesting new navigation target...");
        } else if (msg.getText().toLowerCase().startsWith("drawnavmesh")) {
            String[] parts = msg.getText().split(" ");
            this.navMeshDraw.draw(true, parts.length > 1 ? Boolean.parseBoolean(parts[1]) : false);
            this.sayGlobal("NAVMESH DRAWN");
            if (this.autoclear) {
                this.autoclear = false;
                this.sayGlobal("AUTO-CLEAR OFF, say autoclear to re-enable");
            }
        } else if (msg.getText().toLowerCase().startsWith("autoclear")) {
            this.autoclear = !this.autoclear;
            this.sayGlobal("Flipping AUTO-CLEAR, new value is " + this.autoclear);
        } else if (msg.getText().toLowerCase().startsWith("auto")) {
            this.auto = !this.auto;
            this.sayGlobal("Flipping AUTO navigation, new value is " + this.auto);
        } else if (msg.getText().toLowerCase().startsWith("items")) {
            this.navigateItems = !this.navigateItems;
            this.sayGlobal("Flipping ITEMS navigation, new value is " + this.navigateItems);
        } else if (msg.getText().toLowerCase().startsWith("reset")) {
            this.visited.clear();
            this.sayGlobal("VISITED NAVPOINTS CLEARED");
        } else if (msg.getText().toLowerCase().startsWith("clear")) {
            this.draw.clearAll();
            this.sayGlobal("ALL CLEARED!");
        } else if (msg.getText().toLowerCase().startsWith("synthtest")) {
            this.draw.clearAll();
            this.navigation.stopNavigation();
            this.pathFindingTest();
        } else if (msg.getText().toLowerCase().startsWith("runlastfailures")) {
            this.runLastFailuresToggle();
        }
    }

    @ObjectClassEventListener(eventClass=WorldObjectAppearedEvent.class, objectClass=Item.class)
    public void itemAppearedListener(WorldObjectAppearedEvent<Item> event) {
        this.sayGlobal("Item at " + ((Item)event.getObject()).getNavPointId() + " APPEARED");
    }

    @ObjectClassEventListener(eventClass=WorldObjectDisappearedEvent.class, objectClass=Item.class)
    public void itemDisappearedListener(WorldObjectDisappearedEvent<Item> event) {
        this.sayGlobal("Item at " + ((Item)event.getObject()).getNavPointId() + " DISappeared");
    }

    @ObjectClassEventListener(eventClass=WorldObjectAppearedEvent.class, objectClass=NavPoint.class)
    public void NavPointAppearedListener(WorldObjectAppearedEvent<NavPoint> event) {
        this.sayGlobal("NavPoint " + event.getId() + " APPEARED");
    }

    @ObjectClassEventListener(eventClass=WorldObjectDisappearedEvent.class, objectClass=NavPoint.class)
    public void NavPointDisappearedListener(WorldObjectDisappearedEvent<NavPoint> event) {
        this.sayGlobal("NavPoint " + event.getId() + " DISappeared");
    }

    public void beforeFirstLogic() {
        this.pathExecutorStateListener = new FlagListener<IPathExecutorState>(){

            public void flagChanged(IPathExecutorState changedValue) {
                NavMeshDebugBot.this.pathExecutorStateChanged(changedValue);
            }
        };
        this.navigation.getPathExecutor().getState().addListener(this.pathExecutorStateListener);
        this.sayGlobal("AUTO NAVIGATION: " + this.auto);
        this.sayGlobal("NAVIGATE ONLY ITEMS: " + this.navigateItems);
        this.sayGlobal("AUTO-DRAW-CLEAR: " + this.autoclear);
        this.sayGlobal("DRAW-NAVMESH: " + this.drawNavMesh);
        if (this.drawNavMesh) {
            this.navMeshDraw.draw(this.drawNavMesh, true);
        }
        this.sayGlobal("LEVEL GEOMETRY: " + (this.levelGeometryModule.isInitialized() ? "LOADED" : "N/A"));
        this.sayGlobal("FOV: " + this.config.getVisionFOV());
        this.navPointVisibility.getLog().setLevel(Level.FINE);
    }

    public void logic() throws PogamutException {
        if (!this.navMeshModule.isInitialized()) {
            this.sayGlobal("NAV MESH MODULE NOT INITIALIZED?");
            this.sayGlobal("Missing navmesh for: " + this.game.getMapName() + " ?");
            return;
        }
        if (this.manualControl != null && this.manualControl.isActive()) {
            if (!this.lastManualActive) {
                this.sayGlobal("MANUAL CONTROL");
                this.lastManualActive = true;
            }
            this.lastLogicTime = System.currentTimeMillis();
            return;
        }
        if (this.lastManualActive) {
            this.sayGlobal("MANUAL CONTROL DEACTIVATED");
            this.lastManualActive = false;
        }
        if (this.synthTest) {
            this.synthTest = false;
            this.pathFindingTest();
            return;
        }
        if (this.runLastFailures) {
            this.runLastFailures();
            return;
        }
        if (this.navigation.isNavigating()) {
            return;
        }
        if (this.targetNavpoint != null) {
            if (this.info.atLocation((ILocated)this.targetNavpoint)) {
                this.sayGlobal("ARRIVED TO TARGET NAVPOINT");
            } else {
                this.sayGlobal("NAVIGATION FAILED | DELTA = " + this.targetNavpoint.getLocation().getDistance(this.info.getLocation()));
            }
            this.targetNavpoint = null;
        }
        if (!this.auto && !this.restartNavigation) {
            return;
        }
        if (this.restartNavigation) {
            this.restartNavigation = false;
        }
        this.sayGlobal("New navigation request...");
        if (this.navPoints.getNavPoints().size() == this.visited.size()) {
            this.sayGlobal("Visited all navpoints - restarting...");
            this.visited.clear();
        }
        this.targetNavpoint = (NavPoint)MyCollections.getRandom((List)MyCollections.getFiltered(this.navPoints.getNavPoints().values(), (IFilter)new IFilter<NavPoint>(){

            public boolean isAccepted(NavPoint object) {
                return !NavMeshDebugBot.this.visited.contains(object) && (!NavMeshDebugBot.this.navigateItems || object.isInvSpot());
            }
        }));
        this.visited.add(this.targetNavpoint);
        this.startNavigation((ILocated)this.targetNavpoint);
    }

    private void startNavigation(ILocated target) {
        this.navigation.navigate((ILocated)target.getLocation());
        NavPoint targetNavpoint = this.navPoints.getNearestNavPoint(target);
        if (this.navigation.isNavigating()) {
            this.sayGlobal("NEW target: " + (targetNavpoint != null ? targetNavpoint.getId().getStringId() : target.getLocation()));
            if (this.autoclear) {
                this.draw.clearAll();
            }
            Color pathColor = this.pathColors.get(++this.lastPathColor % this.pathColors.size());
            this.draw.drawPolyLine(pathColor, (Collection)this.navigation.getCurrentPathDirect());
            this.draw.drawCube(pathColor, target, 20.0);
        } else {
            this.sayGlobal("NO PATH TO: " + (targetNavpoint != null ? targetNavpoint.getId().getStringId() : target.getLocation()));
        }
    }

    private void pathFindingTest() {
        this.sayGlobal("SYNTH TESTING! Hanging up the bot logic... see logs.");
        this.log.warning("===========================");
        this.log.warning("PATH-FINDING STRESS TESTING");
        this.log.warning("===========================");
        this.log.warning("  +-- map: " + this.game.getMapName());
        this.log.warning("  +-- computing extense...");
        Vector3d mins = new Vector3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Vector3d maxs = new Vector3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (NavPoint np : this.navPoints.getNavPoints().values()) {
            if (np.getLocation().getX() > maxs.x) {
                maxs.x = np.getLocation().getX();
            }
            if (np.getLocation().getY() > maxs.y) {
                maxs.y = np.getLocation().getY();
            }
            if (np.getLocation().getZ() > maxs.z) {
                maxs.z = np.getLocation().getZ();
            }
            if (np.getLocation().getX() < mins.x) {
                mins.x = np.getLocation().getX();
            }
            if (np.getLocation().getY() < mins.y) {
                mins.y = np.getLocation().getY();
            }
            if (!(np.getLocation().getZ() < mins.z)) continue;
            mins.z = np.getLocation().getZ();
        }
        int randomSeed = 1;
        double step = 31.0;
        this.log.warning("  +-- CUBE[ " + mins + " - " + maxs + "]");
        this.log.warning("  +-- TESTING! Step is: " + step + "; random seed is " + randomSeed);
        int extenseX = (int)Math.floor((maxs.x - mins.x) / step);
        int extenseY = (int)Math.floor((maxs.y - mins.y) / step);
        int extenseZ = (int)Math.floor((maxs.z - mins.z) / step);
        this.log.warning("  +-- Start locations (2D)    about: " + extenseX + "*" + extenseY + " = " + extenseX * extenseY);
        this.log.warning("  +-- Start locations (total) about: " + extenseX + "*" + extenseY + "*" + extenseZ + " = " + extenseX * extenseY * extenseZ);
        Random random = new Random(randomSeed);
        int tests = 0;
        int fails = 0;
        int notExists = 0;
        ArrayList<Tuple2> failures = new ArrayList<Tuple2>();
        for (double x = mins.x; x < maxs.x + step; x += step) {
            for (double y = mins.y; y < maxs.y + step; y += step) {
                for (double z = mins.z; z < maxs.z + step; z += step) {
                    Location start = new Location(x, y, z);
                    if (this.navMeshModule.getDropGrounder().tryGround((ILocated)start) == null) continue;
                    Location target = null;
                    while (target == null || this.navMeshModule.getDropGrounder().tryGround(target) == null) {
                        target = new Location(random.nextDouble() * (maxs.x - mins.x) + mins.x, random.nextDouble() * (maxs.y - mins.y) + mins.y, random.nextDouble() * (maxs.z - mins.z) + mins.z);
                    }
                    this.log.info("  +-- Path-finding: " + start + " -> " + target + " ...");
                    ++tests;
                    try {
                        PrecomputedPathFuture pf = this.navMeshModule.getAStarPathPlanner().computePath((ILocated)start, target);
                        if (pf.get() == null) {
                            this.log.info("    +-- NOT EXISTS!");
                            ++notExists;
                            continue;
                        }
                        this.log.info("    +-- Path-length " + pf.get().size());
                        continue;
                    }
                    catch (Exception e) {
                        this.log.info(ExceptionToString.process((String)("AT " + this.game.getMapName() + " FAILED TO COMPUTE THE PATH: " + start + " -> " + target), (Throwable)e));
                        ++fails;
                        failures.add(new Tuple2((Object)start, (Object)target));
                    }
                }
            }
        }
        for (NavPoint np1 : this.navPoints.getNavPoints().values()) {
            for (NavPoint np2 : this.navPoints.getNavPoints().values()) {
                this.log.info("  +-- Path-finding: " + np1.getId().getStringId() + " -> " + np2.getId().getStringId() + " ...");
                ++tests;
                try {
                    PrecomputedPathFuture pf = this.navMeshModule.getAStarPathPlanner().computePath((ILocated)np1, (ILocated)np2);
                    if (pf.get() == null) {
                        this.log.info("    +-- NOT EXISTS!");
                        ++notExists;
                        continue;
                    }
                    this.log.info("    +-- Path-length " + pf.get().size());
                }
                catch (Exception e) {
                    this.log.info(ExceptionToString.process((String)("AT " + this.game.getMapName() + " FAILED TO COMPUTE THE PATH: " + np1.getId().getStringId() + " -> " + np2.getId().getStringId()), (Throwable)e));
                    ++fails;
                    failures.add(new Tuple2((Object)np1.getLocation(), (Object)np2.getLocation()));
                }
            }
        }
        this.log.warning("RESULT for " + this.game.getMapName() + ": " + (tests - fails) + " / " + tests + " SUCCEEDED, " + notExists + " / " + tests + " paths not-exist");
        if (fails > 0) {
            if (fails == 1) {
                this.log.warning("THERE WAS 1 FAILURE!");
            } else {
                this.log.warning("THERE WERE " + fails + " FAILURES!");
            }
            for (Tuple2 failure : failures) {
                this.log.warning("  +-- FAILED TO COMPUTE THE PATH: " + failure.getFirst() + " -> " + failure.getSecond());
                FunnelDebug.debug = true;
                FunnelDebug.draw = this.draw;
                Location start = (Location)failure.getFirst();
                Location target = (Location)failure.getSecond();
                this.navMeshModule.getAStarPathPlanner().computePath((ILocated)start, (ILocated)target);
            }
            throw new RuntimeException("PATH-FINDING IS FAILING FOR THIS MAP !!!");
        }
    }

    private void loadLastFailures() {
        List lines;
        ArrayList<File> candidates = new ArrayList<File>();
        for (File file : new File(".").listFiles()) {
            String name = file.getName();
            if (!name.contains(this.game.getMapName())) continue;
            candidates.add(file);
        }
        if (candidates.size() == 0) {
            return;
        }
        Collections.sort(candidates, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        File file = (File)candidates.get(candidates.size() - 1);
        try {
            lines = FileUtils.readLines((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read file: " + file.getAbsolutePath(), e);
        }
        for (String line : lines) {
            this.lastFailures.add(PathInfo.deserialize(line));
        }
        if (this.lastFailures.size() > 0 && this.runLastFailures) {
            this.sayGlobal("loadLastFailure(): Clear All!");
            this.draw.clearAll();
        }
    }

    private void runLastFailuresToggle() {
        if (this.runLastFailures) {
            this.runLastFailures = false;
            this.navigation.stopNavigation();
            return;
        }
        this.runLastFailures = true;
        this.nextFailureRunning = true;
        this.lastFailureIndex = -1;
        this.navigation.stopNavigation();
    }

    private void runLastFailures() {
        if (this.navigation.isNavigating()) {
            return;
        }
        if (this.nextFailureRunning) {
            ++this.lastFailureIndex;
            this.nextFailureRunning = false;
        }
        if (this.lastFailureIndex >= this.lastFailures.size()) {
            this.runLastFailures = false;
            this.sayGlobal("NO MORE LAST FAILURES!");
            return;
        }
        PathInfo info = this.lastFailures.get(this.lastFailureIndex);
        if (!this.info.atLocation(info.pathFrom)) {
            this.sayGlobal("RESPAWNING TO THE BEGINNING OF THE " + (this.lastFailureIndex + 1) + "/" + this.lastFailures.size() + " LAST FAILURE");
            this.act.act((CommandMessage)new Respawn(this.info.getId(), info.pathFrom.getLocation(), this.info.getRotation()));
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        this.sayGlobal("NAVIGATING " + (this.lastFailureIndex + 1) + "/" + this.lastFailures.size() + " LAST FAILURE");
        this.draw.clearAll();
        this.drawPathInfo(info);
        this.startNavigation(info.pathTo);
        this.nextFailureRunning = true;
    }

    private void drawPathInfo(PathInfo info) {
        int size;
        for (size = 10; size < 40; size += 10) {
            this.draw.drawCube(Color.BLUE, info.pathFrom, (double)size);
        }
        for (size = 10; size < 40; size += 10) {
            this.draw.drawCube(Color.RED, info.stuckLocation, (double)size);
        }
        this.draw.drawPolyLine(Color.WHITE, info.path);
        for (size = 10; size < 40; size += 10) {
            this.draw.drawCube(Color.GREEN, info.pathTo, (double)size);
        }
    }

    protected void pathExecutorStateChanged(IPathExecutorState changedValue) {
        switch (changedValue.getState()) {
            case FOLLOW_PATH_CALLED: {
                this.pathInfo.lastNavLocations.clear();
                NavPoint curr = this.info.getNearestNavPoint(100.0);
                this.pathInfo.pathFrom = curr == null ? this.info.getLocation() : curr;
                this.pathInfo.lastNavLocations.add(this.pathInfo.pathFrom);
                this.pathInfo.pathTo = this.navigation.getCurrentTarget();
                this.pathInfo.path.clear();
                for (ILocated point : this.navigation.getPathExecutor().getPath()) {
                    this.pathInfo.path.add(point);
                }
                break;
            }
            case SWITCHED_TO_ANOTHER_PATH_ELEMENT: {
                if (this.navigation.getPathExecutor().getPathElement() != null) {
                    this.pathInfo.lastNavLocations.add((ILocated)this.navigation.getPathExecutor().getPathElement());
                }
                while (this.pathInfo.lastNavLocations.size() > 3) {
                    this.pathInfo.lastNavLocations.remove(0);
                }
                break;
            }
            case STUCK: {
                UT2004PathExecutorStuckState stuck = (UT2004PathExecutorStuckState)changedValue;
                this.stuck(stuck);
            }
        }
    }

    private void stuck(UT2004PathExecutorStuckState stuck) {
        if (this.pathInfo.pathFrom == null) {
            return;
        }
        this.pathInfo.stuckInfo = stuck;
        this.pathInfo.stuckLocation = this.info.getLocation();
        File file = new File(this.game.getMapName() + "-" + TIMESTAMP + ".stucks.txt");
        FileAppender.appendToFile((File)file, (String)this.pathInfo.serialize());
        this.failedPaths.add(this.pathInfo);
        this.pathInfo = new PathInfo();
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(NavMeshDebugBot.class, "NavBot  ").setMain(true).startAgents(1);
    }

    private static class PathInfo {
        public List<ILocated> lastNavLocations = new ArrayList<ILocated>(4);
        public List<ILocated> path = new ArrayList<ILocated>();
        public ILocated pathFrom;
        public ILocated pathTo;
        public UT2004PathExecutorStuckState stuckInfo;
        public ILocated stuckLocation;

        private PathInfo() {
        }

        public String serialize() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.pathFrom.getLocation().toString());
            sb.append("|");
            sb.append(this.pathTo.getLocation().toString());
            sb.append("|");
            sb.append(this.path.size());
            sb.append("|");
            for (ILocated loc : this.path) {
                sb.append(loc.getLocation().toString());
                sb.append("|");
            }
            sb.append(this.lastNavLocations.size());
            sb.append("|");
            for (ILocated loc : this.lastNavLocations) {
                sb.append(loc.getLocation().toString());
                sb.append("|");
            }
            sb.append(this.stuckInfo.getStuckDetector().getClass().getSimpleName());
            sb.append("|");
            sb.append(this.stuckLocation.getLocation());
            return sb.toString();
        }

        public static PathInfo deserialize(String row) {
            PathInfo result = new PathInfo();
            String[] parts = row.split("\\|");
            result.pathFrom = new Location(parts[0]);
            result.pathTo = new Location(parts[1]);
            int pathSize = Integer.parseInt(parts[2]);
            for (int i = 0; i < pathSize; ++i) {
                result.path.add((ILocated)new Location(parts[3 + i]));
            }
            int lastSize = Integer.parseInt(parts[3 + pathSize]);
            for (int i = 0; i < lastSize; ++i) {
                result.path.add((ILocated)new Location(parts[4 + pathSize + i]));
            }
            result.stuckLocation = new Location(parts[5 + pathSize + lastSize]);
            return result;
        }
    }
}

